package com.ishop.mobile.api;

import com.ishop.merchant.Constants;
import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.UserClosingConfigVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * 用户结算管理，包含：提现。
 * @author 时克英
 * @date 2023-09-19
 */
@RestController
@RequestMapping("/front/retail/store")
public class RetailStoreApi extends BaseApi {

    /**
     * 获取用户结算配置
     * @return
     */
    @RequestMapping(value = "/user/closing/config", method = RequestMethod.GET)
    public ResponseValue getClosingConfig(){

        EbUser user = this.getCurrentEbUser();

        // 提现最低金额
        String minPrice = this.getArgumentVariable(Constants.RETAIL_STORE_EXTRACT_MIN_PRICE).getStringValue();
        // 冻结天数
        String freezeDay = this.getArgumentVariable(Constants.RETAIL_STORE_BROKERAGE_FREEZING_TIME).getStringValue();
        // 获取提现银行
        String bank = this.getArgumentVariable(Constants.RETAIL_STORE_EXTRACT_BANK).getStringValue();
        // 可提现佣金
        double brokerage = user.getBrokeragePrice();
        // 冻结佣金
        double freezeBrokerage = this.getUserBrokerageService().queryFreezePrice(user.getId());

        UserClosingConfigVo vo = new UserClosingConfigVo();
        vo.setMinPrice(minPrice);
        vo.setBrokerage(brokerage);
        vo.setFreezeBrokerage(freezeBrokerage);
        vo.setFreezeDay(freezeDay);
        if (StringUtils.isNotEmpty(bank)) {
            vo.setBankList(StringUtils.asList(StringUtils.commaDelimitedListToStringArray(bank)));
        }
        return ResponseValue.success(vo);
    }

}
