package com.ishop.mobile.api;

import com.iplatform.base.WechatConstants;
import com.iplatform.core.BeanContextAware;
import com.ishop.merchant.Constants;
import com.ishop.merchant.PayConstants;
import com.ishop.merchant.util.PayUtils;
import com.ishop.mobile.BaseApi;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.pay.Order;
import com.walker.pay.PayEngineManager;
import com.walker.pay.wechat.v2.H5ResponsePay;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

//@RestController
//@RequestMapping("/test/pay")
@Deprecated
public class TestMobileApi extends BaseApi {

    @RequestMapping("/h5")
    public ResponseValue h5() throws Exception{
//        DefaultOrder order = new DefaultOrder();
//        order.setServiceProvider(ServiceProvider.Wechat);
//        order.setId(NumberGenerator.getLongSequenceNumber());
//        order.setCreateTime(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
//        order.setPayType(PayType.H5);
//        order.setPayDefinitionId("Wechat_v2");
//        order.setTotalMoney(1);
//        order.setNotifyUrl("http://101.43.168.96:8082/admin/pay/notify/wx_v2/orderNotify");
//        order.setIp("127.0.0.1");
//        order.setNonce(StringUtils.generateRandomNumber(6));
//        order.setTitle("h5支付商品");
//        order.setAttach("微信公众号支付");
//        order.setBuyerId("oIydh5wC4wpmHjkmdk0cvAT9spFM");

        String apiDomain = this.getArgumentVariable(Constants.CONFIG_KEY_API_URL).getStringValue();
        String siteName = this.getArgumentVariable(Constants.CONFIG_KEY_SITE_NAME).getStringValue();
        String signKey = this.getArgumentVariable(WechatConstants.WECHAT_PAY_PUBLIC_KEY).getStringValue();

        Order platformPayOrder = PayUtils.acquirePlatformOrderH5WechatV2(1
                , NumberGenerator.getLongSequenceNumber(), "十一电商", "微信公众号支付", "127.0.0.1"
                , apiDomain + PayConstants.WX_PAY_NOTIFY_API_URI, "oIydh5wC4wpmHjkmdk0cvAT9spFM");


        PayEngineManager payEngineManager = BeanContextAware.getBeanByType(PayEngineManager.class);
        H5ResponsePay responsePay = (H5ResponsePay) payEngineManager.generatePrepareOrder(platformPayOrder);
        return ResponseValue.success(responsePay.getPrepayId());
    }
}
