package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.vo.FileResultVo;
import com.walker.file.FileInfo;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("/front/upload")
public class UploadApi extends BaseApi {

    /**
     * 移动端上传图片。
     * @param multipart
     * @param model 模块:用户user,商品product,微信wechat,news文章，该属性仅为了拼接路径，暂时未使用
     * @param pid 分类ID:0编辑器,1商品图片,2拼团图片,3砍价图片,4秒杀图片,5文章图片,6组合数据图,7前台用户,8微信系列, ange[0,1,2,3,4,5,6,7,8]
     * @return
     * @date 2023-07-03
     */
//    @ApiImplicitParam(name = "model", value = "模块 用户user,商品product,微信wechat,news文章"),
//    @ApiImplicitParam(name = "pid", value = "分类ID 0编辑器,1商品图片,2拼团图片,3砍价图片,4秒杀图片,5文章图片,6组合数据图,7前台用户,8微信系列 ", allowableValues = "range[0,1,2,3,4,5,6,7,8]")
    @RequestMapping(value = "/image", method = RequestMethod.POST)
    public ResponseValue uploadImage(MultipartFile multipart, String model, Integer pid){
        try {
            FileInfo fileInfo = this.uploadFileToRemote(multipart, model, pid, String.valueOf(Constants.OWNER_PLATFORM), Constants.UPLOAD_AFTER_IMAGE_KEYWORD);
            FileResultVo fileResultVo = VoUtils.acquireFileResultVo(fileInfo, multipart.getContentType(), this.getCdnUrl());
            return ResponseValue.success(fileResultVo);

        } catch (Exception e) {
            logger.error("图片上传失败：" + model + ", pid=" + pid, e);
            return ResponseValue.error("图片上传失败：" + e.getMessage());
//            throw new PlatformRuntimeException("上传图片失败：" + e.getMessage(), e);
        }
    }

    /**
     * 上传一般文件
     * @param multipart
     * @param model
     * @param pid
     * @return
     */
    @RequestMapping(value = "/file", method = RequestMethod.POST)
    public ResponseValue uploadFile(MultipartFile multipart, String model, Integer pid){
        try {
            FileInfo fileInfo = this.uploadFileToRemote(multipart, model, pid, String.valueOf(Constants.OWNER_PLATFORM), Constants.UPLOAD_AFTER_FILE_KEYWORD);
            FileResultVo fileResultVo = VoUtils.acquireFileResultVo(fileInfo, multipart.getContentType(), this.getCdnUrl());
            return ResponseValue.success(fileResultVo);

        } catch (Exception e) {
            logger.error("文件上传失败：" + model + ", pid=" + pid, e);
            return ResponseValue.error("文件上传失败：" + e.getMessage());
//            throw new PlatformRuntimeException("上传文件失败：" + e.getMessage(), e);
        }
    }
}
