package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbUserAddress;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/front/address")
public class UserAddressApi extends BaseApi {

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(){
        return ResponseValue.success(this.getUserAddressService().queryUserAllAddressList(this.getCurrentUserId()));
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseValue create(@RequestBody EbUserAddress address){
        if(address == null
                || StringUtils.isEmpty(address.getRealName()) || StringUtils.isEmpty(address.getPhone())
                || StringUtils.isEmpty(address.getDetail())){
            return ResponseValue.error("地址信息不完整");
        }
        address.setUid(this.getCurrentUserId());
        return ResponseValue.success(this.getUserAddressService().execInsertUserAddress(address));
    }

    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public ResponseValue detail(@PathVariable(value = "id") Long id){
        if(id == null || id.longValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        return ResponseValue.success(this.getUserAddressService().get(new EbUserAddress(id)));
    }
}
