package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.iplatform.base.util.PlatformRSAUtils;
import com.iplatform.model.po.S_user_core;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.UserEditRequest;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbUser;
import com.ishop.model.request.PasswordRequest;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/front/user")
public class UserApi extends BaseApi {

    /**
     * 手机号修改密码。
     * <pre>
     *     1) 短信验证码方法是用了，登录统一的发送验证码，无需重复编码。
     * </pre>
     * @return
     * @date 2023-09-20
     */
    @RequestMapping(value = "/register/reset", method = RequestMethod.POST)
    public ResponseValue editPassword(@RequestBody PasswordRequest request){
        if(request == null
                || StringUtils.isEmpty(request.getCaptcha())
                || StringUtils.isEmpty(request.getPassword())){
            return ResponseValue.error("新密码或验证码必须输入");
        }
        if(StringUtils.isEmpty(request.getUuid())){
            return ResponseValue.error("验证码标识不存在(uuid)");
        }

        boolean smsCodeSuccess = this.validateSmsCode(request.getCaptcha(), request.getUuid());
        if(!smsCodeSuccess){
            return ResponseValue.error("验证码错误");
        }

        long userId = this.getCurrentUserId();

        // 2023-09-20 uniapp端使用对称密码算法
        String originPassword = PlatformRSAUtils.getAesDecryptValue(request.getPassword());
        logger.debug("用户:{},原始密码：{}", userId, originPassword);

        String encryptPass = this.encryptPassword(originPassword);
        S_user_core userCore = new S_user_core(userId);
        userCore.setPassword(encryptPass);
        this.getUserService().update(userCore);
        // 更新缓存中密码
        userCore = this.getUserCacheProvider().getUser(userId);
        userCore.setPassword(encryptPass);

        return ResponseValue.success(true);
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue getUserInfo(){
        EbUser user = this.getUserRegCache().get(this.getCurrentUserId());
//        List<String> roleIdList = this.getCurrentUserPrincipal().getRoleIdList();
        return ResponseValue.success(VoUtils.acquireUserInfoVo(user, this.getCdnUrl()));
    }

    @RequestMapping(value = "/edit", method = RequestMethod.POST)
    public ResponseValue edit(@RequestBody UserEditRequest userEditRequest){
        if(userEditRequest == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        logger.debug(userEditRequest.toString());
        if(StringUtils.isEmpty(userEditRequest.getNickname())
//            || StringUtils.isEmpty(userEditRequest.getName())
            || StringUtils.isEmpty(userEditRequest.getProvince())
            || StringUtils.isEmpty(userEditRequest.getCity())
            || userEditRequest.getSex() == null){
            return ResponseValue.error("请填写完整个人信息");
        }
        long userId = this.getCurrentUserId();

        EbUser ebUser = new EbUser(userId);
        ebUser.setNickname(userEditRequest.getNickname());
        ebUser.setRealName(userEditRequest.getName());
        ebUser.setSex(userEditRequest.getSex());
        ebUser.setBirthday(userEditRequest.getBirthday());
        ebUser.setProvince(userEditRequest.getProvince());
        ebUser.setCity(userEditRequest.getCity());

        S_user_core userCore = new S_user_core(userId);
        userCore.setNick_name(userEditRequest.getNickname());
        userCore.setSex(userEditRequest.getSex().intValue() == 1? "0":"1");

        if(StringUtils.isNotEmpty(userEditRequest.getAvatar())){
            String avatar = this.clearCdnPrefix(userEditRequest.getAvatar());
            ebUser.setAvatar(avatar);
            userCore.setAvatar(avatar);
        }

        // 保存，同时更新缓存
        this.getUserRegisterService().execUpdateUserEdit(ebUser, userCore);
        this.getUserCacheProvider().updateUser(this.getUserRegisterService().get(userCore));
        this.getUserRegCache().update(this.getUserRegisterService().get(ebUser));

        return ResponseValue.success();
    }
}
