package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.core.BeanContextAware;
import com.iplatform.core.UserMerchantType;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.vo.OrderCenterNumVo;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbLevel;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserBalanceRecord;
import com.ishop.model.vo.MyAccountVo;
import com.ishop.model.vo.MyPromotionVo;
import com.ishop.model.vo.UserBalanceMontyVo;
import com.ishop.model.vo.UserCenterVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/front/user/center")
public class UserCenterApi extends BaseApi {

    /**
     * 我的推广，界面
     * @return
     * @date 2023-09-19
     */
    @RequestMapping(value = "/my/promotion", method = RequestMethod.GET)
    public ResponseValue getMyPromotion(){
        EbUser user = this.getCurrentEbUser();
        // 冻结佣金
        double freezeBrokerage = this.getUserBrokerageService().queryFreezePrice(user.getId());
        // 累计已提取佣金
        double settledCommissionPrice = this.getUserBrokerageService().querySettledCommission(user.getId());

        MyPromotionVo vo = new MyPromotionVo();
        vo.setFreezePrice(freezeBrokerage);
        vo.setSettledCommissionPrice(settledCommissionPrice);
        vo.setBrokeragePrice(user.getBrokeragePrice());
        return ResponseValue.success(vo);
    }

//    @ApiOperation(value = "订单头部数量")
    @RequestMapping(value = "/order/num", method = RequestMethod.GET)
    public ResponseValue getUserCenterOrderNum(){
        OrderCenterNumVo vo = new OrderCenterNumVo();
        return ResponseValue.success(vo);
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue getUserCenterInfo(){
        String cdnUrl = this.getCdnUrl();
        UserCenterVo userCenterVo = new UserCenterVo();
        userCenterVo.setCenterBanner(this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_USER_CENTER_BANNER, cdnUrl));
        userCenterVo.setCenterMenu(this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_USER_CENTER_MENU, null));

        long userId = this.getCurrentUserId();
        EbUser ebUser = this.getUserRegCache().get(userId);
        if(ebUser == null){
            throw new PlatformRuntimeException("登录信息已过期，请重新登录！");
        }
        VoUtils.copyUserCenterInfo(ebUser, userCenterVo, cdnUrl);
        userCenterVo.setPhone(ebUser.getPhone());
        // 2023-09-02 设置角色
//        List<String> roleIdList = this.getCurrentUserPrincipal().getRoleIdList();
        // 改为从数据库加载，因为在微信登录中，没有退出，在后台更新缓存界面功能完成之前，暂时先这样处理！
        // 等后台管理用户，添加：角色设置后，可以更新缓存，就能实时更新登录用户角色了。
        S_user_core userCore = this.getCurrentUser();
        if(userCore.getType().intValue() > UserMerchantType.INDEX_NORMAL){
            List<String> roleIdList = BeanContextAware.getBeanByType(UserServiceImpl.class).queryUserRoleIdList(userId);
            userCenterVo.setRoleIds(StringUtils.collectionToCommaDelimitedString(roleIdList));
            logger.debug("移动端加载了用户角色，商户管理员类型：{}", userCore.getType());
        } else {
            userCenterVo.setRoleIds(StringUtils.EMPTY_STRING);
        }

        //
        int collectionCount = this.getProductRelationService().queryProductCollectionCount(userId);
        userCenterVo.setCollectCount(collectionCount);
        int couponUserCount = this.getCouponUserService().queryUserCouponCount(userId);
        userCenterVo.setCouponCount(couponUserCount);
        int browseRecordCount = this.getUserCenterService().queryUserBrowseRecordCount(userId);
        userCenterVo.setBrowseNum(browseRecordCount);

        userCenterVo.setIsVip(false);
        if(userCenterVo.getLevel().intValue() > 0){
            EbLevel level = this.getLevelCache().get(ebUser.getLevel());
            if(level != null){
                userCenterVo.setIsVip(true);
                userCenterVo.setVipIcon(this.getCdnUrl() + level.getIcon());
                userCenterVo.setVipName(level.getName());
            }
        }

        // 判断是否展示我的推广，1.分销模式是否开启
        userCenterVo.setIsPromoter(false);
        String retailStoreSwitch = this.getArgumentVariable(com.ishop.merchant.Constants.RETAIL_STORE_SWITCH).getStringValue();
        if (retailStoreSwitch.equals(Constants.COMMON_SWITCH_OPEN) && ebUser.getIsPromoter().intValue() == 1) {
            userCenterVo.setIsPromoter(true);
        }

        // 保存用户访问记录
//        asyncService.visitUserCenter(user.getId());
        return ResponseValue.success(userCenterVo);
    }

    /**
     * 我的账户
     * @return
     */
    @RequestMapping(value = "/my/account", method = RequestMethod.GET)
    public ResponseValue myAccount(){
        EbUser user = this.getCurrentEbUser();
        if(user == null){
            return ResponseValue.error("用户不存在");
        }

        double totalMonetary = this.getUserBalanceService().queryTotalMonetaryRecord(user.getId());
        double totalRecharge = this.getUserBalanceService().queryTotalRechargeRecord(user.getId());
        String rechargeSwitch = this.getArgumentVariable(com.ishop.merchant.Constants.CONFIG_KEY_RECHARGE_SWITCH).getStringValue();
        MyAccountVo vo = new MyAccountVo();
        vo.setNowMoney(user.getNowMoney());
        vo.setMonetary(totalMonetary);
        vo.setRecharge(totalRecharge);
        if (StringUtils.isNotEmpty(rechargeSwitch) && rechargeSwitch.equals(Constants.CONFIG_FORM_SWITCH_OPEN)) {
            vo.setRechargeSwitch(true);
        }
        return ResponseValue.success(vo);
    }

    /**
     * 余额记录
     * @param type 记录类型：all-全部，expenditure-支出，income-收入，recharge-充值
     * @return
     * @date 2023-09-13
     */
    @RequestMapping(value = "/balance/list", method = RequestMethod.GET)
    public ResponseValue userBalanceRecord(String type){
        if(StringUtils.isEmpty(type)){
            return ResponseValue.error("记录类型不能为空");
        }
        GenericPager<EbUserBalanceRecord> pager = this.getUserBalanceService().queryPageBalanceList(type, this.getCurrentUserId());
        List<EbUserBalanceRecord> data = pager.getDatas();

        List<UserBalanceMontyVo> monthVoList = new ArrayList<>(8);

        Map<Integer, UserBalanceMontyVo> monthCache = new HashMap<>(4);
        if(!StringUtils.isEmptyList(data)){
            UserBalanceMontyVo vo = null;
            for(EbUserBalanceRecord record : data){
                vo = monthCache.get(record.getMonth());
                if(vo == null){
                    vo = new UserBalanceMontyVo();
                    monthCache.put(record.getMonth(), vo);
                }
                vo.addRecord(record);
            }
            for(UserBalanceMontyVo montyVo : monthCache.values()){
                monthVoList.add(montyVo);
            }
        }

        GenericPager<UserBalanceMontyVo> resultPager = ListPageContext
                .createGenericPager(monthVoList, pager.getPageIndex(), pager.getPageSize(), (int)pager.getTotalRows());
        return ResponseValue.success(resultPager);
    }
}
