package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.iplatform.base.util.PlatformRSAUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbUserConfig;
import com.ishop.model.request.PayPassRequest;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.log.BusinessType;
import com.walker.web.log.Log;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户自定义配置，添加模块。
 * @author 时克英
 * @date 2023-08-06
 */
@RestController
@RequestMapping("/front/user/config")
public class UserConfigApi extends BaseApi {

    /**
     * 设置支付密码
     * @param request
     * @return
     * @date 2023-08-06
     */
    @Log(title = "设置支付密码", businessType = BusinessType.Update, isSaveRequestData = true, isSaveResponseData = true)
    @RequestMapping(value = "/setPayPass", method = RequestMethod.POST)
    public ResponseValue setPayPass(
//            String encryptPassword, String code, String uuid
            @RequestBody PayPassRequest request
            ){
        if(request == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        if(StringUtils.isEmpty(request.getCode()) || StringUtils.isEmpty(request.getUuid())){
            return ResponseValue.error("验证码为空，无法修改支付密码");
        }
        if(StringUtils.isEmpty(request.getEncryptPassword())){
            return ResponseValue.error("请设置支付密码");
        }

        boolean smsCodeSuccess = this.validateSmsCode(request.getCode(), request.getUuid());
        if(!smsCodeSuccess){
            return ResponseValue.error("验证码错误");
        }

        long userId = this.getCurrentUserId();
        String originPassword = null;
        try{
            // 2023-08-06 uniapp端使用对称密码算法
            originPassword = PlatformRSAUtils.getAesDecryptValue(request.getEncryptPassword());
            String passwordMd5 = this.encryptPassword(originPassword);
            this.getUserRegConfigService().execSetupPayPass(userId, passwordMd5);

            // 更新缓存
            EbUserConfig config = this.getUserRegConfigCache().get(userId);
            config.setPayPwd(passwordMd5);
            this.getUserRegConfigCache().update(config);

            return ResponseValue.success();

        } catch (Exception ex){
            logger.error("无法解析设置的支付密码，msg=" + ex.getMessage(), ex);
            return ResponseValue.error("设置支付密码错误：无法解析密码");
        }
    }
}
