package com.ishop.mobile.cache;

import com.ishop.mobile.Constants;
import com.ishop.mobile.PreOrderCacheProvider;
import com.ishop.model.vo.PreOrderVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;

public class LocalPreOrderCache extends AbstractCacheProvider<PreOrderVo> implements PreOrderCacheProvider {

    @Override
    public void save(String key, PreOrderVo preOrderVo, long expiredSeconds) {
        // 本地缓存还未实现定时删除数据
        this.putCacheData(key, preOrderVo);
    }

    @Override
    public PreOrderVo get(String key) {
        return this.getCacheData(key);
    }

    @Override
    public void remove(String key) {
        this.removeCacheData(key);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRE_ORDER;
    }

    @Override
    public Class<?> getProviderType() {
        return PreOrderVo.class;
    }
}
