package com.ishop.mobile.cache;

import com.ishop.mobile.Constants;
import com.ishop.mobile.WechatOpenIdCache;
import com.ishop.model.request.RegisterThirdUserRequest;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;

public class LocalWechatOpenIdCache extends AbstractCacheProvider<RegisterThirdUserRequest> implements WechatOpenIdCache {

    @Override
    public RegisterThirdUserRequest get(String openIdMd5) {
        return this.getCacheData(openIdMd5);
    }

    @Override
    public void save(String openIdMd5, RegisterThirdUserRequest value) {
        this.putCacheData(openIdMd5, value);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_WECHAT_OPENID;
    }

    @Override
    public Class<?> getProviderType() {
        return RegisterThirdUserRequest.class;
    }
}
