package com.ishop.mobile.cache;

import com.ishop.mobile.Constants;
import com.ishop.mobile.PreOrderCacheProvider;
import com.ishop.model.vo.PreOrderVo;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisPreOrderCache extends RedisCacheProvider<PreOrderVo> implements PreOrderCacheProvider {

    public RedisPreOrderCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void save(String key, PreOrderVo preOrderVo, long expiredSeconds) {
        this.putCacheData(key, preOrderVo, expiredSeconds);
    }

    @Override
    public PreOrderVo get(String key) {
        return this.getCacheData(key);
    }

    @Override
    public void remove(String key) {
        this.removeCacheData(key);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PRE_ORDER;
    }

    @Override
    public Class<?> getProviderType() {
        return PreOrderVo.class;
    }
}
