package com.ishop.mobile.cache;

import com.ishop.mobile.Constants;
import com.ishop.mobile.WechatOpenIdCache;
import com.ishop.model.request.RegisterThirdUserRequest;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisWechatOpenIdCache extends RedisCacheProvider<RegisterThirdUserRequest> implements WechatOpenIdCache {

    public RedisWechatOpenIdCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public RegisterThirdUserRequest get(String openIdMd5) {
        return this.getCacheData(openIdMd5);
    }

    @Override
    public void save(String openIdMd5, RegisterThirdUserRequest value) {
        // 默认 120 分钟失效
        this.putCacheData(openIdMd5, value, 120 * 60);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_WECHAT_OPENID;
    }

    @Override
    public Class<?> getProviderType() {
        return RegisterThirdUserRequest.class;
    }
}
