package com.ishop.mobile.config;

import com.iplatform.core.PlatformConfiguration;
import com.ishop.mobile.PreOrderCacheProvider;
import com.ishop.mobile.WechatOpenIdCache;
import com.ishop.mobile.cache.RedisPreOrderCache;
import com.ishop.mobile.cache.RedisWechatOpenIdCache;
import com.walker.support.redis.RedisHelper;
import com.walker.support.redis.cache.RedisCacheProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix = "iplatform.cache", name = "redis-enabled", havingValue = "true", matchIfMissing = false)
@ConditionalOnClass({RedisCacheProvider.class})
@AutoConfigureAfter(RedisAutoConfiguration.class)
public class RedisMobileCacheConfig extends PlatformConfiguration {

    /**
     * 微信openId调用，开放平台登录获取授权缓存对象。
     * @param redisHelper
     * @return
     * @date 2023-07-27
     */
    @Bean
    public WechatOpenIdCache wechatOpenIdCache(RedisHelper redisHelper){
        RedisWechatOpenIdCache cache = new RedisWechatOpenIdCache();
        cache.setRedisHelper(redisHelper);
        return cache;
    }

    @Bean
    public PreOrderCacheProvider preOrderCacheProvider(RedisHelper redisHelper){
        RedisPreOrderCache cache = new RedisPreOrderCache();
        cache.setRedisHelper(redisHelper);
        return cache;
    }
}
