package com.ishop.mobile.config;

import com.iplatform.base.WechatConstants;
import com.iplatform.core.PlatformConfiguration;
import com.ishop.mobile.support.WechatEngine;
import com.walker.infrastructure.arguments.ArgumentsManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class WechatConfig extends PlatformConfiguration {

    /**
     * 微信引擎对象，发现微信接口很多，在这里汇总调用，后续。
     * @param argumentsManager
     * @param restTemplate
     * @return
     * @date 2023-07-27
     */
    @Bean
    public WechatEngine wechatEngine(ArgumentsManager argumentsManager, RestTemplate restTemplate){
        WechatEngine engine = new WechatEngine();
        engine.setArgumentsManager(argumentsManager);
        engine.setRestTemplate(restTemplate);
        engine.setWechatPublicAppId(argumentsManager.getVariable(WechatConstants.WECHAT_PUBLIC_APPID).getStringValue());
        engine.setWechatPublicSecret(argumentsManager.getVariable(WechatConstants.WECHAT_PUBLIC_APPSECRET).getStringValue());
        engine.setWechatMiniAppId(argumentsManager.getVariable(WechatConstants.WECHAT_MINI_APPID).getStringValue());
        engine.setWechatMiniSecret(argumentsManager.getVariable(WechatConstants.WECHAT_MINI_APPSECRET).getStringValue());
        return engine;
    }

}
