package com.ishop.mobile.pojo;

import java.io.Serializable;

/**
 * 移动端提交编辑用户信息。
 * @author 时克英
 * @date 2023-07-02
 */
public class UserEditRequest implements Serializable {

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    /**
     * 返回用户真实姓名。
     * @return
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String name;

    //    @NotBlank(message = "请填写用户昵称")
//    @Length(max = 200, message = "用户昵称不能超过255个字符")
    private String nickname;

//    @NotBlank(message = "请上传用户头像")
//    @Length(max = 255, message = "用户头像不能超过255个字符")
    private String avatar;

//    @ApiModelProperty(value = "生日")
//    @NotBlank(message = "请填写生日信息")
    private String birthday;

//    @NotBlank(message = "省份不能为空")
//    @Length(max = 20, message = "省份不能超过20个字符")
    private String province;

//    @NotBlank(message = "城市不能为空")
//    @Length(max = 20, message = "城市不能超过20个字符")
    private String city;

//    @ApiModelProperty(value = "性别，0未知，1男，2女，3保密")
//    @NotNull(message = "性别不能为空")
//    @Range(min = 0, max = 3, message = "未知的性别类型")
    private Integer sex;

    @Override
    public String toString() {
        return "UserEditRequest{" +
                "name='" + name + '\'' +
                ", nickname='" + nickname + '\'' +
                ", avatar='" + avatar + '\'' +
                ", birthday='" + birthday + '\'' +
                ", province='" + province + '\'' +
                ", city='" + city + '\'' +
                ", sex=" + sex +
                '}';
    }
}
