package com.ishop.mobile.service;

import com.ishop.model.po.EbCart;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CartServiceImpl extends BaseServiceImpl {

    /**
     * 购物车商品数量（条数）
     *
     * @param userId Integer 用户id
     * @param status Boolean 商品类型：true-有效商品，false-无效商品
     * @return Integer
     */
    public int queryUserCountByStatus(long userId, Boolean status){
        return this.sqlMathQuery("select count(*) from eb_cart where uid=? and status=?", new Object[]{userId, status? 1:0}, Integer.class);
    }

    /**
     * 购物车购买商品总数量
     *
     * @param userId Integer 用户id
     * @param status 商品类型：true-有效商品，false-无效商品
     * @return Integer
     */
    public int queryUserSumByStatus(long userId, Boolean status){
        return this.sqlMathQuery("select sum(cart_num) cart_num from eb_cart where uid=? and status=?", new Object[]{userId, status? 1:0}, Integer.class);
    }

    /**
     * 查询用户购物车记录。
     * @param isValid 是否有效
     * @param userId 用户ID
     * @return
     * @date 2023-07-16
     */
    public List<EbCart> queryList(boolean isValid, long userId){
        EbCart param = new EbCart();
        param.setUid(userId);
        param.setStatus(isValid? 1:0);
        return this.select(param);
    }
}
