package com.ishop.mobile.service;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.Constants;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.service.CouponUserServiceImpl;
import com.ishop.merchant.service.ProductAttrValueServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.model.MyRecord;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class FrontOrderServiceImpl extends BaseServiceImpl {

    private ProductServiceImpl productService;
    private ProductAttrValueServiceImpl productAttrValueService;
    private UserRegisterServiceImpl userRegisterService;
    private CouponUserServiceImpl couponUserService;

    @Autowired
    public FrontOrderServiceImpl(ProductServiceImpl productService
            , ProductAttrValueServiceImpl productAttrValueService, UserRegisterServiceImpl userRegisterService, CouponUserServiceImpl couponUserService){
        this.productService = productService;
        this.productAttrValueService = productAttrValueService;
        this.userRegisterService = userRegisterService;
        this.couponUserService = couponUserService;
    }

    /**
     * 创建订单。
     * @param orderType
     * @param skuRecordList
     * @param preOrderNo
     * @param order
     * @param merchantOrderList
     * @param orderDetailList
     * @param couponIdList
     * @param cartIdList
     * @date 2023-07-09
     */
    public void execCreateOrder(int orderType, List<MyRecord> skuRecordList, String preOrderNo
            , EbOrder order, List<EbMerchantOrder> merchantOrderList, List<EbOrderDetail> orderDetailList
            , List<Long> couponIdList, List<Long> cartIdList){
        log.debug("开始扣件商品库存 --> 普通商品:{}", skuRecordList.size());
        int count = 0;
        if (orderType == OrderConstants.ORDER_TYPE_NORMAL.intValue()) { // 普通商品
            // 扣减库存
            for (MyRecord skuRecord : skuRecordList) {
                // 普通商品口库存
                count = this.productService.execOperateStock(skuRecord.getLong("productId"), skuRecord.getInt("num"), Constants.OPERATION_TYPE_SUBTRACT);
                if(count <= 0){
                    throw new PlatformRuntimeException("生成订单扣减商品库存失败,预下单号：" + preOrderNo + ", 商品ID：" + skuRecord.getLong("productId"));
                }
                // 普通商品规格扣库存
                count = this.productAttrValueService.execOperateStock(skuRecord.getInt("attrValueId")
                        , skuRecord.getInt("num"), Constants.OPERATION_TYPE_SUBTRACT, ProductConstants.PRODUCT_TYPE_NORMAL, skuRecord.getInt("attrValueVersion"));
                if(count <= 0){
                    throw new PlatformRuntimeException("更新商品attrValue失败，attrValueId = " + skuRecord.getInt("attrValueId"));
                }
            }
        } else if (orderType == OrderConstants.ORDER_TYPE_VIDEO) {
            log.warn("视频号订单，未实现订单创建");
        } else if (orderType == OrderConstants.ORDER_TYPE_SECKILL) {
            log.warn("秒杀订单，未实现订单创建");
        }

        // 2023-07-20，如果商户订单也是一个，则平台订单设置商户id
        if(merchantOrderList.size() == 1){
            order.setMerId(merchantOrderList.get(0).getMerId());
        }
        this.insert(order);
        this.insertBatch(merchantOrderList);
        this.insertBatch(orderDetailList);

        // 扣除用户积分
        if(order.getUseIntegral().intValue() > 0){
            count = this.userRegisterService.execUpdateIntegral(order.getUid(), order.getUseIntegral(), Constants.OPERATION_TYPE_SUBTRACT);
            if(count <= 0){
                throw new PlatformRuntimeException("生成订单扣除用户积分失败,预下单号："+preOrderNo);
            }
//            UserIntegralRecord userIntegralRecord = initOrderUseIntegral(user.getId(), order.getUseIntegral(), user.getIntegral(), order.getOrderNo());
//            userIntegralRecordService.save(userIntegralRecord);
        }
        if (!StringUtils.isEmptyList(couponIdList)) {
            couponUserService.execUpdateUseCoupons(couponIdList);
        }
        // 生成订单日志
//        orderStatusService.createLog(order.getOrderNo(), OrderStatusConstants.ORDER_STATUS_CREATE, OrderStatusConstants.ORDER_LOG_MESSAGE_CREATE);
        // 清除购物车数据
        if(!StringUtils.isEmptyList(cartIdList)){
            Map<String, Object> param = new HashMap<>(2);
            param.put("ids", cartIdList);
            this.execute("delete from eb_cart where id in (:ids)", param);
        }

    }
}
