package com.ishop.mobile.service;

import com.iplatform.model.vo.SystemGroupVo;
import com.ishop.merchant.ProductConstants;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbSeckillProduct;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class IndexServiceImpl extends BaseServiceImpl {

    /**
     * 首页商品列表
//     * @param cid 一级商品分类id，全部传0
     * @param categoryIdList 第三级商品分类id集合
     * @return
     * @date 2023-06-23
     */
    public GenericPager<EbProduct> queryIndexProductList(List<Integer> categoryIdList){
        Map<String, Object> parameter = new HashMap<>(4);
        StringBuilder sql = new StringBuilder("select * from eb_product where is_del=0 and is_recycle=0 and is_show=1");
        sql.append(" and (audit_status=").append(ProductConstants.AUDIT_STATUS_SUCCESS)
                .append(" or audit_status=").append(ProductConstants.AUDIT_STATUS_EXEMPTION).append(")");
        sql.append(" and stock>0");
        if (!StringUtils.isEmptyList(categoryIdList)) {
//            System.out.println("请实现商品分类查询代码!");
            sql.append(" and category_id in (:categoryIdList)");
            parameter.put("categoryIdList", categoryIdList);
        }
        sql.append(" order by id desc");
        // 查询活动边框配置信息, 并赋值给商品response 重复添加的商品数据会根据数据添加持续覆盖后的为准
//        productList = activityStyleService.makeActivityBorderStyle(productList);
        return this.selectSplit(sql.toString(), parameter, new EbProduct());
    }

    /**
     * 返回首页推荐的商家集合
     * @param limit 限制几条
     * @return
     * @date 2023-06-23
     */
    public List<EbMerchant> queryIndexMerchantList(int limit){
        return this.select("select id,name,rectangle_logo,cover_image,category_id,type_id from eb_merchant where is_switch=1 and is_del=0 order by is_recommend desc, sort desc limit ?"
                , new Object[]{limit}, new EbMerchant());
    }

    /**
     * 获取APP首页秒杀活动集合。暂时没实现。
     * @return
     * @date 2023-06-23
     */
    public List<EbSeckillProduct> queryIndexSecKillList(){
        return new ArrayList<>(1);
    }
}
