package com.ishop.mobile.service;

import com.ishop.model.vo.QrCodeVo;
import com.walker.infrastructure.utils.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class QrcodeServiceImpl {

    private RestTemplate restTemplate;

    @Autowired
    public QrcodeServiceImpl(RestTemplate restTemplate){
        this.restTemplate = restTemplate;
    }

    /**
     * 远程图片转base64
     *
     * @param url 图片链接地址
     * @return QrCodeVo
     * @date 2023-07-09
     */
    public QrCodeVo urlToBase64(String url) {
        byte[] bytes = restTemplate.getForEntity(url, byte[].class).getBody();
        String base64Image = "data:image/png;base64," + new String(Base64.encodeBase64(bytes));
        QrCodeVo vo = new QrCodeVo();
        vo.setCode(base64Image);
        return vo;
    }
}
