package com.ishop.mobile.service;

import com.ishop.model.po.EbUserToken;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserTokenServiceImpl extends BaseServiceImpl {

    /**
     * 查询用户已存在的绑定token信息
     * @param userId
     * @param type 类型:wechat-公众号，routine-小程序,iosWx-苹果微信，androidWx-安卓微信
     * @return
     * @date 2023-08-07
     */
    public EbUserToken queryToken(long userId, int type){
        EbUserToken param = new EbUserToken();
        param.setIsDel(0);
        param.setUid(userId);
        param.setType(type);
        List<EbUserToken> list = this.select(param);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        return list.get(0);
    }

    /**
     * 检测token是否存在
     * @param token String openId
     * @param type int 类型
     * @return UserToken
     */
    public EbUserToken queryUserToken(String token, int type){
        EbUserToken userToken = new EbUserToken();
        userToken.setToken(token);
        userToken.setType(type);
        userToken.setIsDel(0);
        List<EbUserToken> list = this.select(userToken);
        if(!StringUtils.isEmptyList(list)){
            return list.get(0);
        }
        return null;
    }
}
