package com.ishop.mobile.support;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.WechatConstants;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.vo.WechatMiniAuthorizeVo;
import com.ishop.model.wechat.WeChatAuthorizeLoginUserInfoVo;
import com.ishop.model.wechat.WeChatOauthToken;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.HashMap;

public class WechatEngine {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 微信小程序获取授权信息
     * @param code
     * @return
     * @date 2023-09-14
     */
    public WechatMiniAuthorizeVo getMiniAuthCode(String code){
        if(StringUtils.isEmpty(this.wechatMiniAppId)){
            throw new PlatformRuntimeException("wechatMiniAppId未设置");
        }
        if(StringUtils.isEmpty(this.wechatMiniSecret)){
            throw new PlatformRuntimeException("wechatMiniSecret未设置");
        }
        String url = MessageFormat.format(WechatConstants.WECHAT_MINI_SNS_AUTH_CODE2SESSION_URL
                , this.wechatMiniAppId, this.wechatMiniSecret, code);
        String entity = restTemplate.getForObject(url, String.class, new HashMap<>(2));
        if(StringUtils.isEmpty(entity)){
            throw new PlatformRuntimeException("微信平台接口异常，没任何数据返回！" + WechatConstants.WECHAT_MINI_SNS_AUTH_CODE2SESSION_URL);
        }

        WechatMiniAuthorizeVo wechatMiniAuthorizeVo = null;
        ObjectNode objectNode = WechatUtils.acquireObjectNode(entity);

        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0")) {
            if (objectNode.has("errmsg")) {
                // 保存到微信异常表
//                    wxExceptionDispose(data, StrUtil.format("微信获取accessToken异常，{}端", type));
                throw new PlatformRuntimeException("微信接口调用失败：" + objectNode.get("errcode") + objectNode.get("errmsg"));
            }
        }
        try{
            wechatMiniAuthorizeVo = JsonUtils.jsonStringToObject(entity, WechatMiniAuthorizeVo.class);
            logger.info("调用一次微信远程接口获取'jscode2session'={}", wechatMiniAuthorizeVo);
            return wechatMiniAuthorizeVo;

        } catch (Exception ex){
            throw new RuntimeException("json字符串转对象错误：" + objectNode, ex);
        }
    }

    /**
     * 获取开放平台用户信息
     * @param accessToken 调用凭证
     * @param openid      普通用户的标识，对当前开发者帐号唯一
     *                    公众号使用
     * @return 开放平台用户信息对象
     * @date 2023-07-27
     */
    public WeChatAuthorizeLoginUserInfoVo getSnsUserInfo(String accessToken, String openid) {
        String url = MessageFormat.format(WechatConstants.WECHAT_SNS_USERINFO_URL, accessToken, openid, "zh_CN");
//        ObjectNode objectNode = RestTemplateUtils.getData(url, this.restTemplate);
        String entity = restTemplate.getForObject(url, String.class, new HashMap<>(2));
        if(StringUtils.isEmpty(entity)){
            throw new PlatformRuntimeException("微信平台接口异常，没任何数据返回！");
        }

        WeChatAuthorizeLoginUserInfoVo loginUserInfoVo = null;
        ObjectNode objectNode = WechatUtils.acquireObjectNode(entity);
//        try {
//            objectNode = JsonUtils.jsonStringToObjectNode(entity);
//        } catch (Exception e) {
//            throw new PlatformRuntimeException("string转ObjectNode错误：" + e.getMessage(), e);
//        }

        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0")) {
            if (objectNode.has("errmsg")) {
                // 保存到微信异常表
//                    wxExceptionDispose(data, StrUtil.format("微信获取accessToken异常，{}端", type));
                throw new PlatformRuntimeException("微信接口调用失败：" + objectNode.get("errcode") + objectNode.get("errmsg"));
            }
        }
        try{
            loginUserInfoVo = JsonUtils.jsonStringToObject(entity, WeChatAuthorizeLoginUserInfoVo.class);
            logger.info("调用一次微信远程接口获取'sns_userInfo'={}", loginUserInfoVo);
            return loginUserInfoVo;

        } catch (Exception ex){
            throw new RuntimeException("json字符串转对象错误：" + objectNode, ex);
        }
    }

    /**
     * 获取开放平台access_token
     * @param code
     * @return
     * @date 2023-07-27
     */
    public WeChatOauthToken getOauth2AccessToken(String code) {
        if(StringUtils.isEmpty(this.wechatPublicAppId)){
            throw new PlatformRuntimeException("wechatPublicAppId未设置");
        }
        if(StringUtils.isEmpty(this.wechatPublicSecret)){
            throw new PlatformRuntimeException("wechatAppSecret未设置");
        }
        String url = WechatUtils.getWechatOauthAccessTokenUrl(this.wechatPublicAppId, this.wechatPublicSecret, code);
        if(logger.isDebugEnabled()){
            logger.debug(url);
        }
//        ObjectNode objectNode = RestTemplateUtils.getData(url, this.restTemplate);
        String entity = restTemplate.getForObject(url, String.class, new HashMap<>(2));
        if(StringUtils.isEmpty(entity)){
            throw new PlatformRuntimeException("微信平台接口异常，没任何数据返回！");
        }

        WeChatOauthToken weChatOauthToken = null;
        ObjectNode objectNode = WechatUtils.acquireObjectNode(entity);
//        try {
//            objectNode = JsonUtils.jsonStringToObjectNode(entity);
//        } catch (Exception e) {
//            throw new PlatformRuntimeException("string转ObjectNode错误：" + e.getMessage(), e);
//        }
        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0")) {
            if (objectNode.has("errmsg")) {
                // 保存到微信异常表
//                    wxExceptionDispose(data, StrUtil.format("微信获取accessToken异常，{}端", type));
                throw new PlatformRuntimeException("微信接口调用失败：" + objectNode.get("errcode") + objectNode.get("errmsg"));
            }
        }

        try{
            weChatOauthToken = JsonUtils.jsonStringToObject(entity, WeChatOauthToken.class);
            logger.info("调用一次微信远程接口获取'access_token'=", weChatOauthToken);
            return weChatOauthToken;

        } catch (Exception ex){
            throw new PlatformRuntimeException("json字符串转对象错误：" + objectNode, ex);
        }
    }

//    private ObjectNode acquireObjectNode(String entity){
//        ObjectNode objectNode = null;
//        try {
//            objectNode = JsonUtils.jsonStringToObjectNode(entity);
//        } catch (Exception e) {
//            throw new PlatformRuntimeException("string转ObjectNode错误：" + e.getMessage(), e);
//        }
//        return objectNode;
//    }

    public void setArgumentsManager(ArgumentsManager argumentsManager) {
        this.argumentsManager = argumentsManager;
    }

    public void setWechatPublicSecret(String wechatPublicSecret) {
        this.wechatPublicSecret = wechatPublicSecret;
    }

    public void setWechatPublicAppId(String wechatPublicAppId) {
        this.wechatPublicAppId = wechatPublicAppId;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    /**
     * 返回微信小程序appId
     * @return
     * @date 2023-09-14
     */
    public String getWechatMiniSecret() {
        return wechatMiniSecret;
    }

    /**
     * 返回微信小程序对应密钥
     * @return
     * @date 2023-09-14
     */
    public void setWechatMiniSecret(String wechatMiniSecret) {
        this.wechatMiniSecret = wechatMiniSecret;
    }

    public String getWechatMiniAppId() {
        return wechatMiniAppId;
    }

    public void setWechatMiniAppId(String wechatMiniAppId) {
        this.wechatMiniAppId = wechatMiniAppId;
    }

    private String wechatMiniSecret;
    private String wechatMiniAppId;
    private RestTemplate restTemplate;
    private String wechatPublicSecret;     // 公众号密钥
    private String wechatPublicAppId;   // 公众号appid
    private ArgumentsManager argumentsManager;
}
