package com.ishop.mobile.util;

import com.iplatform.base.SecurityConstants;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.ishop.mobile.Constants;
import com.ishop.mobile.pojo.LoginParam;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.LoginInfoVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaType;
import com.walker.web.ClientType;
import com.walker.web.LoginType;
import com.walker.web.UserPrincipal;
import com.walker.web.UserType;

import java.util.Map;

public class LoginUtils {

    public static final void setupBindType(S_user_core userCore, String bindType){
        if(StringUtils.isNotEmpty(bindType)){
            // 存在用户，但尚未绑定，更新绑定
            switch (bindType) {
                case com.ishop.merchant.Constants.REGISTER_TYPE_WECHAT:
                    userCore.setIs_wechat_public(1);
                    break;
                case com.ishop.merchant.Constants.REGISTER_TYPE_ROUTINE:
                    userCore.setIs_wechat_routine(1);
                    break;
                case com.ishop.merchant.Constants.REGISTER_TYPE_IOS_WX:
                    userCore.setIs_wechat_ios(1);
                    break;
                case com.ishop.merchant.Constants.REGISTER_TYPE_ANDROID_WX:
                    userCore.setIs_wechat_android(1);
                    break;
            }
        }
    }

    /**
     * 获取用户Token类型，已有方法。
     * @param type 用户注册类型
     * @date 2023-08-07
     */
    public static final int getUserTokenType(String type) {
        Integer userTokenType = 0;
        switch (type) {
            case com.ishop.merchant.Constants.REGISTER_TYPE_WECHAT:
                userTokenType = com.ishop.merchant.Constants.USER_TOKEN_TYPE_WECHAT;
                break;
            case com.ishop.merchant.Constants.REGISTER_TYPE_ROUTINE:
                userTokenType = com.ishop.merchant.Constants.USER_TOKEN_TYPE_ROUTINE;
                break;
            case com.ishop.merchant.Constants.REGISTER_TYPE_IOS_WX:
                userTokenType = com.ishop.merchant.Constants.USER_TOKEN_TYPE_IOS_WX;
                break;
            case com.ishop.merchant.Constants.REGISTER_TYPE_ANDROID_WX:
                userTokenType = com.ishop.merchant.Constants.USER_TOKEN_TYPE_ANDROID_WX;
                break;
        }
        return userTokenType;
    }

    /**
     * 手机端登录时，组装返回前端用户信息。
     * <p>该方法在手机（验证码）登录方法中使用。{@linkplain com.ishop.mobile.api.LoginApi#phoneCaptchaLogin(LoginParam)}</p>
     * @param data 调用系统登录返回的用户基本对象。
     * @return
     * @date 2023-06-30
     */
    public static final LoginInfoVo acquireLoginInfoVo(Map<String, Object> data){
        UserPrincipal<S_user_core> userPrincipal = (UserPrincipal<S_user_core>) data.get(SecurityConstants.KEY_USER_INFO_APP);
        LoginInfoVo vo = new LoginInfoVo();
        vo.setToken(data.get(com.walker.web.Constants.TOKEN_NAME).toString());
        vo.setId(userPrincipal.getUserInfo().getId());
        vo.setPhone(userPrincipal.getUserInfo().getPhonenumber());
        vo.setNikeName(userPrincipal.getUserInfo().getNick_name());
        vo.setType(Constants.LOGIN_STATUS_LOGIN);
        return vo;
    }

    public static final EbUser acquireMobileRegisterEbUser(String phone, S_user_core userCore, String avatar){
        EbUser ebUser = new EbUser();
        ebUser.setAccount(phone);
        ebUser.setPwd(userCore.getPassword());
        ebUser.setPhone(phone);
        ebUser.setNickname(userCore.getNick_name());
        ebUser.setSex(0);
        ebUser.setRegisterType(userCore.getRegister_type());
        ebUser.setAddress(StringUtils.EMPTY_STRING);
        ebUser.setAvatar(avatar);
        ebUser.setLastLoginTime(userCore.getCreate_time());
        ebUser.setCreateTime(userCore.getCreate_time());
        ebUser.setUpdateTime(userCore.getCreate_time());
        ebUser.setIsWechatRoutine(userCore.getIs_wechat_routine());
        ebUser.setIsWechatPublic(userCore.getIs_wechat_public());
        ebUser.setIsWechatAndroid(userCore.getIs_wechat_android());
        ebUser.setIsWechatIos(userCore.getIs_wechat_ios());
        ebUser.setLevel(0);
        ebUser.setSignNum(0);
        ebUser.setCountry("CN");
        ebUser.setIntegral(0);
        ebUser.setExperience(0);
        ebUser.setNowMoney(0d);
        ebUser.setPayCount(0);
        ebUser.setStatus(1);
        ebUser.setIsLogoff(0);
        ebUser.setIsBindingIos(0);
        ebUser.setBrokeragePrice(0d);
        ebUser.setIsPromoter(0);
        ebUser.setSpreadUid(0L);
        ebUser.setSpreadCount(0);
        return ebUser;
    }

    public static final S_user_core acquireMobileRegisterUserCore(String phone, String defaultPassEncrypt, String avatar){
        S_user_core userCore = new S_user_core();
        userCore.setUser_name(phone);
        userCore.setPhonenumber(phone);
        userCore.setNick_name(com.ishop.mobile.Constants.REG_USER_PREFIX + StringUtils.generateRandomNumber(6));
        userCore.setOrg_id(0L);
        userCore.setDept_id(0L);
        userCore.setUser_type(UserType.TYPE_APP_REG);
        userCore.setPassword(defaultPassEncrypt);
        userCore.setSex("0");
        userCore.setType(0);    // 普通用户，类型默认为0
        userCore.setRegister_type(com.ishop.mobile.Constants.REGISTER_TYPE_H5);
        userCore.setBind_mobile(1); // 这里（手机号不存在直接注册）肯定已绑定手机
        userCore.setCreate_by("register");
        userCore.setCreate_time(DateUtils.getDateTimeNumber());
        userCore.setUpdate_time(userCore.getCreate_time());
        userCore.setAvatar(avatar);
        // 设置默认值
        userCore.setIs_wechat_public(0);
        userCore.setIs_wechat_routine(0);
        userCore.setIs_wechat_ios(0);
        userCore.setIs_wechat_android(0);
        userCore.setModify_pwd(0);
        userCore.setBind_wechat(0);
        userCore.setBind_mail(0);
        userCore.setProfile_id(0L);
        userCore.setIs_sms(1);
        userCore.setStatus(com.iplatform.base.Constants.STATUS_NORMAL);
        userCore.setMer_id(0L);
        userCore.setDel_flag(0);
        userCore.setIs_logoff(0);
        userCore.setLogin_date(userCore.getCreate_time());
        userCore.setLogoff_time(0L);
        return userCore;
    }

//    public static final RequestLogin acquireRequestLoginByWechatRoutine(String loginId, String encryptPass){
//        RequestLogin requestLogin = new RequestLogin();
//        requestLogin.setUuid(StringUtils.EMPTY_STRING);
//        requestLogin.setLoginType(LoginType.INDEX_WECHAT);
//        requestLogin.setClientType(ClientType.INDEX_MOBILE);
//        requestLogin.setUsername(loginId);
//        requestLogin.setPassword(encryptPass);
//        requestLogin.setCode(StringUtils.EMPTY_STRING);
//        requestLogin.setVerifyType(CaptchaType.INDEX_NONE); // 后台：WechatLoginCallback -> NoneCaptchaProvider
//        return requestLogin;
//    }

    /**
     * 微信登录时，组装一个请求对象。
     * @param loginId 用户登录名
     * @param encryptPass 从数据库查询的加密密码
     * @return
     * @date 2023-07-27
     */
    public static final RequestLogin acquireRequestLoginByWechatPublic(String loginId, String encryptPass){
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUuid(StringUtils.EMPTY_STRING);
        requestLogin.setLoginType(LoginType.INDEX_WECHAT);
        requestLogin.setClientType(ClientType.INDEX_MOBILE);
        requestLogin.setUsername(loginId);
        requestLogin.setPassword(encryptPass);
        requestLogin.setCode(StringUtils.EMPTY_STRING);
        requestLogin.setVerifyType(CaptchaType.INDEX_NONE); // 后台：WechatLoginCallback -> NoneCaptchaProvider
        return requestLogin;
    }

    /**
     * 根据移动端请求参数，组装一个系统统一的登录请求对象。
     * @param param
     * @return
     * @date 2023-06-28
     */
    public static final RequestLogin acquireRequestLoginByCaptcha(LoginParam param){
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUuid(param.getUuid());
        requestLogin.setLoginType(LoginType.INDEX_SMS_CODE);
        requestLogin.setClientType(ClientType.INDEX_MOBILE);
        requestLogin.setUsername(param.getPhone());
        requestLogin.setPassword(param.getCaptcha());
        requestLogin.setCode(param.getCaptcha());
        requestLogin.setVerifyType(CaptchaType.INDEX_SMS_CODE);
        return requestLogin;
    }

    public static final RequestLogin acquireRequestLoginByPassword(LoginParam param){
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUuid(param.getUuid());
        requestLogin.setLoginType(LoginType.INDEX_MOBILE_PASSWORD);
        requestLogin.setClientType(ClientType.INDEX_MOBILE);
        requestLogin.setUsername(param.getPhone());
        requestLogin.setPassword(param.getPassword());
        requestLogin.setCode(param.getCaptcha());
        requestLogin.setVerifyType(CaptchaType.INDEX_NONE);
        return requestLogin;
    }
}
