/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.ishop.merchant.util.VoUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbArticle;
import com.ishop.model.vo.ArticleVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/article"})
public class ArticleApi
extends BaseApi {
    @RequestMapping(value={"/category/list"}, method={RequestMethod.GET})
    public ResponseValue getCategoryList() {
        return ResponseValue.success((Object)this.getArticleCategoryCache().getList());
    }

    @RequestMapping(value={"/list/{cid}"}, method={RequestMethod.GET})
    public ResponseValue list(@PathVariable(name="cid") String cid) {
        GenericPager pager = this.getArticleService().queryPageArticleList(cid, null, null);
        List data = pager.getDatas();
        if (StringUtils.isEmptyList((List)data)) {
            return ResponseValue.success((Object)pager);
        }
        List<ArticleVo> list = this.acquireVoList(data);
        return ResponseValue.success((Object)ListPageContext.createGenericPager(list, (int)pager.getPageIndex(), (int)((int)pager.getTotalRows())));
    }

    @RequestMapping(value={"/hot/list"}, method={RequestMethod.GET})
    public ResponseValue getHotList() {
        List data = this.getArticleService().queryArticleList(Boolean.valueOf(true), null);
        return ResponseValue.success(this.acquireVoList(data));
    }

    @RequestMapping(value={"/banner/list"}, method={RequestMethod.GET})
    public ResponseValue getBannerList() {
        List data = this.getArticleService().queryArticleList(null, Boolean.valueOf(true));
        return ResponseValue.success(this.acquireVoList(data));
    }

    @RequestMapping(value={"/info/{id}"}, method={RequestMethod.GET})
    public ResponseValue detail(@PathVariable(value="id") Long id) {
        return this.acquireArticleDetailVo(id);
    }

    private List<ArticleVo> acquireVoList(List<EbArticle> data) {
        String cdnUrl = this.getCdnUrl();
        ArrayList<ArticleVo> list = new ArrayList<ArticleVo>(4);
        if (!StringUtils.isEmptyList(data)) {
            for (EbArticle article : data) {
                list.add(VoUtils.acquireArticleVo((EbArticle)article, (String)cdnUrl, (boolean)false));
            }
        }
        return list;
    }
}

