/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.ishop.merchant.ProductConstants;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.CartNumParam;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbCart;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.response.CartInfoResponse;
import com.ishop.model.response.CartMerchantResponse;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/cart"})
public class CartApi
extends BaseApi {
    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    public ResponseValue count(CartNumParam request) {
        long userId = this.getCurrentUserId();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int num = request.getType().equals("total") ? this.getCartService().queryUserCountByStatus(userId, request.getNumType()) : this.getCartService().queryUserSumByStatus(userId, request.getNumType());
        map.put("count", num);
        return ResponseValue.success(map);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(Boolean isValid) {
        long userId = this.getCurrentUserId();
        List<EbCart> list = this.getCartService().queryList(isValid, userId);
        ArrayList<CartMerchantResponse> data = new ArrayList<CartMerchantResponse>(4);
        if (StringUtils.isEmptyList(list)) {
            return ResponseValue.success(data);
        }
        List merIdList = list.stream().map(EbCart::getMerId).distinct().collect(Collectors.toList());
        CartMerchantResponse merchantResponse = null;
        List merCartList = null;
        ArrayList<CartInfoResponse> cartDetailList = null;
        for (Integer merId : merIdList) {
            merchantResponse = new CartMerchantResponse();
            merchantResponse.setMerId(merId);
            merchantResponse.setMerName(this.getMerchantCache().get(merId.intValue()).getName());
            merCartList = list.stream().filter(e -> e.getMerId().equals(merId)).collect(Collectors.toList());
            cartDetailList = new ArrayList<CartInfoResponse>(2);
            for (EbCart cart : merCartList) {
                CartInfoResponse cartInfoResponse = VoUtils.acquireCartInfoResponse(cart);
                EbProduct product = (EbProduct)this.getProductService().get((BasePo)new EbProduct(cart.getProductId()));
                cartInfoResponse.setProName(product.getName());
                cartInfoResponse.setImage(product.getImage());
                if (!isValid.booleanValue()) {
                    cartInfoResponse.setAttrStatus(Boolean.valueOf(false));
                    continue;
                }
                EbProductAttrValue attrValue = this.getProductAttrValueService().queryByIdAndProductIdAndType(cart.getProductAttrUnique(), cart.getProductId(), ProductConstants.PRODUCT_TYPE_NORMAL);
                if (attrValue == null) {
                    cartInfoResponse.setAttrStatus(Boolean.valueOf(false));
                    continue;
                }
                if (StringUtils.isNotEmpty((String)attrValue.getImage())) {
                    cartInfoResponse.setImage(attrValue.getImage());
                }
                cartInfoResponse.setSku(attrValue.getSku());
                cartInfoResponse.setPrice(attrValue.getPrice());
                cartInfoResponse.setAttrId(attrValue.getId());
                cartInfoResponse.setAttrStatus(Boolean.valueOf(attrValue.getStock() > 0));
                cartInfoResponse.setStock(attrValue.getStock());
                cartDetailList.add(cartInfoResponse);
            }
            merchantResponse.setCartInfoList(cartDetailList);
        }
        data.add(merchantResponse);
        return ResponseValue.success(data);
    }
}

