/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.CouponParam;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbCouponUser;
import com.ishop.model.request.OrderUseCouponRequest;
import com.ishop.model.response.CouponUserOrderResponse;
import com.ishop.model.vo.PreMerchantOrderVo;
import com.ishop.model.vo.PreOrderDetailVo;
import com.ishop.model.vo.PreOrderVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/coupon"})
public class CouponApi
extends BaseApi {
    @RequestMapping(value={"/page/list"}, method={RequestMethod.GET})
    public ResponseValue list(CouponParam param) {
        if (param == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (!(param.getMerId() != null && param.getMerId() > 0 || param.getProductId() != null && param.getProductId() > 0L)) {
            throw new IllegalArgumentException("\u5546\u6237ID\u4e0e\u5546\u54c1ID\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        long userId = this.getCurrentUserId();
        GenericPager pager = this.getCouponService().queryPageH5CouponList(userId, param.getCategory(), param.getMerId(), param.getProductId());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/order/list"}, method={RequestMethod.GET})
    public ResponseValue getCouponsListByPreOrderNo(OrderUseCouponRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getPreOrderNo()) || request.getMerId() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u8ba2\u5355\u4f18\u60e0\u5238\u4fe1\u606f");
        }
        PreOrderVo preOrderVo = this.getPreOrderCache().get(request.getPreOrderNo());
        if (preOrderVo == null) {
            return ResponseValue.error((String)"\u9884\u4e0b\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        long userId = this.getCurrentUserId();
        List pidList = null;
        Double maxPrice = 0.0;
        for (PreMerchantOrderVo merchantOrderVo : preOrderVo.getMerchantOrderVoList()) {
            if (!merchantOrderVo.getMerId().equals(request.getMerId())) continue;
            pidList = merchantOrderVo.getOrderInfoList().stream().map(PreOrderDetailVo::getProductId).distinct().collect(Collectors.toList());
            maxPrice = merchantOrderVo.getProTotalFee();
        }
        ArrayList<CouponUserOrderResponse> data = new ArrayList<CouponUserOrderResponse>(8);
        List list = this.getCouponUserService().queryListByPreOrderNo(request.getPreOrderNo(), request.getMerId(), maxPrice, null, Long.valueOf(userId), pidList);
        if (!StringUtils.isEmptyList((List)list)) {
            for (EbCouponUser couponUser : list) {
                data.add(VoUtils.acquireCouponUserOrder(couponUser));
            }
        }
        return ResponseValue.success(data);
    }
}

