/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.vo.IndexInfoVo;
import com.ishop.model.vo.LayoutBottomNavigationVo;
import com.ishop.model.vo.ProductCommonVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/index"})
public class IndexApi
extends BaseApi {
    @RequestMapping(value={"/color/config"}, method={RequestMethod.GET})
    public ResponseValue getColorConfig() {
        Variable var = this.getArgumentVariable("change_color_config");
        return ResponseValue.success((Object)var);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue getIndexInfo() {
        String cdnUrl = this.getCdnUrl();
        IndexInfoVo vo = new IndexInfoVo();
        vo.setBanner(this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_INDEX_BANNER, cdnUrl));
        vo.setMenus(this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_INDEX_MENU, cdnUrl));
        vo.setLogoUrl(this.getCdnUrl() + this.getArgumentVariable("mobile_top_logo").getStringValue());
        vo.setConsumerType(this.getArgumentVariable("consumer_type").getStringValue());
        switch (vo.getConsumerType()) {
            case "h5": {
                vo.setConsumerH5Url(this.getArgumentVariable("consumer_h5_url").getStringValue());
            }
            case "hotline": {
                vo.setConsumerHotline(this.getArgumentVariable("consumer_hotline").getStringValue());
            }
        }
        vo.setHeadline(this.getArticleService().queryIndexHeadLine(10));
        vo.setShopStreetSwitch(this.getArgumentVariable("shop_street_switch").getStringValue());
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/seckill/info"}, method={RequestMethod.GET})
    public ResponseValue getIndexSecKillInfo() {
        return ResponseValue.success(this.getIndexService().queryIndexSecKillList());
    }

    @RequestMapping(value={"/merchant/list"}, method={RequestMethod.GET})
    public ResponseValue getMerchantList() {
        List<EbMerchant> merchantList = this.getIndexService().queryIndexMerchantList(6);
        return ResponseValue.success(VoUtils.acquireIndexMerchantResponse(merchantList));
    }

    @RequestMapping(value={"/product/list"}, method={RequestMethod.GET})
    public ResponseValue getProductList(Integer cid) {
        GenericPager<EbProduct> pager;
        List categoryIdList = null;
        if (cid != null && cid > 0) {
            List cateList = this.getProductCategoryCache().getThirdLevelCategoryList(cid, 32);
            categoryIdList = ProductCategoryUtils.acquireCategoryIdList((List)cateList);
        }
        if (StringUtils.isEmptyList((List)(pager = this.getIndexService().queryIndexProductList(categoryIdList)).getDatas())) {
            return ResponseValue.success(pager);
        }
        String cdnUrl = this.getCdnUrl();
        ArrayList<ProductCommonVo> productCommonVoList = new ArrayList<ProductCommonVo>(pager.getDatas().size());
        ProductCommonVo productCommonVo = null;
        for (EbProduct product : pager.getDatas()) {
            productCommonVo = VoUtils.transferTo(product, cdnUrl);
            productCommonVo.setIsSelf(Boolean.valueOf(this.getMerchantCache().get(product.getMerId().intValue()).getIsSelf() == 1));
            productCommonVoList.add(productCommonVo);
        }
        GenericPager resultPager = ListPageContext.createGenericPager(productCommonVoList, (int)pager.getPageIndex(), (int)((int)pager.getTotalRows()));
        return ResponseValue.success((Object)resultPager);
    }

    @RequestMapping(value={"/get/bottom/navigation"}, method={RequestMethod.GET})
    public ResponseValue getBottomNavigation() {
        String isCustom = this.getArgumentVariable("bottom_navigation_is_custom").getStringValue();
        List bnList = this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_BOTTOM_NAVIGATION, this.getCdnUrl());
        LayoutBottomNavigationVo layoutBottomNavigationVo = new LayoutBottomNavigationVo();
        layoutBottomNavigationVo.setIsCustom(isCustom);
        layoutBottomNavigationVo.setBottomNavigationList(bnList);
        return ResponseValue.success((Object)layoutBottomNavigationVo);
    }

    @RequestMapping(value={"/search/keyword"}, method={RequestMethod.GET})
    public ResponseValue hotKeywords() {
        List hotKeywords = this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_INDEX_KEYWORDS, null);
        return ResponseValue.success((Object)hotKeywords);
    }

    @RequestMapping(value={"/copyright/company/image"}, method={RequestMethod.GET})
    public ResponseValue getCopyrightCompanyImage() {
        return ResponseValue.success((String)this.getArgumentVariable("copyright_company_image").getStringValue());
    }

    @RequestMapping(value={"/image/domain"}, method={RequestMethod.GET})
    public ResponseValue getImageDomain() {
        String localUploadUrl = this.getArgumentVariable("localUploadUrl").getStringValue();
        return ResponseValue.success((String)"\u6210\u529f", (Object)(StringUtils.isEmpty((String)localUploadUrl) ? "" : localUploadUrl));
    }

    @RequestMapping(value={"/get/system/time"}, method={RequestMethod.GET})
    public ResponseValue getSystemTime() {
        return ResponseValue.success((Object)System.currentTimeMillis());
    }
}

