/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.captcha.BlockPuzzleCaptchaProvider;
import com.iplatform.base.captcha.JigsawResult;
import com.iplatform.base.exception.LoginException;
import com.iplatform.base.pojo.CaptchaParam;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.ishop.merchant.Constants;
import com.ishop.merchant.util.VoUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.LoginParam;
import com.ishop.mobile.pojo.SmsCodeParam;
import com.ishop.mobile.pojo.WechatLoginRequest;
import com.ishop.mobile.support.WechatEngine;
import com.ishop.mobile.util.LoginUtils;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserToken;
import com.ishop.model.request.RegisterThirdUserRequest;
import com.ishop.model.vo.LoginConfigVo;
import com.ishop.model.vo.LoginInfoVo;
import com.ishop.model.vo.WechatMiniAuthorizeVo;
import com.ishop.model.wechat.WeChatAuthorizeLoginUserInfoVo;
import com.ishop.model.wechat.WeChatOauthToken;
import com.ishop.model.wechat.WechatBindingPhoneRequest;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaResult;
import com.walker.web.ResponseValue;
import com.walker.web.log.BusinessType;
import com.walker.web.log.OperateUser;
import com.walker.web.util.IdUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/login"})
public class LoginApi
extends BaseApi {
    private BlockPuzzleCaptchaProvider blockPuzzleCaptchaProvider;
    private CacheProvider<String> captchaCacheProvider;
    private SecuritySpi securitySpi;
    private WechatEngine wechatEngine;

    @Autowired
    public LoginApi(BlockPuzzleCaptchaProvider blockPuzzleCaptchaProvider, CacheProvider<String> captchaCacheProvider, SecuritySpi securitySpi, WechatEngine wechatEngine) {
        this.blockPuzzleCaptchaProvider = blockPuzzleCaptchaProvider;
        this.captchaCacheProvider = captchaCacheProvider;
        this.securitySpi = securitySpi;
        this.wechatEngine = wechatEngine;
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    public ResponseValue getLoginConfig() {
        LoginConfigVo loginConfigVo = new LoginConfigVo();
        loginConfigVo.setLogo(this.getCdnUrl() + this.getArgumentVariable("mobile_login_logo").getStringValue());
        return ResponseValue.success((Object)loginConfigVo);
    }

    @RequestMapping(value={"/wechat/register/binding/phone"}, method={RequestMethod.POST})
    public ResponseValue wechatRegisterBindingPhone(@RequestBody WechatBindingPhoneRequest request) {
        if (request == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.debug(request.toString());
        if (StringUtils.isEmpty((String)request.getKey())) {
            return ResponseValue.error((String)"\u5fae\u4fe1\u53c2\u6570\u4e3a\u7a7a\uff1akey");
        }
        String type = request.getType();
        if (StringUtils.isEmpty((String)type)) {
            return ResponseValue.error((String)"\u672a\u627e\u5230\u8bf7\u6c42\u7c7b\u578b\uff1atype");
        }
        if (type.equals("wechat") || type.equals("routine") || type.equals("iosWx") || type.equals("androidWx")) {
            RegisterThirdUserRequest thirdUserRequest;
            if (type.equals("wechat") || type.equals("iosWx") || type.equals("androidWx")) {
                if (StringUtils.isEmpty((String)request.getPhone())) {
                    return ResponseValue.error((String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isEmpty((String)request.getCaptcha()) || StringUtils.isEmpty((String)request.getUuid())) {
                    return ResponseValue.error((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!this.validateSmsCode(request.getCaptcha(), request.getUuid())) {
                    return ResponseValue.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f");
                }
            } else {
                if (StringUtils.isEmpty((String)request.getCode())) {
                    return ResponseValue.error((String)"\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u624b\u673a\u53f7code\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)request.getEncryptedData())) {
                    return ResponseValue.error((String)"\u8bf7\u8ba4\u8bc1\u5fae\u4fe1\u8d26\u53f7\uff1a\u83b7\u53d6\u624b\u673a\u53f7\u7801\u5931\u8d25");
                }
                if (StringUtils.isEmpty((String)request.getIv())) {
                    return ResponseValue.error((String)"\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u624b\u673a\u53f7\u52a0\u5bc6\u7b97\u6cd5\u7684\u521d\u59cb\u5411\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String routineAppId = this.getArgumentVariable("routine_appid").getStringValue();
                if (StringUtils.isEmpty((String)routineAppId)) {
                    return ResponseValue.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fappId\u672a\u8bbe\u7f6e");
                }
                WechatMiniAuthorizeVo response = this.wechatEngine.getMiniAuthCode(request.getCode());
                this.logger.debug("\u8bf7\u6c42\u5fae\u4fe1\u767b\u5f55\u5c0f\u7a0b\u5e8f\u63a5\u53e3\uff1a{}", (Object)response);
                String decrypt = WechatUtils.decryptPhoneNumber(routineAppId, request.getEncryptedData(), response.getSessionKey(), request.getIv());
                if (StringUtils.isEmpty((String)decrypt)) {
                    return ResponseValue.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u624b\u673a\u53f7\u89e3\u5bc6\u5931\u8d25");
                }
                try {
                    ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)decrypt);
                    if (!objectNode.has("phoneNumber")) {
                        this.logger.warn("\u6ca1\u6709\u89e3\u6790\u5230\u5fae\u4fe1\u624b\u673a\u53f7\uff0cdecrypt=" + decrypt);
                        return ResponseValue.error((String)("\u6ca1\u6709\u89e3\u6790\u5230\u5fae\u4fe1\u624b\u673a\u53f7\uff0cdecrypt=" + decrypt));
                    }
                    String phone = objectNode.get("phoneNumber").textValue();
                    request.setPhone(phone);
                    this.logger.debug("\u89e3\u6790\u5230\u5fae\u4fe1\u624b\u673a\u53f7\uff1a" + phone);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u89e3\u5bc6\u6570\u636e\u8f6cjson\u5bf9\u8c61\u9519\u8bef:" + decrypt, e);
                }
            }
            if ((thirdUserRequest = this.getWechatOpenIdCache().get(request.getKey())) == null) {
                return ResponseValue.error((String)"\u7528\u6237\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u6e05\u9664\u7f13\u5b58\u91cd\u65b0\u767b\u5f55");
            }
            if (!type.equals(thirdUserRequest.getType())) {
                return ResponseValue.error((String)"\u7528\u6237\u7684\u7c7b\u578b\u4e0e\u7f13\u5b58\u4e2d\u7684\u7c7b\u578b\u4e0d\u7b26");
            }
            boolean isNew = true;
            String encryptPassword = null;
            int userTokenType = LoginUtils.getUserTokenType(request.getType());
            S_user_core userCore = this.getUserService().queryLoginUserOnly(request.getPhone());
            if (userCore != null) {
                if (type.equals("wechat") && userCore.getIs_wechat_public() == 1) {
                    return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7");
                }
                if (type.equals("routine") && userCore.getIs_wechat_routine() == 1) {
                    return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
                }
                if (type.equals("androidWx") && userCore.getIs_wechat_android() == 1) {
                    return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5fae\u4fe1Android");
                }
                if (type.equals("iosWx") && userCore.getIs_wechat_ios() == 1) {
                    return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5fae\u4fe1IOS");
                }
                EbUserToken userToken = this.getUserTokenService().queryToken(userCore.getId(), userTokenType);
                if (userToken != null) {
                    return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
                }
                if (type.equals("wechat")) {
                    userCore.setWx_open_id(thirdUserRequest.getOpenId());
                } else if (type.equals("routine")) {
                    userCore.setWx_union_id(thirdUserRequest.getOpenId());
                } else {
                    throw new UnsupportedOperationException("\u5176\u4ed6\u7c7b\u578b\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u6682\u672a\u5b9e\u73b0\uff0ctype = " + type);
                }
                LoginUtils.setupBindType(userCore, type);
                this.getUserRegisterService().execUpdateBindUser(userCore, thirdUserRequest.getSpreadPid(), userTokenType, thirdUserRequest.getOpenId());
                this.getUserCacheProvider().updateUser(userCore);
                encryptPassword = userCore.getPassword();
                isNew = false;
                this.logger.debug("\u5fae\u4fe1\u5df2\u6709\u7528\u6237\uff0c\u7ed1\u5b9a\u624b\u673a\u53f7\u6210\u529f");
            } else {
                EbUser ebUser = this.registerUser(request.getPhone(), thirdUserRequest.getSpreadPid(), type, thirdUserRequest.getOpenId(), userTokenType);
                encryptPassword = ebUser.getPwd();
                this.logger.debug("\u5fae\u4fe1\u65b0\u7528\u6237\uff0c\u7ed1\u5b9a\u624b\u673a\u53f7\u6210\u529f");
            }
            try {
                RequestLogin requestLogin = LoginUtils.acquireRequestLoginByWechatPublic(request.getPhone(), encryptPassword);
                Map data = this.securitySpi.login(requestLogin);
                return ResponseValue.success((Object)LoginUtils.acquireLoginInfoVo(data));
            }
            catch (LoginException ex) {
                this.logger.error("\u5fae\u4fe1\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0copenid = {}, key = {}", (Object)thirdUserRequest.getOpenId(), (Object)request.getKey());
                throw new PlatformRuntimeException("\u5fae\u4fe1\u7ed1\u5b9a\uff0c\u767b\u5f55\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
        throw new UnsupportedOperationException("\u5176\u4ed6\uff08\u5fae\u4fe1\uff09\u767b\u5f55\u4ee3\u7801\u672a\u5b9e\u73b0\uff0c\u4ee3\u7801\u4e0d\u4f1a\u8d70\u5230\u8fd9\u91cc");
    }

    @RequestMapping(value={"/wechat/routine"}, method={RequestMethod.POST})
    public ResponseValue wechatRoutineLogin(@RequestBody RegisterThirdUserRequest request) {
        EbUserToken userToken;
        if (request == null || StringUtils.isEmpty((String)request.getCode())) {
            return ResponseValue.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6388\u6743\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.debug("\u8c03\u7528\u4e86\u5fae\u4fe1\uff08\u5c0f\u7a0b\u5e8f\uff09\u6388\u6743\u767b\u5f55\u63a5\u53e3\uff1a{}", (Object)request);
        WechatMiniAuthorizeVo response = this.wechatEngine.getMiniAuthCode(request.getCode());
        long spreadId = 0L;
        if (request.getSpreadPid() != null) {
            spreadId = request.getSpreadPid();
        }
        if ((userToken = this.getUserTokenService().queryUserToken(request.getOpenId(), Constants.USER_TOKEN_TYPE_ROUTINE)) != null) {
            this.logger.debug("\u5df2\u5b58\u5728token\u5173\u8054\u7528\u6237\uff0c\u76f4\u63a5\u767b\u5f55(\u5fae\u4fe1\u5c0f\u7a0b\u5e8f)");
            return this.doCreateWechatLoginData(userToken.getUid());
        }
        LoginInfoVo vo = new LoginInfoVo();
        request.setSpreadPid(Long.valueOf(spreadId));
        request.setType("routine");
        request.setOpenId(response.getOpenId());
        this.systemLogSuccess(null, OperateUser.Mobile, BusinessType.Insert, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6:getMiniAuthCode", response.toString(), response.getOpenId());
        String key = MD5.getMessageDigest((byte[])response.getOpenId().getBytes());
        this.getWechatOpenIdCache().save(key, request);
        vo.setType("register");
        vo.setKey(key);
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/wechat/public"}, method={RequestMethod.POST})
    public ResponseValue wechatPublicLogin(@RequestBody WechatLoginRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getCode())) {
            return ResponseValue.error((String)"\u8bf7\u6c42\u5fae\u4fe1\u767b\u5f55\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.debug("\u8c03\u7528\u4e86\u5fae\u4fe1\u6388\u6743\u767b\u5f55\u63a5\u53e3\uff1a{}", (Object)request);
        long spreadId = 0L;
        if (request.getSpreadPid() != null) {
            spreadId = request.getSpreadPid();
        }
        WeChatOauthToken oauthToken = this.wechatEngine.getOauth2AccessToken(request.getCode());
        EbUserToken userToken = this.getUserTokenService().queryUserToken(oauthToken.getOpenid(), Constants.USER_TOKEN_TYPE_WECHAT);
        if (userToken != null) {
            this.logger.debug("\u5df2\u5b58\u5728token\u5173\u8054\u7528\u6237\uff0c\u76f4\u63a5\u767b\u5f55(\u516c\u4f17\u53f7)");
            return this.doCreateWechatLoginData(userToken.getUid());
        }
        LoginInfoVo vo = new LoginInfoVo();
        WeChatAuthorizeLoginUserInfoVo userInfo = this.wechatEngine.getSnsUserInfo(oauthToken.getAccess_token(), oauthToken.getOpenid());
        RegisterThirdUserRequest thirdUserRequest = new RegisterThirdUserRequest();
        thirdUserRequest.setOpenId(userInfo.getOpenid());
        thirdUserRequest.setType("wechat");
        thirdUserRequest.setSpreadPid(Long.valueOf(spreadId));
        thirdUserRequest.setCode(request.getCode());
        this.systemLogSuccess(null, OperateUser.Mobile, BusinessType.Insert, "\u5fae\u4fe1\u83b7\u53d6:snsUserInfo", oauthToken.toString(), userInfo.toString());
        String key = MD5.getMessageDigest((byte[])oauthToken.getOpenid().getBytes());
        this.getWechatOpenIdCache().save(key, thirdUserRequest);
        vo.setType("register");
        vo.setKey(key);
        return ResponseValue.success((Object)vo);
    }

    private ResponseValue doCreateWechatLoginData(long userId) {
        S_user_core userCore = this.getUser(userId);
        RequestLogin requestLogin = LoginUtils.acquireRequestLoginByWechatPublic(userCore.getUser_name(), userCore.getPassword());
        try {
            Map data = this.securitySpi.login(requestLogin);
            return ResponseValue.success((Object)LoginUtils.acquireLoginInfoVo(data));
        }
        catch (LoginException e) {
            return ResponseValue.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/token/is/exist"}, method={RequestMethod.POST})
    public ResponseValue tokenIsExist() {
        if (this.getCurrentUser() == null) {
            return ResponseValue.success((Object)false);
        }
        return ResponseValue.success((Object)true);
    }

    @RequestMapping(value={"/mobile/password"}, method={RequestMethod.POST})
    public ResponseValue phonePasswordLogin(@RequestBody LoginParam loginParam) {
        if (loginParam == null || StringUtils.isEmpty((String)loginParam.getPassword()) || StringUtils.isEmpty((String)loginParam.getPhone())) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u767b\u5f55\u4fe1\u606f");
        }
        if (!PhoneNumberUtils.isCellPhoneNumber((String)loginParam.getPhone())) {
            return ResponseValue.error((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        this.logger.debug(loginParam.toString());
        RequestLogin requestLogin = LoginUtils.acquireRequestLoginByPassword(loginParam);
        try {
            Map data = this.securitySpi.login(requestLogin);
            return ResponseValue.success((Object)LoginUtils.acquireLoginInfoVo(data));
        }
        catch (LoginException e) {
            return ResponseValue.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/mobile/captcha"}, method={RequestMethod.POST})
    public ResponseValue phoneCaptchaLogin(@RequestBody LoginParam loginParam) {
        if (loginParam == null || StringUtils.isEmpty((String)loginParam.getUuid()) || StringUtils.isEmpty((String)loginParam.getCaptcha()) || StringUtils.isEmpty((String)loginParam.getPhone())) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u767b\u5f55\u4fe1\u606f");
        }
        if (!PhoneNumberUtils.isCellPhoneNumber((String)loginParam.getPhone())) {
            return ResponseValue.error((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        this.logger.debug(loginParam.toString());
        RequestLogin requestLogin = LoginUtils.acquireRequestLoginByCaptcha(loginParam);
        try {
            Map data = this.securitySpi.login(requestLogin);
            return ResponseValue.success((Object)LoginUtils.acquireLoginInfoVo(data));
        }
        catch (LoginException e) {
            if (!e.isUserPhoneNotExist()) {
                return ResponseValue.error((String)e.getMessage());
            }
            if (this.securitySpi.isAllowMobileLoginRegister()) {
                if (!this.getArgumentVariable("security.account.register").getBooleanValue()) {
                    return ResponseValue.error((String)"\u5e73\u53f0\u5df2\u5173\u95ed\u6ce8\u518c\u529f\u80fd");
                }
                this.logger.debug("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u5b58\u5728\uff0c\u53ef\u4ee5\u76f4\u63a5\u6ce8\u518c\uff1a" + requestLogin.getUsername());
                EbUser user = this.registerUser(requestLogin.getUsername(), loginParam.getSpreadPid(), null, null, 0);
                try {
                    Map data = this.securitySpi.login(requestLogin);
                    return ResponseValue.success((Object)LoginUtils.acquireLoginInfoVo(data));
                }
                catch (LoginException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return ResponseValue.error((String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
    }

    private EbUser registerUser(String phone, Long spreadUid, String bindType, String bindToken, int bindUserTokenType) {
        Object defaultAvatar = this.getArgumentVariable("h5_avatar").getStringValue();
        if (StringUtils.isNotEmpty((String)defaultAvatar)) {
            defaultAvatar = this.getCdnUrl() + (String)defaultAvatar;
        }
        String defaultPassEncrypt = this.getArgumentVariable("security.password.init").getStringValue();
        S_user_core userCore = LoginUtils.acquireMobileRegisterUserCore(phone, defaultPassEncrypt, (String)defaultAvatar);
        userCore.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        userCore.setWx_open_id(bindToken);
        LoginUtils.setupBindType(userCore, bindType);
        EbUser ebUser = LoginUtils.acquireMobileRegisterEbUser(phone, userCore, (String)defaultAvatar);
        if (spreadUid != null) {
            ebUser.setSpreadUid(spreadUid);
            ebUser.setSpreadTime(userCore.getCreate_time());
            this.logger.warn("\u9700\u8981\u540e\u7eed\u6dfb\u52a0\u5904\u7406\u5206\u9500\u7684\u7ed1\u5b9a\u5173\u7cfb\uff0c\u6682\u672a\u5b9e\u73b0\uff01");
        } else {
            ebUser.setSpreadUid(Long.valueOf(0L));
        }
        EbUserToken userToken = null;
        if (StringUtils.isNotEmpty((String)bindToken)) {
            userToken = VoUtils.acquireEbUserToken((int)bindUserTokenType, (long)userCore.getId(), (String)bindToken);
        }
        this.getUserRegisterService().execInsertMobileUserRegister(userCore, ebUser, null, userToken);
        this.getUserCacheProvider().putUser(userCore);
        this.getUserRegCache().save(ebUser);
        return ebUser;
    }

    @RequestMapping(value={"/send/code"})
    public ResponseValue sendSmsCode(@RequestBody SmsCodeParam param) {
        if (param == null || StringUtils.isEmpty((String)param.getPhone())) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
        }
        this.logger.debug(param.toString());
        if (StringUtils.isEmpty((String)param.getUuid()) || StringUtils.isEmpty((String)param.getX())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        CaptchaResult captchaResult = new CaptchaResult();
        captchaResult.setUuid(param.getUuid());
        captchaResult.setCode(param.getX());
        boolean success = this.blockPuzzleCaptchaProvider.validateCaptcha(captchaResult);
        this.logger.debug("\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7ed3\u679c = " + success);
        if (!success) {
            return ResponseValue.error((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1");
        }
        try {
            Map data = this.sendSmsCodeValidation(param.getPhone());
            return ResponseValue.success((Object)data);
        }
        catch (Exception ex) {
            this.logger.error("\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
            return ResponseValue.error((String)ex.getMessage());
        }
    }

    @RequestMapping(value={"/captcha/jigsaw/mobile_validate"})
    public ResponseValue validateJigsawMobileCaptcha(@RequestBody CaptchaParam param) {
        if (param == null || StringUtils.isEmpty((String)param.getToken()) || StringUtils.isEmpty((String)param.getX())) {
            return ResponseValue.error((String)"\u672a\u63a5\u6536\u5230\u9a8c\u8bc1\u8f93\u5165\u4fe1\u606f!");
        }
        this.logger.debug(param.toString());
        CaptchaResult captchaResult = new CaptchaResult();
        captchaResult.setUuid(param.getToken());
        captchaResult.setCode(param.getX());
        HashMap<String, String> data = new HashMap<String, String>(4);
        boolean success = this.blockPuzzleCaptchaProvider.validateCaptcha(captchaResult);
        if (!success) {
            data.put("verify", "-1");
            return ResponseValue.success(data);
        }
        data.put("verify", "1");
        data.put("x", param.getX());
        data.put("uuid", param.getToken());
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/captcha/jigsaw/mobile"})
    public ResponseValue generateJigsawMobileCaptcha(CaptchaParam param) {
        String uuid = IdUtils.simpleUUID();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("uuid", uuid);
        String verifyKey = "captcha_codes:" + uuid;
        JigsawResult captchaResult = (JigsawResult)this.blockPuzzleCaptchaProvider.generateCaptcha(null);
        if (captchaResult == null || captchaResult.getX() == 0) {
            return ResponseValue.error((String)"\u62fc\u56fe\u9a8c\u8bc1\u7801\u751f\u6210\u9519\u8bef, null");
        }
        this.captchaCacheProvider.putCacheData(verifyKey, (Object)String.valueOf(captchaResult.getX()), 60L);
        this.logger.debug("\u5199\u5165\u62fc\u56fe\u9a8c\u8bc1\u4f4d\u7f6e\uff0cx = {}", (Object)captchaResult.getX());
        data.put("y", captchaResult.getY());
        data.put("slider", captchaResult.getImageBlockBase64());
        data.put("bg", captchaResult.getImageSourceBase64());
        return ResponseValue.success(data);
    }
}

