/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.vo.MerchantDetailVo;
import com.ishop.model.vo.MerchantIndexVo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/merchant"})
public class MerchantApi
extends BaseApi {
    @RequestMapping(value={"/detail/{id}"}, method={RequestMethod.GET})
    public ResponseValue getDetail(@PathVariable Integer id) {
        if (id == null || id <= 0) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbMerchant merchant = this.getMerchantCache().get(id.intValue());
        if (merchant == null) {
            return ResponseValue.error((String)"\u5546\u6237\u4e0d\u5b58\u5728");
        }
        if (merchant.getIsSwitch() == 0) {
            return ResponseValue.error((String)"\u5546\u6237\u672a\u8425\u4e1a");
        }
        MerchantDetailVo detailVo = VoUtils.acquireMerchantDetailVo(merchant);
        EbMerchantInfo merchantInfo = this.getMerchantService().queryMerchantInfo(id.intValue());
        VoUtils.combineMerchantInfo(detailVo, merchantInfo);
        detailVo.setFollowerNum(Integer.valueOf(0));
        detailVo.setIsCollect(Boolean.valueOf(false));
        return ResponseValue.success((Object)detailVo);
    }

    @RequestMapping(value={"/index/info/{id}"}, method={RequestMethod.GET})
    public ResponseValue getIndexInfo(@PathVariable Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("id is required!");
        }
        EbMerchant merchant = this.getMerchantCache().get(id.intValue());
        if (merchant == null) {
            return ResponseValue.error((String)"\u5546\u6237\u4e0d\u5b58\u5728");
        }
        if (merchant.getIsSwitch() == 0) {
            return ResponseValue.error((String)"\u5546\u6237\u672a\u8425\u4e1a");
        }
        MerchantIndexVo vo = VoUtils.acquireMerchantIndexVo(merchant, this.getCdnUrl());
        EbMerchantInfo merchantInfo = this.getMerchantService().queryMerchantInfo(id.intValue());
        vo.setServiceType(merchantInfo.getServiceType());
        vo.setServiceLink(merchantInfo.getServiceLink());
        vo.setServicePhone(merchantInfo.getServicePhone());
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/customer/service/info/{id}"}, method={RequestMethod.GET})
    public ResponseValue getCustomerServiceInfo(@PathVariable(value="id") Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("id is required!");
        }
        EbMerchant merchant = this.getMerchantCache().get(id.intValue());
        if (merchant == null) {
            return ResponseValue.error((String)"\u5546\u6237\u4e0d\u5b58\u5728");
        }
        EbMerchantInfo info = this.getMerchantService().queryMerchantInfo(id.intValue());
        return ResponseValue.success((Object)VoUtils.acquireMerchantServiceInfoVo(info));
    }

    @RequestMapping(value={"/product/category/cache/tree/{id}"}, method={RequestMethod.GET})
    public ResponseValue getCacheTree(@PathVariable(value="id") Integer id) {
        List listTree = this.getMerProductCategoryCache().getTree(String.valueOf(id));
        return ResponseValue.success((Object)listTree);
    }

    @RequestMapping(value={"/all/type/list"}, method={RequestMethod.GET})
    public ResponseValue allTypeList() {
        return ResponseValue.success((Object)this.getMerchantTypeCache().getList());
    }

    @RequestMapping(value={"/all/category/list"}, method={RequestMethod.GET})
    public ResponseValue allCategoryList() {
        return ResponseValue.success((Object)this.getMerchantCategoryCache().getList());
    }
}

