/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.util.VoUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.PreOrderRequest;
import com.ishop.mobile.util.OrderUtils;
import com.ishop.model.MyRecord;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserAddress;
import com.ishop.model.request.CreateOrderRequest;
import com.ishop.model.request.OrderComputedPriceRequest;
import com.ishop.model.request.OrderMerchantRequest;
import com.ishop.model.response.ComputedMerchantOrderResponse;
import com.ishop.model.response.ComputedOrderPriceResponse;
import com.ishop.model.response.MerchantOrderFrontDetailResponse;
import com.ishop.model.response.OrderFrontDetailResponse;
import com.ishop.model.vo.OrderDetailFrontVo;
import com.ishop.model.vo.OrderFrontVo;
import com.ishop.model.vo.OrderNoVo;
import com.ishop.model.vo.PreMerchantOrderVo;
import com.ishop.model.vo.PreOrderDetailVo;
import com.ishop.model.vo.PreOrderResponse;
import com.ishop.model.vo.PreOrderVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/order"})
public class OrderApi
extends BaseApi {
    @RequestMapping(value={"/status/image"}, method={RequestMethod.GET})
    public ResponseValue getOrderStatusImage() {
        List mapList = this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_ORDER_STATUS_IMAGE, this.getCdnUrl());
        return ResponseValue.success((Object)mapList);
    }

    @RequestMapping(value={"/detail/{orderNo}"}, method={RequestMethod.GET})
    public ResponseValue detail(@PathVariable String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8ba2\u5355");
        }
        EbOrder order = this.getOrderService().queryOrder(orderNo);
        if (order == null) {
            return ResponseValue.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OrderFrontDetailResponse response = com.ishop.mobile.util.VoUtils.acquireOrderFrontDetailResponse(order);
        List merchantOrderList = this.getOrderService().queryMerchantOrderList(orderNo);
        List orderDetailList = this.getOrderService().queryOrderDetailList(orderNo);
        Map<Integer, List<EbOrderDetail>> orderDetailMap = orderDetailList.stream().collect(Collectors.groupingBy(EbOrderDetail::getMerId));
        ArrayList<MerchantOrderFrontDetailResponse> merDetailResponseList = new ArrayList<MerchantOrderFrontDetailResponse>(8);
        MerchantOrderFrontDetailResponse merDetailResponse = null;
        EbMerchant merchant = null;
        for (EbMerchantOrder merchantOrder : merchantOrderList) {
            merDetailResponse = new MerchantOrderFrontDetailResponse();
            merchant = this.getMerchantCache().get(merchantOrder.getMerId().intValue());
            merDetailResponse.setMerName(merchant.getName());
            if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                merDetailResponse.setMerPhone(merchant.getPhone());
                merDetailResponse.setMerProvince(merchant.getProvince());
                merDetailResponse.setMerCity(merchant.getCity());
                merDetailResponse.setMerDistrict(merchant.getDistrict());
                merDetailResponse.setMerAddressDetail(merchant.getAddressDetail());
                merDetailResponse.setMerLatitude(merchant.getLatitude());
                merDetailResponse.setMerLongitude(merchant.getLongitude());
            }
            List<EbOrderDetail> detailList = orderDetailMap.get(merchantOrder.getMerId());
            ArrayList<OrderDetailFrontVo> dataResponseList = new ArrayList<OrderDetailFrontVo>(2);
            OrderDetailFrontVo detailFrontVo = null;
            for (EbOrderDetail detail : detailList) {
                detailFrontVo = VoUtils.acquireOrderDetailFrontVo((EbOrderDetail)detail);
                dataResponseList.add(detailFrontVo);
            }
            merDetailResponse.setOrderInfoList(dataResponseList);
            merDetailResponseList.add(merDetailResponse);
        }
        response.setMerchantOrderList(merDetailResponseList);
        return ResponseValue.success((Object)response);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ResponseValue createOrder(@RequestBody CreateOrderRequest orderRequest) {
        if (orderRequest == null || StringUtils.isEmpty((String)orderRequest.getPreOrderNo()) || StringUtils.isEmptyList((List)orderRequest.getOrderMerchantRequestList())) {
            return ResponseValue.error((String)"\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        EbUser user = this.getCurrentEbUser();
        PreOrderVo preOrderVo = this.getPreOrderCache().get(orderRequest.getPreOrderNo());
        if (preOrderVo == null) {
            return ResponseValue.error((String)"\u9884\u4e0b\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
        }
        if (preOrderVo.getType().intValue() == OrderConstants.ORDER_TYPE_SECKILL.intValue()) {
            return ResponseValue.success((Object)this.doCreateSecondsKillOrder());
        }
        List orderMerchantRequestList = orderRequest.getOrderMerchantRequestList();
        if (StringUtils.isEmptyList((List)orderMerchantRequestList)) {
            throw new PlatformRuntimeException("\u5546\u54c1\u5217\u8868\u4e0d\u5b58\u5728");
        }
        List merchantOrderVoList = preOrderVo.getMerchantOrderVoList();
        EbUserAddress userAddress = null;
        boolean autoShippingDone = this.isAutoShippingDone(merchantOrderVoList);
        if (!autoShippingDone) {
            if (orderRequest.getAddressId() == null || orderRequest.getAddressId() <= 0L) {
                return ResponseValue.error((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5730\u5740");
            }
            userAddress = this.checkUserAddress(orderMerchantRequestList, orderRequest.getAddressId());
        }
        this.checkIsTakeTheir(orderMerchantRequestList);
        List<MyRecord> skuRecordList = this.checkProductStock(preOrderVo.getType(), merchantOrderVoList);
        this.doComputeFreightFee(preOrderVo, userAddress, autoShippingDone);
        this.acquireCouponFee(preOrderVo, orderMerchantRequestList, user.getId());
        if (orderRequest.getIsUseIntegral().booleanValue() && user.getIntegral() > 0) {
            this.doComputeIntegralDeduction(preOrderVo, user.getIntegral());
        }
        EbOrder order = OrderUtils.acquirePlatformOrder(user.getId(), preOrderVo);
        ArrayList<Long> couponIdList = new ArrayList<Long>(4);
        Object[] orderResult = OrderUtils.acquireMerchantOrderList(couponIdList, merchantOrderVoList, orderMerchantRequestList, order.getOrderNo(), order.getType(), user.getId(), order.getCreateTime(), userAddress, autoShippingDone);
        List merchantOrderList = (List)orderResult[0];
        List orderDetailList = (List)orderResult[1];
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug("\u8ba2\u5355\u751f\u6210\uff1a\u5546\u6237\u8ba2\u5355\u5217\u8868\uff1a {}", (Object)JsonUtils.objectToJsonString((Object)merchantOrderList));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getFrontOrderService().execCreateOrder(order.getType(), skuRecordList, orderRequest.getPreOrderNo(), order, merchantOrderList, orderDetailList, couponIdList, preOrderVo.getCartIdList());
        this.getPreOrderCache().remove(orderRequest.getPreOrderNo());
        this.logger.debug("\u8ba2\u5355\u521b\u5efa\u6210\u529f\uff01\u5220\u9664\u7f13\u5b58\uff1a\u9884\u8ba2\u5355\u8bb0\u5f55," + orderRequest.getPreOrderNo());
        OrderNoVo response = new OrderNoVo();
        response.setOrderNo(order.getOrderNo());
        response.setPayPrice(order.getPayPrice());
        return ResponseValue.success((Object)response);
    }

    private boolean isAutoShippingDone(List<PreMerchantOrderVo> merchantOrderVoList) {
        for (PreMerchantOrderVo merchantOrderVo : merchantOrderVoList) {
            EbProduct product = null;
            for (PreOrderDetailVo info : merchantOrderVo.getOrderInfoList()) {
                product = this.getProductCache().get(info.getProductId().longValue());
                if (product.getTempId() == -1) continue;
                return false;
            }
        }
        return true;
    }

    private void doComputeIntegralDeduction(PreOrderVo preOrderVo, int userIntegral) {
        boolean integralDeductionEnabled = this.getArgumentVariable("integral_deduction_money").getBooleanValue();
        if (preOrderVo.getIsUseIntegral().booleanValue() && !integralDeductionEnabled) {
            throw new PlatformRuntimeException("\u79ef\u5206\u62b5\u6263\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u4f7f\u7528\u79ef\u5206");
        }
        double payPrice = preOrderVo.getProTotalFee() - preOrderVo.getCouponFee();
        double integralDeductionStartMoney = this.getArgumentVariable("integral_deduction_start_money").getDoubleValue();
        if (integralDeductionStartMoney <= 0.0 || payPrice < integralDeductionStartMoney) {
            throw new PlatformRuntimeException("\u652f\u4ed8\u91d1\u989d\u4e0d\u6ee1\u8db3\u79ef\u5206\u62b5\u6263\u8d77\u59cb\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
        }
        this.logger.warn("\u521b\u5efa\u8ba2\u5355\uff1a\u8ba1\u7b97\u79ef\u5206\u62b5\u6263\u4ee3\u7801\u672a\u5b9e\u73b0");
    }

    private List<MyRecord> checkProductStock(int orderType, List<PreMerchantOrderVo> merchantOrderVoList) {
        ArrayList<MyRecord> recordList = new ArrayList<MyRecord>(4);
        if (orderType == OrderConstants.ORDER_TYPE_SECKILL) {
            this.logger.warn("\u79d2\u6740\u5546\u54c1\u8ba2\u5355\uff0c\u68c0\u67e5\u5e93\u5b58\u4ee3\u7801\u672a\u5b9e\u73b0");
            return recordList;
        }
        if (orderType == OrderConstants.ORDER_TYPE_VIDEO) {
            this.logger.warn("\u89c6\u9891\u53f7\u5546\u54c1\u8ba2\u5355\uff0c\u68c0\u67e5\u5e93\u5b58\u4ee3\u7801\u672a\u5b9e\u73b0");
            return recordList;
        }
        EbMerchant merchant = null;
        for (PreMerchantOrderVo merchantOrderVo : merchantOrderVoList) {
            merchant = this.getMerchantCache().get(merchantOrderVo.getMerId().intValue());
            if (merchant.getIsSwitch() == 0) {
                throw new PlatformRuntimeException("\u5546\u6237\u5df2\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
            }
            EbProduct product = null;
            for (PreOrderDetailVo info : merchantOrderVo.getOrderInfoList()) {
                product = this.getProductCache().get(info.getProductId().longValue());
                if (product == null || product.getIsDel() == 1) {
                    throw new PlatformRuntimeException("\u8d2d\u4e70\u7684\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                if (product.getIsShow() == 0) {
                    throw new PlatformRuntimeException("\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u4e0b\u67b6");
                }
                if (product.getStock() == 0 || info.getPayNum() > product.getStock()) {
                    throw new PlatformRuntimeException("\u8d2d\u4e70\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                EbProductAttrValue attrValue = this.getProductAttrValueService().queryByIdAndProductIdAndType(info.getAttrValueId(), product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
                if (attrValue == null) {
                    throw new PlatformRuntimeException("\u8d2d\u4e70\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                if (attrValue.getStock() < info.getPayNum()) {
                    throw new PlatformRuntimeException("\u8d2d\u4e70\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                MyRecord record = new MyRecord();
                record.set("productId", (Object)info.getProductId());
                record.set("num", (Object)info.getPayNum());
                record.set("attrValueId", (Object)info.getAttrValueId());
                record.set("attrValueVersion", (Object)attrValue.getVersion());
                recordList.add(record);
            }
        }
        return recordList;
    }

    private EbUserAddress checkUserAddress(List<OrderMerchantRequest> orderMerchantRequestList, Long addressId) {
        EbUserAddress userAddress = null;
        for (OrderMerchantRequest request : orderMerchantRequestList) {
            if (request.getShippingType().intValue() != OrderConstants.ORDER_SHIPPING_TYPE_EXPRESS.intValue()) continue;
            if (addressId == null || addressId <= 0L) {
                throw new PlatformRuntimeException("\u8bf7\u9009\u62e9\u6536\u83b7\u5730\u5740");
            }
            userAddress = (EbUserAddress)this.getUserAddressService().get((BasePo)new EbUserAddress(addressId));
            if (userAddress != null && userAddress.getIsDel() != 1) continue;
            throw new PlatformRuntimeException("\u6536\u83b7\u5730\u5740\u4e0d\u5b58\u5728");
        }
        return userAddress;
    }

    private OrderNoVo doCreateSecondsKillOrder() {
        this.logger.warn("\u79d2\u6740\u8ba2\u5355\uff0c\u521b\u5efa\u4ee3\u7801\u672a\u5b9e\u73b0");
        return new OrderNoVo();
    }

    @RequestMapping(value={"/computed/price"}, method={RequestMethod.POST})
    public ResponseValue computedPrice(@RequestBody OrderComputedPriceRequest request) {
        String key = request.getPreOrderNo();
        PreOrderVo preOrderVo = this.getPreOrderCache().get(key);
        if (preOrderVo == null) {
            return ResponseValue.error((String)"\u9884\u4e0b\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List orderMerchantRequestList = request.getOrderMerchantRequestList();
        if (StringUtils.isEmptyList((List)orderMerchantRequestList)) {
            throw new PlatformRuntimeException("\u5546\u54c1\u5217\u8868\u4e0d\u5b58\u5728");
        }
        this.checkIsTakeTheir(orderMerchantRequestList);
        boolean integralDeductionEnabled = this.getArgumentVariable("integral_deduction_money").getBooleanValue();
        if (request.getIsUseIntegral().booleanValue() && !integralDeductionEnabled) {
            return ResponseValue.error((String)"\u79ef\u5206\u62b5\u6263\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u4f7f\u7528\u79ef\u5206");
        }
        long userId = this.getCurrentUserId();
        EbUser user = this.getUserRegCache().get(userId);
        ComputedOrderPriceResponse response = this.doComputePrice(request, preOrderVo, userId, user.getIntegral(), integralDeductionEnabled);
        return ResponseValue.success((Object)response);
    }

    private void checkIsTakeTheir(List<OrderMerchantRequest> orderMerchantRequestList) {
        for (OrderMerchantRequest orderMerchantRequest : orderMerchantRequestList) {
            if (orderMerchantRequest.getShippingType().intValue() != OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP.intValue() || this.getMerchantCache().get(orderMerchantRequest.getMerId().intValue()).getIsTakeTheir() != 0) continue;
            throw new PlatformRuntimeException("\u5546\u6237\u672a\u5f00\u542f\u95e8\u5e97\u81ea\u63d0\u529f\u80fd");
        }
    }

    private ComputedOrderPriceResponse doComputePrice(OrderComputedPriceRequest request, PreOrderVo preOrderVo, long userId, int integral, boolean integralDeductionEnabled) {
        ComputedOrderPriceResponse priceResponse = new ComputedOrderPriceResponse();
        List orderMerchantRequestList = request.getOrderMerchantRequestList();
        for (PreMerchantOrderVo merchantOrderVo : preOrderVo.getMerchantOrderVoList()) {
            for (OrderMerchantRequest o : orderMerchantRequestList) {
                if (o.getMerId().intValue() != merchantOrderVo.getMerId().intValue()) continue;
                merchantOrderVo.setShippingType(o.getShippingType());
                merchantOrderVo.setUserCouponId(o.getUserCouponId());
            }
        }
        EbUserAddress userAddress = null;
        boolean autoShippingDone = this.isAutoShippingDone(preOrderVo.getMerchantOrderVoList());
        if (!autoShippingDone) {
            userAddress = (EbUserAddress)this.getUserAddressService().get((BasePo)new EbUserAddress(request.getAddressId()));
        }
        this.doComputeFreightFee(preOrderVo, userAddress, autoShippingDone);
        priceResponse.setFreightFee(preOrderVo.getFreightFee());
        this.acquireCouponFee(preOrderVo, orderMerchantRequestList, userId);
        priceResponse.setCouponFee(preOrderVo.getCouponFee());
        ArrayList merOrderResponseList = new ArrayList(preOrderVo.getMerchantOrderVoList().size());
        ComputedMerchantOrderResponse computedMerchantOrder = null;
        for (PreMerchantOrderVo merchantOrderVo : preOrderVo.getMerchantOrderVoList()) {
            computedMerchantOrder = new ComputedMerchantOrderResponse();
            computedMerchantOrder.setMerId(merchantOrderVo.getMerId());
            computedMerchantOrder.setCouponFee(merchantOrderVo.getCouponFee());
            computedMerchantOrder.setFreightFee(merchantOrderVo.getFreightFee());
            computedMerchantOrder.setUserCouponId(merchantOrderVo.getUserCouponId());
        }
        priceResponse.setMerOrderResponseList(merOrderResponseList);
        double integralDeductionStartMoney = this.getArgumentVariable("integral_deduction_start_money").getDoubleValue();
        Double payPrice = preOrderVo.getProTotalFee() - priceResponse.getCouponFee();
        priceResponse.setIsUseIntegral(request.getIsUseIntegral());
        priceResponse.setProTotalFee(preOrderVo.getProTotalFee());
        if (!request.getIsUseIntegral().booleanValue() || integral <= 0) {
            priceResponse.setDeductionPrice(Double.valueOf(0.0));
            priceResponse.setSurplusIntegral(Integer.valueOf(integral));
            priceResponse.setPayFee(Double.valueOf(payPrice + priceResponse.getFreightFee()));
            priceResponse.setUsedIntegral(Integer.valueOf(0));
            priceResponse.setIntegralDeductionSwitch(Boolean.valueOf(false));
            priceResponse.setIsUseIntegral(Boolean.valueOf(false));
            if (integralDeductionEnabled && payPrice >= integralDeductionStartMoney) {
                priceResponse.setIntegralDeductionSwitch(Boolean.valueOf(true));
            }
            return priceResponse;
        }
        if (request.getIsUseIntegral().booleanValue() && integral > 0) {
            if (integralDeductionStartMoney <= 0.0 || payPrice < integralDeductionStartMoney) {
                priceResponse.setDeductionPrice(Double.valueOf(0.0));
                priceResponse.setSurplusIntegral(Integer.valueOf(integral));
                priceResponse.setPayFee(Double.valueOf(payPrice + priceResponse.getFreightFee()));
                priceResponse.setUsedIntegral(Integer.valueOf(0));
                priceResponse.setIntegralDeductionSwitch(Boolean.valueOf(false));
                priceResponse.setIsUseIntegral(Boolean.valueOf(false));
                return priceResponse;
            }
            double integralRatio = this.getArgumentVariable("integral_deduction_ratio").getDoubleValue();
            double canDeductionPrice = NumberFormatUtils.scaleAccuracy2((double)(payPrice * integralRatio / 100.0));
            double integralDeductionMoney = this.getArgumentVariable("integral_deduction_money").getDoubleValue();
            double deductionPrice = (double)integral * integralDeductionMoney;
            if (deductionPrice <= canDeductionPrice) {
                priceResponse.setSurplusIntegral(Integer.valueOf(0));
                priceResponse.setUsedIntegral(Integer.valueOf(integral));
            } else {
                deductionPrice = canDeductionPrice;
                if (canDeductionPrice > 0.0) {
                    int usedIntegral = new Double(Math.round(canDeductionPrice / integralDeductionMoney)).intValue();
                    priceResponse.setSurplusIntegral(Integer.valueOf(integral - usedIntegral));
                    priceResponse.setUsedIntegral(Integer.valueOf(usedIntegral));
                }
            }
            payPrice = payPrice - deductionPrice;
            priceResponse.setPayFee(Double.valueOf(payPrice + priceResponse.getFreightFee()));
            priceResponse.setDeductionPrice(Double.valueOf(deductionPrice));
            priceResponse.setIsUseIntegral(Boolean.valueOf(true));
            priceResponse.setIntegralDeductionSwitch(Boolean.valueOf(true));
        }
        return priceResponse;
    }

    private void acquireCouponFee(PreOrderVo orderInfoVo, List<OrderMerchantRequest> orderMerchantRequestList, Long uid) {
        this.logger.warn("FrontOrderServiceImpl.getCouponFee()");
    }

    private void doComputeFreightFee(PreOrderVo preOrderVo, EbUserAddress userAddress, boolean autoShippingDone) {
        this.logger.warn("FrontOrderServiceImpl.getFreightFee()");
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue orderList(Integer status) {
        long userId = this.getCurrentUserId();
        GenericPager pager = this.getOrderService().queryUserOrderList(userId, status);
        List orderList = pager.getDatas();
        if (StringUtils.isEmptyList((List)orderList)) {
            return ResponseValue.success((Object)pager);
        }
        ArrayList<OrderFrontVo> responseList = new ArrayList<OrderFrontVo>(4);
        OrderFrontVo orderFrontVo = null;
        for (EbOrder order : orderList) {
            orderFrontVo = com.ishop.mobile.util.VoUtils.acquireOrderFrontVo(order);
            List orderDetailList = this.getOrderService().queryOrderDetailList(order.getOrderNo());
            ArrayList<OrderDetailFrontVo> infoResponseList = new ArrayList<OrderDetailFrontVo>(4);
            OrderDetailFrontVo detailFrontVo = null;
            for (EbOrderDetail detail : orderDetailList) {
                detailFrontVo = VoUtils.acquireOrderDetailFrontVo((EbOrderDetail)detail);
                infoResponseList.add(detailFrontVo);
            }
            orderFrontVo.setOrderInfoList(infoResponseList);
            if (order.getMerId() != null && order.getMerId() > 0) {
                orderFrontVo.setMerName(this.getMerchantCache().get(order.getMerId().intValue()).getName());
            }
            responseList.add(orderFrontVo);
        }
        return ResponseValue.success((Object)ListPageContext.createGenericPager(responseList, (int)pager.getPageIndex(), (int)pager.getPageSize(), (int)((int)pager.getTotalRows())));
    }

    @RequestMapping(value={"/load/pre/{preOrderNo}"}, method={RequestMethod.GET})
    public ResponseValue loadPreOrder(@PathVariable String preOrderNo) {
        if (StringUtils.isEmpty((String)preOrderNo)) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PreOrderVo vo = this.getPreOrderCache().get(preOrderNo);
        if (vo == null) {
            return ResponseValue.error((String)"\u9884\u4e0b\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PreOrderResponse response = new PreOrderResponse();
        response.setOrderInfoVo(vo);
        return ResponseValue.success((Object)response);
    }

    @RequestMapping(value={"/pre/order"}, method={RequestMethod.POST})
    public ResponseValue preOrder(@RequestBody PreOrderRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getPreOrderType())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug("\u9884\u4e0b\u5355 = {}", (Object)JsonUtils.objectToJsonString((Object)request));
            }
            catch (Exception e) {
                this.logger.warn("PreOrderRequest -> JSON \u9519\u8bef\uff1a" + e.getMessage());
            }
        }
        EbUser user = this.getUserRegCache().get(this.getCurrentUserId());
        PreOrderVo preOrderInfoVo = OrderUtils.validatePreOrderRequest(request, this.getCdnUrl());
        ArrayList orderInfoList = new ArrayList(4);
        for (PreMerchantOrderVo merchantOrderVo : preOrderInfoVo.getMerchantOrderVoList()) {
            orderInfoList.addAll(merchantOrderVo.getOrderInfoList());
            double merTotalPrice = 0.0;
            for (PreOrderDetailVo e : merchantOrderVo.getOrderInfoList()) {
                merTotalPrice += e.getPrice() * (double)e.getPayNum().intValue();
            }
            merchantOrderVo.setProTotalFee(Double.valueOf(merTotalPrice));
            merchantOrderVo.setProTotalNum(Integer.valueOf(merchantOrderVo.getOrderInfoList().stream().mapToInt(PreOrderDetailVo::getPayNum).sum()));
        }
        double totalPrice = 0.0;
        for (PreOrderDetailVo e : orderInfoList) {
            totalPrice += e.getPrice() * (double)e.getPayNum().intValue();
        }
        preOrderInfoVo.setProTotalFee(Double.valueOf(totalPrice));
        int orderProNum = orderInfoList.stream().mapToInt(PreOrderDetailVo::getPayNum).sum();
        preOrderInfoVo.setOrderProNum(Integer.valueOf(orderProNum));
        preOrderInfoVo.setFreightFee(Double.valueOf(0.0));
        preOrderInfoVo.setAddressId(Integer.valueOf(0));
        preOrderInfoVo.setPayFee(Double.valueOf(preOrderInfoVo.getProTotalFee() + preOrderInfoVo.getFreightFee()));
        preOrderInfoVo.setUserIntegral(user.getIntegral());
        preOrderInfoVo.setUserBalance(Double.valueOf(user.getNowMoney()));
        preOrderInfoVo.setIntegralDeductionSwitch(Boolean.valueOf(false));
        preOrderInfoVo.setIsUseIntegral(Boolean.valueOf(false));
        boolean integralDeductionEnabled = this.getArgumentVariable("integral_deduction_switch").getBooleanValue();
        double integralDeductionStartMoney = this.getArgumentVariable("integral_deduction_start_money").getDoubleValue();
        if (integralDeductionEnabled && preOrderInfoVo.getProTotalFee() >= integralDeductionStartMoney) {
            preOrderInfoVo.setIntegralDeductionSwitch(Boolean.valueOf(true));
        }
        boolean autoShippingDone = this.isAutoShippingDone(preOrderInfoVo.getMerchantOrderVoList());
        preOrderInfoVo.setAutoShippingDone(Boolean.valueOf(autoShippingDone));
        String key = user.getId().toString() + NumberGenerator.getLongSequenceNumber();
        this.getPreOrderCache().save(key, preOrderInfoVo, OrderConstants.PRE_ORDER_CACHE_TIME);
        OrderNoVo response = new OrderNoVo();
        response.setOrderNo(key);
        response.setOrderType(preOrderInfoVo.getType());
        try {
            this.logger.info("preOrder response:{}", (Object)JsonUtils.objectToJsonString((Object)response));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseValue.success((Object)response);
    }
}

