/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.util.PlatformRSAUtils;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.util.PayUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserConfig;
import com.ishop.model.request.OrderPayRequest;
import com.ishop.model.response.OrderPayResultResponse;
import com.ishop.model.response.PayConfigResponse;
import com.ishop.model.vo.WechatOrderVo;
import com.ishop.model.vo.WxPayJsResultVo;
import com.ishop.model.wechat.AttachVo;
import com.ishop.model.wechat.CreateOrderH5SceneInfoDetailVo;
import com.ishop.model.wechat.CreateOrderH5SceneInfoVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayEngineManager;
import com.walker.pay.PayStatus;
import com.walker.pay.exception.OrderException;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.wechat.v2.H5ResponsePay;
import com.walker.web.ResponseValue;
import com.walker.web.WebUserAgent;
import com.walker.web.util.UUID;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/pay"})
public class PayApi
extends BaseApi {
    private PayEngineManager payEngineManager;

    @Autowired
    public PayApi(PayEngineManager payEngineManager) {
        this.payEngineManager = payEngineManager;
    }

    @RequestMapping(value={"/query/wechat/pay/result/{orderNo}"}, method={RequestMethod.GET})
    public ResponseValue searchWechatPayOrder(@PathVariable(value="orderNo") String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"orderNo\u5fc5\u987b\u8f93\u5165");
        }
        EbOrder order = this.getOrderService().queryOrder(orderNo);
        if (order == null) {
            return ResponseValue.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId={}" + orderNo));
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            return ResponseValue.error((String)"\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        OrderStatusResponsePay responsePay = this.payEngineManager.searchOrderStatus(String.valueOf(order.getId()));
        if (responsePay == null) {
            this.logger.error("\u672a\u67e5\u8be2\u5230\u5fae\u4fe1\u8ba2\u5355\u72b6\u6001\uff0corderNo = " + orderNo);
            return ResponseValue.success((Object)false);
        }
        if (!responsePay.getStatus()) {
            this.logger.error("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff1a" + responsePay.getMessage());
            return ResponseValue.success((Object)false);
        }
        if (responsePay.getPayStatus() != PayStatus.Success) {
            this.logger.error("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355\u72b6\u6001\u3010\u672a\u6210\u529f\u3011\uff1a" + responsePay.getMessage());
            return ResponseValue.success((Object)false);
        }
        return ResponseValue.success((Object)true);
    }

    @RequestMapping(value={"/payment"}, method={RequestMethod.POST})
    public ResponseValue payment(@RequestBody OrderPayRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getOrderNo())) {
            return ResponseValue.error((String)"\u9884\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.logger.debug("\u652f\u4ed8\u65b9\u5f0f = " + request.getPayType());
        String orderNo = request.getOrderNo();
        EbOrder order = this.getOrderService().queryOrder(orderNo);
        if (order == null) {
            return ResponseValue.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            return ResponseValue.error((String)"\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (order.getPaid() == 1) {
            return ResponseValue.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        if (order.getStatus() > OrderConstants.ORDER_STATUS_WAIT_PAY) {
            return ResponseValue.error((String)"\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        long userId = this.getCurrentUserId();
        EbUser user = this.getUserRegCache().get(userId);
        if (request.getPayType().equals("yue")) {
            if (user.getNowMoney() < order.getPayPrice()) {
                return ResponseValue.error((String)"\u8d26\u6237\u4f59\u989d\u4e0d\u8db3");
            }
            if (!this.checkPayPass(request.getPayPass(), userId)) {
                return ResponseValue.error((String)"\u652f\u4ed8\u5bc6\u7801\u9519\u8bef");
            }
        }
        OrderPayResultResponse response = new OrderPayResultResponse();
        response.setOrderNo(order.getOrderNo());
        response.setPayType(request.getPayType());
        response.setPayChannel(request.getPayChannel());
        EbOrder updateOrder = new EbOrder(order.getId());
        updateOrder.setPayType(request.getPayType());
        updateOrder.setPayChannel(request.getPayChannel());
        updateOrder.setOrderNo(order.getOrderNo());
        updateOrder.setUpdateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        this.logger.debug("\u5f53\u524d\u652f\u4ed8\u6e20\u9053\uff0cpayChannel = {}", (Object)request.getPayChannel());
        if (request.getPayType().equals("yue")) {
            if (PayUtils.isAutoShippingDone((String)orderNo)) {
                updateOrder.setStatus(OrderConstants.ORDER_STATUS_COMPLETE);
                this.logger.debug("\u865a\u62df\u5546\u54c1\uff0c\u81ea\u52a8\u53d1\u8d27\u5b8c\u6210");
            } else {
                order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            }
            this.getPayService().execPayYue(updateOrder, order.getPayPrice().doubleValue(), userId, "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB", user);
            this.getUserRegCache().update(user);
            response.setStatus(Boolean.valueOf(true));
            this.logger.debug("\u4f59\u989d\u652f\u4ed8\u8ba2\u5355\u6210\u529f");
        } else if (request.getPayType().equals("weixin")) {
            WxPayJsResultVo vo = null;
            if (request.getPayChannel().equals("public") || request.getPayChannel().equals("h5")) {
                String userOpenId = PayUtils.filterUserOpenId((String)this.getCurrentUser().getWx_open_id());
                this.logger.debug("userOpenId={}", (Object)userOpenId);
                if (StringUtils.isEmpty((String)userOpenId)) {
                    return ResponseValue.error((String)"\u60a8\u8fd8\u672a\u6388\u6743\uff08\u7ed1\u5b9a\uff09\u5fae\u4fe1\u767b\u5f55\uff0c\u65e0\u6cd5\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8");
                }
                vo = this.wechatH5Order(order, userOpenId);
            } else if (request.getPayChannel().equals("mini")) {
                String userMiniOpenId = PayUtils.filterUserOpenId((String)this.getCurrentUser().getWx_union_id());
                this.logger.debug("userMiniOpenId={}", (Object)userMiniOpenId);
                if (StringUtils.isEmpty((String)userMiniOpenId)) {
                    return ResponseValue.error((String)"\u60a8\u8fd8\u672a\u6388\u6743\uff08\u7ed1\u5b9a\u5c0f\u7a0b\u5e8f\uff09\u5fae\u4fe1\u767b\u5f55\uff0c\u65e0\u6cd5\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8");
                }
                vo = this.wechatMiniOrder(order, userMiniOpenId);
            } else {
                throw new UnsupportedOperationException("\u8fd8\u672a\u5b9e\u73b0\u5fae\u4fe1\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f\uff1a" + request.getPayChannel());
            }
            response.setStatus(Boolean.valueOf(true));
            response.setJsConfig(vo);
            this.logger.debug("\u5fae\u4fe1\u9884\u4e0b\u5355\u6210\u529f");
        } else {
            if (request.getPayType().equals("alipay")) {
                throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u652f\u4ed8\u5b9d\u652f\u4ed8");
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u65b9\u5f0f\uff1a" + request.getPayType());
        }
        return ResponseValue.success((Object)response);
    }

    private boolean checkPayPass(String payPass, long userId) {
        EbUserConfig config = this.getUserRegConfigCache().get(userId);
        if (StringUtils.isEmpty((String)config.getPayPwd())) {
            throw new PlatformRuntimeException("\u7528\u6237\u5c1a\u672a\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801");
        }
        try {
            String originPassword = PlatformRSAUtils.getAesDecryptValue((String)payPass);
            if (this.matchesPassword(originPassword, config.getPayPwd())) {
                return true;
            }
            this.logger.error("\u652f\u4ed8\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0coriginPassword={}", (Object)originPassword);
            return false;
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("\u89e3\u6790\u652f\u4ed8\u5bc6\u7801\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    private WxPayJsResultVo wechatMiniOrder(EbOrder order, String userMiniOpenId) {
        String apiDomain = this.getArgumentVariable("api_url").getStringValue();
        String siteName = this.getArgumentVariable("site_name").getStringValue();
        String signKey = this.getArgumentVariable("pay_routine_key").getStringValue();
        String attach = "order," + order.getUid();
        double payPriceFen = order.getPayPrice() * 100.0;
        Order platformPayOrder = PayUtils.acquirePlatformOrderRoutineWechatV2((long)((long)payPriceFen), (long)order.getId(), (String)siteName, (String)attach, (String)"127.0.0.1", (String)(apiDomain + "/pay/notify/wx_v2/orderNotify"), (String)userMiniOpenId);
        return this.acquireWechatNormalPayResultVo(platformPayOrder, signKey);
    }

    private WxPayJsResultVo wechatH5Order(EbOrder order, String userOpenId) {
        String apiDomain = this.getArgumentVariable("api_url").getStringValue();
        String siteName = this.getArgumentVariable("site_name").getStringValue();
        String signKey = this.getArgumentVariable("pay_weixin_key").getStringValue();
        String attach = "order," + order.getUid();
        double payPriceFen = order.getPayPrice() * 100.0;
        Order platformPayOrder = PayUtils.acquirePlatformOrderH5WechatV2((long)((long)payPriceFen), (long)order.getId(), (String)siteName, (String)attach, (String)"127.0.0.1", (String)(apiDomain + "/pay/notify/wx_v2/orderNotify"), (String)userOpenId);
        return this.acquireWechatNormalPayResultVo(platformPayOrder, signKey);
    }

    private WxPayJsResultVo acquireWechatNormalPayResultVo(Order platformPayOrder, String signKey) {
        H5ResponsePay responsePay = null;
        try {
            responsePay = (H5ResponsePay)this.payEngineManager.generatePrepareOrder(platformPayOrder);
        }
        catch (OrderException e) {
            throw new PlatformRuntimeException("\u53d1\u8d77\u5fae\u4fe1\u9884\u8ba2\u5355\u9519\u8bef:" + e.getMessage() + ", orderId=" + e.getOrderId(), (Throwable)e);
        }
        if (!responsePay.getStatus()) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u652f\u4ed8H5\u8ba2\u5355\u8fd4\u56de\u9519\u8bef\uff1a" + responsePay.getMessage(), null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", responsePay.getAppId());
        map.put("nonceStr", responsePay.getAppId());
        map.put("package", "prepay_id=" + responsePay.getPrepayId());
        map.put("signType", "MD5");
        map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        WxPayJsResultVo vo = new WxPayJsResultVo();
        vo.setAppId(responsePay.getAppId());
        vo.setNonceStr(responsePay.getAppId());
        vo.setPackages("prepay_id=" + responsePay.getPrepayId());
        vo.setSignType("MD5");
        vo.setTimeStamp(String.valueOf(System.currentTimeMillis() / 1000L));
        vo.setMwebUrl(responsePay.getCodeUrl());
        try {
            vo.setPaySign(WechatUtils.getSign(map, signKey));
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("\u8bbe\u7f6e\u8fd4\u56de\u503c\u7b7e\u540d\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
        return vo;
    }

    @Deprecated
    private WechatOrderVo acquireWechatOrderVo(EbOrder order, String openid) throws Exception {
        WechatOrderVo vo = new WechatOrderVo();
        WebUserAgent webUserAgent = this.getCurrentWebUserAgent();
        String domain = this.getArgumentVariable("site_url").getStringValue();
        String siteName = this.getArgumentVariable("site_name").getStringValue();
        String apiDomain = this.getArgumentVariable("api_url").getStringValue();
        AttachVo attachVo = new AttachVo("order", order.getUid());
        vo.setAppid(this.getArgumentVariable("wechat_appid").getStringValue());
        vo.setMch_id(this.getArgumentVariable("pay_weixin_mchid").getStringValue());
        vo.setNonce_str(UUID.randomUUID().toString().replace("-", ""));
        vo.setSign_type("MD5");
        vo.setBody(siteName);
        vo.setAttach(JsonUtils.objectToJsonString((Object)attachVo));
        vo.setOut_trade_no(order.getOrderNo());
        double fenTotal = order.getPayPrice() * 100.0;
        vo.setTotal_fee((long)fenTotal);
        vo.setSpbill_create_ip(webUserAgent.getIp());
        vo.setNotify_url(apiDomain + "/pay/notify/wx_v2/orderNotify");
        switch (order.getPayChannel()) {
            case "h5": {
                vo.setTrade_type("MWEB");
                vo.setOpenid(null);
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                vo.setTrade_type("APP");
                vo.setOpenid(null);
                break;
            }
            default: {
                vo.setTrade_type("JSAPI");
                vo.setOpenid(openid);
            }
        }
        CreateOrderH5SceneInfoVo createOrderH5SceneInfoVo = new CreateOrderH5SceneInfoVo(new CreateOrderH5SceneInfoDetailVo(domain, siteName));
        vo.setScene_info(JsonUtils.objectToJsonString((Object)createOrderH5SceneInfoVo));
        String voJson = JsonUtils.objectToJsonString((Object)vo);
        String sign = WechatUtils.getSign(voJson, this.getArgumentVariable("pay_weixin_key").getStringValue());
        vo.setSign(sign);
        return vo;
    }

    @RequestMapping(value={"/get/config"}, method={RequestMethod.GET})
    public ResponseValue getPayConfig() {
        String payWxOpen = this.getArgumentVariable("pay_weixin_open").getStringValue();
        String yuePayStatus = this.getArgumentVariable("yue_pay_status").getStringValue();
        String aliPayStatus = this.getArgumentVariable("ali_pay_status").getStringValue();
        PayConfigResponse response = new PayConfigResponse();
        response.setYuePayStatus(Boolean.valueOf("'1'".equals(yuePayStatus)));
        response.setPayWechatOpen(Boolean.valueOf("'1'".equals(payWxOpen)));
        response.setAliPayStatus(Boolean.valueOf("'1'".equals(aliPayStatus)));
        if ("'1'".equals(yuePayStatus)) {
            EbUser user = this.getCurrentEbUser();
            response.setUserBalance(user.getNowMoney());
            EbUserConfig config = this.getUserRegConfigCache().get(user.getId().longValue());
            response.setPayPass(Boolean.valueOf(StringUtils.isNotEmpty((String)config.getPayPwd())));
        }
        return ResponseValue.success((Object)response);
    }
}

