/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.MerchantProductParam;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.vo.ProMerchantProductVo;
import com.ishop.model.vo.ProductCommonVo;
import com.ishop.model.vo.ProductDetailReplyVo;
import com.ishop.model.vo.ProductDetailVo;
import com.ishop.model.vo.ProductMerchantVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/product"})
public class ProductApi
extends BaseApi {
    @RequestMapping(value={"/merchant/pro/list"}, method={RequestMethod.GET})
    public ResponseValue getMerchantProList(MerchantProductParam param) {
        if (param == null || param.getMerId() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        String keyword = null;
        if (StringUtils.isNotEmpty((String)param.getKeyword())) {
            keyword = UrlUtils.decode((String)param.getKeyword());
        }
        GenericPager pager = this.getProductService().queryPageMerchantProductH5List(param.getMerId().intValue(), keyword, param.getCid(), param.getMaxPrice(), param.getMinPrice(), param.getSalesOrder(), param.getPriceOrder());
        this.logger.info(pager.toString());
        List productList = pager.getDatas();
        String cdnUrl = this.getCdnUrl();
        ArrayList<ProductCommonVo> data = new ArrayList<ProductCommonVo>();
        if (!StringUtils.isEmptyList((List)productList)) {
            for (EbProduct e : productList) {
                data.add(VoUtils.acquireProductCommonVo(e, cdnUrl));
            }
        }
        GenericPager commonVoGenericPager = ListPageContext.createGenericPager(data, (int)pager.getPageIndex(), (int)((int)pager.getTotalRows()));
        commonVoGenericPager.setPageSize(pager.getPageSize());
        return ResponseValue.success((Object)commonVoGenericPager);
    }

    @RequestMapping(value={"/reply/detail/{id}"}, method={RequestMethod.GET})
    public ResponseValue getProductReply(@PathVariable Long id) {
        if (id == null || id <= 0L) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        ProductDetailReplyVo vo = this.getProductReplyService().queryH5ProductReply(id.longValue());
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/reply/config/{id}"}, method={RequestMethod.GET})
    public ResponseValue getReplyCount(@PathVariable Long id) {
        return ResponseValue.success((Object)this.getProductReplyService().queryH5ReplyCount(id.longValue()));
    }

    @RequestMapping(value={"/detail/{id}"}, method={RequestMethod.GET})
    public ResponseValue detail(@PathVariable Long id, String type) {
        this.logger.debug("\u5546\u54c1\u8be6\u60c5\u53c2\u6570:id={},type={}", (Object)id, (Object)type);
        if (StringUtils.isEmpty((String)type) || type.equals("undefined")) {
            type = "normal";
        }
        if (!(type.equals("video") || type.equals("normal") || type.equals("seckill"))) {
            return ResponseValue.error((String)"\u5546\u54c1\u7c7b\u578b\u672a\u77e5");
        }
        if (type.equals("video")) {
            this.logger.info("\u5546\u54c1\u8be6\u60c5 --\u300b \u52a0\u8f7d\u89c6\u9891\u53f7\u5546\u54c1id={},", (Object)id);
            throw new UnsupportedOperationException("\u89c6\u9891\u53f7\u5546\u54c1\u672a\u5b9e\u73b0\u4ee3\u7801\uff01");
        }
        if (type.equals("seckill")) {
            throw new UnsupportedOperationException("\u79d2\u6740\u5546\u54c1\u672a\u5b9e\u73b0\u4ee3\u7801\uff01");
        }
        EbProduct product = this.getProductService().queryH5Detail(id.longValue());
        if (product == null) {
            return ResponseValue.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        ProductDetailVo detailVo = new ProductDetailVo();
        detailVo.setProductInfo(product);
        if (StringUtils.isNotEmpty((String)product.getGuaranteeIds())) {
            ArrayList<Integer> idList = new ArrayList<Integer>(4);
            for (String gid : StringUtils.commaDelimitedListToStringArray((String)product.getGuaranteeIds())) {
                idList.add(Integer.parseInt(gid));
            }
            detailVo.setGuaranteeList(this.getProductGuaranteeService().queryListByIds(idList));
        }
        String keyAttr = ProductAttrUtils.combineKey((int)ProductConstants.PRODUCT_TYPE_NORMAL, (long)id);
        List attrList = this.getProductAttrCache().getList(keyAttr);
        if (!StringUtils.isEmptyList((List)attrList)) {
            detailVo.setProductAttr(attrList);
        }
        LinkedHashMap<String, EbProductAttrValue> skuMap = new LinkedHashMap<String, EbProductAttrValue>();
        List productAttrValueList = this.getProductAttrValueService().queryProductAttrValueList(ProductConstants.PRODUCT_TYPE_NORMAL.intValue(), id.longValue());
        if (!StringUtils.isEmptyList((List)productAttrValueList)) {
            for (EbProductAttrValue atr : productAttrValueList) {
                skuMap.put(atr.getSku(), atr);
            }
            detailVo.setProductValue(skuMap);
        }
        EbMerchant merchant = this.getMerchantCache().get(product.getMerId().intValue());
        ProductMerchantVo productMerchantVo = VoUtils.acquireProductMerchantVo(merchant, this.getCdnUrl());
        productMerchantVo.setCollectNum(Integer.valueOf(0));
        List recommendList = this.getProductService().queryRecommendedProductsByMerId(product.getMerId().intValue(), 4);
        ArrayList<ProMerchantProductVo> data = new ArrayList<ProMerchantProductVo>();
        if (!StringUtils.isEmptyList((List)recommendList)) {
            for (EbProduct p : recommendList) {
                data.add(VoUtils.acquireProMerchantProductVo(p, this.getCdnUrl()));
            }
        }
        productMerchantVo.setProList(data);
        detailVo.setMerchantInfo(productMerchantVo);
        detailVo.setUserCollect(Boolean.valueOf(false));
        return ResponseValue.success((Object)detailVo);
    }
}

