/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.util.VerifyImgUtil;
import com.iplatform.core.BeanContextAware;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.vo.QrCodeVo;
import com.walker.infrastructure.utils.Base64;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/front/qrcode"})
public class QrcodeApi
extends BaseApi {
    @RequestMapping(value={"/get/wechat"}, method={RequestMethod.POST})
    public ResponseValue getWechatQrCode(@RequestBody Map<String, Object> data) {
        if (data == null || data.size() == 0) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u4e8c\u7ef4\u7801\u53c2\u6570");
        }
        StringBuilder scene = new StringBuilder();
        String page = "";
        try {
            for (Map.Entry<String, Object> m : data.entrySet()) {
                if (m.getKey().equals("path")) {
                    page = m.getValue().toString();
                    continue;
                }
                if (scene.length() > 0) {
                    scene.append(",");
                }
                scene.append(m.getValue());
            }
        }
        catch (PlatformRuntimeException ex) {
            this.logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u53c2\u6570\u9519\u8bef\uff1a" + data, (Throwable)ex);
            return ResponseValue.error((String)ex.getMessage());
        }
        QrCodeVo vo = new QrCodeVo();
        String imageBase64 = this.createQrCode(page, scene.length() > 0 ? scene.toString() : "");
        vo.setCode(imageBase64);
        return ResponseValue.success((Object)vo);
    }

    private String createQrCode(String page, String scene) {
        this.logger.debug("page = {}, scene = {}", (Object)page, (Object)scene);
        String miniAccessToken = this.acquireMiniAccessToken();
        String url = MessageFormat.format("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={0}", miniAccessToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scene", scene);
        map.put("path", page);
        map.put("width", 200);
        RestTemplate restTemplate = (RestTemplate)BeanContextAware.getBeanByType(RestTemplate.class);
        byte[] bytes = (byte[])restTemplate.postForEntity(url, map, byte[].class, new Object[0]).getBody();
        if (bytes == null || bytes.length == 0) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38(createQrCode)\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        String entity = new String(bytes);
        if (entity.indexOf("errcode") >= 0) {
            ObjectNode data = WechatUtils.acquireObjectNode(entity);
            if (data.get("errcode").asText().equals("40001")) {
                this.logger.warn("\u5c0f\u7a0b\u5e8f\u5df2\u83b7\u53d6accessToken\u5931\u6548\uff0c\u9700\u8981\u91cd\u65b0\u8c03\u7528\u63a5\u53e3\uff0cerror = {}", (Object)data);
                this.getWechatCache().removeMiniAccessToken();
                miniAccessToken = this.acquireMiniAccessToken();
                url = MessageFormat.format("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={0}", miniAccessToken);
                bytes = (byte[])restTemplate.postForEntity(url, map, byte[].class, new Object[0]).getBody();
                entity = new String(bytes);
                if (entity.indexOf("errcode") >= 0) {
                    this.logger.error("\u5fae\u4fe1\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u91cd\u8bd5\u5f02\u5e38:" + entity);
                } else {
                    return VerifyImgUtil.getBase64Image((String)new String(Base64.encodeBase64((byte[])bytes)));
                }
            }
            throw new PlatformRuntimeException("\u5fae\u4fe1\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38:" + entity);
        }
        try {
            return VerifyImgUtil.getBase64Image((String)new String(Base64.encodeBase64((byte[])bytes)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7801\u8f6c\u6362Base64\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/url/to/base64"}, method={RequestMethod.POST})
    public ResponseValue urlToBase64(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return ResponseValue.error((String)"url\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u6362");
        }
        this.logger.debug("...........url = " + (String)url);
        if (!StringUtils.isHttpLink((String)url)) {
            url = this.getCdnUrl() + (String)url;
        }
        return ResponseValue.success((Object)this.getQrcodeService().urlToBase64((String)url));
    }
}

