/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.Constants;
import com.ishop.merchant.util.PayUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.po.EbRechargeOrder;
import com.ishop.model.request.UserRechargeRequest;
import com.ishop.model.response.OrderPayResultResponse;
import com.ishop.model.response.RechargeItemResponse;
import com.ishop.model.response.RechargePackageResponse;
import com.ishop.model.vo.WxPayJsResultVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.pay.Order;
import com.walker.pay.PayEngineManager;
import com.walker.pay.exception.OrderException;
import com.walker.pay.wechat.v2.H5ResponsePay;
import com.walker.web.ResponseValue;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/recharge"})
public class RechargeApi
extends BaseApi {
    private PayEngineManager payEngineManager;

    @Autowired
    public RechargeApi(PayEngineManager payEngineManager) {
        this.payEngineManager = payEngineManager;
    }

    @RequestMapping(value={"/get/user/package"}, method={RequestMethod.GET})
    public ResponseValue acquireRechargePackage() {
        RechargePackageResponse userRechargeResponse = new RechargePackageResponse();
        List list = this.acquireGroupDataList(Constants.GROUP_DATA_ID_RECHARGE_PACKAGE, true, RechargeItemResponse.class, null);
        userRechargeResponse.setPackageList(list);
        String rechargeAttention = this.getArgumentVariable("recharge_attention").getStringValue();
        if (StringUtils.isNotEmpty((String)rechargeAttention)) {
            List attentionList = StringUtils.asList((String[])StringUtils.delimitedListToStringArray((String)rechargeAttention, (String)"\n"));
            userRechargeResponse.setNoticeList(attentionList);
        }
        return ResponseValue.success((Object)userRechargeResponse);
    }

    @RequestMapping(value={"/user/create"}, method={RequestMethod.POST})
    public ResponseValue userCreate(@RequestBody UserRechargeRequest request) {
        double rechargeMinAmount;
        if (request == null || request.getPrice() == null && request.getGroupDataId() == null) {
            return ResponseValue.error((String)"\u8bf7\u9009\u62e9\u5145\u503c\u5957\u9910\u6216\u586b\u5199\u81ea\u5b9a\u4e49\u5145\u503c\u91d1\u989d");
        }
        double rechargePrice = 0.0;
        double gainPrice = 0.0;
        if (request.getPrice() != null) {
            rechargePrice = request.getPrice();
            if (rechargePrice <= 0.0) {
                return ResponseValue.error((String)"\u5145\u503c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
        } else {
            RechargeItemResponse rechargePackage = (RechargeItemResponse)this.acquireGroupDataNormal(request.getGroupDataId(), RechargeItemResponse.class, null);
            if (rechargePackage == null) {
                return ResponseValue.error((String)"\u60a8\u9009\u62e9\u7684\u5145\u503c\u65b9\u5f0f\u5df2\u4e0b\u67b6");
            }
            rechargePrice = Double.parseDouble(rechargePackage.getPrice());
            gainPrice = Double.parseDouble(rechargePackage.getGiveMoney());
        }
        if (rechargePrice < (rechargeMinAmount = this.getArgumentVariable("store_user_min_recharge").getDoubleValue())) {
            return ResponseValue.error((String)"\u5145\u503c\u91d1\u989d\u5c0f\u4e8e\u6700\u4f4e\u5145\u503c\u91d1\u989d");
        }
        long userId = this.getCurrentUserId();
        String rechargeNo = "CZ" + System.currentTimeMillis() + StringUtils.generateRandomNumber((int)6);
        EbRechargeOrder rechargeOrder = new EbRechargeOrder(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        rechargeOrder.setOrderNo(rechargeNo);
        rechargeOrder.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        rechargeOrder.setUid(Long.valueOf(userId));
        rechargeOrder.setPrice(Double.valueOf(rechargePrice));
        rechargeOrder.setGivePrice(Double.valueOf(gainPrice));
        OrderPayResultResponse response = new OrderPayResultResponse();
        response.setOrderNo(rechargeNo);
        response.setPayType(request.getPayType());
        response.setPayChannel(request.getPayChannel());
        if (request.getPayType().equals("weixin")) {
            String userOpenId = this.getCurrentUser().getWx_open_id();
            if (StringUtils.isNotEmpty((String)userOpenId) && userOpenId.indexOf("\"") >= 0) {
                userOpenId = userOpenId.replaceAll("\"", "");
            }
            if (StringUtils.isEmpty((String)userOpenId)) {
                return ResponseValue.error((String)"\u60a8\u8fd8\u672a\u6388\u6743\uff08\u7ed1\u5b9a\uff09\u5fae\u4fe1\u767b\u5f55\uff0c\u65e0\u6cd5\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8");
            }
            WxPayJsResultVo vo = null;
            rechargeOrder.setOutTradeNo(PayUtils.acquirePayOutTradeNo((String)"weixin"));
            if (!request.getPayChannel().equals("public") && !request.getPayChannel().equals("h5")) {
                throw new UnsupportedOperationException("\u8fd8\u672a\u5b9e\u73b0\u5fae\u4fe1\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f\uff1a" + request.getPayChannel());
            }
            rechargeOrder.setPayType("weixin");
            rechargeOrder.setPayChannel(request.getPayChannel());
            vo = this.wechatH5Recharge(rechargeOrder, userOpenId);
            response.setStatus(Boolean.valueOf(true));
            response.setJsConfig(vo);
            this.logger.debug("\u5fae\u4fe1\uff08\u5145\u503c\uff09\u9884\u4e0b\u5355\u6210\u529f");
            this.getUserRechargeService().insert((BasePo)rechargeOrder);
        } else if (request.getPayType().equals("alipay")) {
            throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u652f\u4ed8\u5b9d\u5145\u503c\u4ee3\u7801");
        }
        return ResponseValue.success((Object)response);
    }

    private WxPayJsResultVo wechatH5Recharge(EbRechargeOrder order, String userOpenId) {
        String apiDomain = this.getArgumentVariable("api_url").getStringValue();
        String siteName = this.getArgumentVariable("site_name").getStringValue();
        String signKey = this.getArgumentVariable("pay_weixin_key").getStringValue();
        String attach = "recharge," + order.getUid();
        double payPriceFen = order.getPrice() * 100.0;
        Order platformPayOrder = PayUtils.acquirePlatformOrderH5WechatV2((long)((long)payPriceFen), (long)order.getId(), (String)siteName, (String)attach, (String)"127.0.0.1", (String)(apiDomain + "/pay/notify/wx_v2/orderNotify"), (String)userOpenId);
        H5ResponsePay responsePay = null;
        try {
            responsePay = (H5ResponsePay)this.payEngineManager.generatePrepareOrder(platformPayOrder);
        }
        catch (OrderException e) {
            throw new PlatformRuntimeException("\u53d1\u8d77\u5fae\u4fe1\u9884\u8ba2\u5355\uff08\u5145\u503c\uff09\u9519\u8bef:" + e.getMessage() + ", orderId=" + e.getOrderId(), (Throwable)e);
        }
        if (!responsePay.getStatus()) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u652f\u4ed8H5\u8ba2\u5355\uff08\u5145\u503c\uff09\u8fd4\u56de\u9519\u8bef\uff1a" + responsePay.getMessage(), null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", responsePay.getAppId());
        map.put("nonceStr", responsePay.getAppId());
        map.put("package", "prepay_id=" + responsePay.getPrepayId());
        map.put("signType", "MD5");
        map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        WxPayJsResultVo vo = new WxPayJsResultVo();
        vo.setAppId(responsePay.getAppId());
        vo.setNonceStr(responsePay.getAppId());
        vo.setPackages("prepay_id=" + responsePay.getPrepayId());
        vo.setSignType("MD5");
        vo.setTimeStamp(String.valueOf(System.currentTimeMillis() / 1000L));
        vo.setMwebUrl(responsePay.getCodeUrl());
        try {
            vo.setPaySign(WechatUtils.getSign(map, signKey));
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("\u8bbe\u7f6e\u8fd4\u56de\u503c\u7b7e\u540d\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
        return vo;
    }
}

