/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.UserClosingConfigVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/retail/store"})
public class RetailStoreApi
extends BaseApi {
    @RequestMapping(value={"/user/closing/config"}, method={RequestMethod.GET})
    public ResponseValue getClosingConfig() {
        EbUser user = this.getCurrentEbUser();
        String minPrice = this.getArgumentVariable("retail_store_extract_min_price").getStringValue();
        String freezeDay = this.getArgumentVariable("retail_store_brokerage_freezing_time").getStringValue();
        String bank = this.getArgumentVariable("retail_store_extract_bank").getStringValue();
        double brokerage = user.getBrokeragePrice();
        double freezeBrokerage = this.getUserBrokerageService().queryFreezePrice(user.getId().longValue());
        UserClosingConfigVo vo = new UserClosingConfigVo();
        vo.setMinPrice(minPrice);
        vo.setBrokerage(Double.valueOf(brokerage));
        vo.setFreezeBrokerage(Double.valueOf(freezeBrokerage));
        vo.setFreezeDay(freezeDay);
        if (StringUtils.isNotEmpty((String)bank)) {
            vo.setBankList(StringUtils.asList((String[])StringUtils.commaDelimitedListToStringArray((String)bank)));
        }
        return ResponseValue.success((Object)vo);
    }
}

