/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.iplatform.base.util.PlatformRSAUtils;
import com.iplatform.model.po.S_user_core;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.UserEditRequest;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbUser;
import com.ishop.model.request.PasswordRequest;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/user"})
public class UserApi
extends BaseApi {
    @RequestMapping(value={"/register/reset"}, method={RequestMethod.POST})
    public ResponseValue editPassword(@RequestBody PasswordRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getCaptcha()) || StringUtils.isEmpty((String)request.getPassword())) {
            return ResponseValue.error((String)"\u65b0\u5bc6\u7801\u6216\u9a8c\u8bc1\u7801\u5fc5\u987b\u8f93\u5165");
        }
        if (StringUtils.isEmpty((String)request.getUuid())) {
            return ResponseValue.error((String)"\u9a8c\u8bc1\u7801\u6807\u8bc6\u4e0d\u5b58\u5728(uuid)");
        }
        boolean smsCodeSuccess = this.validateSmsCode(request.getCaptcha(), request.getUuid());
        if (!smsCodeSuccess) {
            return ResponseValue.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        long userId = this.getCurrentUserId();
        String originPassword = PlatformRSAUtils.getAesDecryptValue((String)request.getPassword());
        this.logger.debug("\u7528\u6237:{},\u539f\u59cb\u5bc6\u7801\uff1a{}", (Object)userId, (Object)originPassword);
        String encryptPass = this.encryptPassword(originPassword);
        S_user_core userCore = new S_user_core(Long.valueOf(userId));
        userCore.setPassword(encryptPass);
        this.getUserService().update((BasePo)userCore);
        userCore = this.getUserCacheProvider().getUser(userId);
        userCore.setPassword(encryptPass);
        return ResponseValue.success((Object)true);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue getUserInfo() {
        EbUser user = this.getUserRegCache().get(this.getCurrentUserId());
        return ResponseValue.success((Object)VoUtils.acquireUserInfoVo(user, this.getCdnUrl()));
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public ResponseValue edit(@RequestBody UserEditRequest userEditRequest) {
        if (userEditRequest == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.debug(userEditRequest.toString());
        if (StringUtils.isEmpty((String)userEditRequest.getNickname()) || StringUtils.isEmpty((String)userEditRequest.getProvince()) || StringUtils.isEmpty((String)userEditRequest.getCity()) || userEditRequest.getSex() == null) {
            return ResponseValue.error((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u4e2a\u4eba\u4fe1\u606f");
        }
        long userId = this.getCurrentUserId();
        EbUser ebUser = new EbUser(Long.valueOf(userId));
        ebUser.setNickname(userEditRequest.getNickname());
        ebUser.setRealName(userEditRequest.getName());
        ebUser.setSex(userEditRequest.getSex());
        ebUser.setBirthday(userEditRequest.getBirthday());
        ebUser.setProvince(userEditRequest.getProvince());
        ebUser.setCity(userEditRequest.getCity());
        S_user_core userCore = new S_user_core(Long.valueOf(userId));
        userCore.setNick_name(userEditRequest.getNickname());
        userCore.setSex(userEditRequest.getSex() == 1 ? "0" : "1");
        if (StringUtils.isNotEmpty((String)userEditRequest.getAvatar())) {
            String avatar = this.clearCdnPrefix(userEditRequest.getAvatar());
            ebUser.setAvatar(avatar);
            userCore.setAvatar(avatar);
        }
        this.getUserRegisterService().execUpdateUserEdit(ebUser, userCore);
        this.getUserCacheProvider().updateUser((S_user_core)this.getUserRegisterService().get((BasePo)userCore));
        this.getUserRegCache().update((EbUser)this.getUserRegisterService().get((BasePo)ebUser));
        return ResponseValue.success();
    }
}

