/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.vo.OrderCenterNumVo;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbLevel;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserBalanceRecord;
import com.ishop.model.vo.MyAccountVo;
import com.ishop.model.vo.MyPromotionVo;
import com.ishop.model.vo.UserBalanceMontyVo;
import com.ishop.model.vo.UserCenterVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/user/center"})
public class UserCenterApi
extends BaseApi {
    @RequestMapping(value={"/my/promotion"}, method={RequestMethod.GET})
    public ResponseValue getMyPromotion() {
        EbUser user = this.getCurrentEbUser();
        double freezeBrokerage = this.getUserBrokerageService().queryFreezePrice(user.getId().longValue());
        double settledCommissionPrice = this.getUserBrokerageService().querySettledCommission(user.getId().longValue());
        MyPromotionVo vo = new MyPromotionVo();
        vo.setFreezePrice(Double.valueOf(freezeBrokerage));
        vo.setSettledCommissionPrice(Double.valueOf(settledCommissionPrice));
        vo.setBrokeragePrice(user.getBrokeragePrice());
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/order/num"}, method={RequestMethod.GET})
    public ResponseValue getUserCenterOrderNum() {
        OrderCenterNumVo vo = new OrderCenterNumVo();
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue getUserCenterInfo() {
        EbLevel level;
        String cdnUrl = this.getCdnUrl();
        UserCenterVo userCenterVo = new UserCenterVo();
        userCenterVo.setCenterBanner(this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_USER_CENTER_BANNER, cdnUrl));
        userCenterVo.setCenterMenu(this.acquireGroupDataConfigList(Constants.GROUP_DATA_ID_USER_CENTER_MENU, null));
        long userId = this.getCurrentUserId();
        EbUser ebUser = this.getUserRegCache().get(userId);
        if (ebUser == null) {
            throw new PlatformRuntimeException("\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        VoUtils.copyUserCenterInfo(ebUser, userCenterVo, cdnUrl);
        userCenterVo.setPhone(ebUser.getPhone());
        S_user_core userCore = this.getCurrentUser();
        if (userCore.getType() > 0) {
            List roleIdList = ((UserServiceImpl)BeanContextAware.getBeanByType(UserServiceImpl.class)).queryUserRoleIdList(userId);
            userCenterVo.setRoleIds(StringUtils.collectionToCommaDelimitedString((Collection)roleIdList));
            this.logger.debug("\u79fb\u52a8\u7aef\u52a0\u8f7d\u4e86\u7528\u6237\u89d2\u8272\uff0c\u5546\u6237\u7ba1\u7406\u5458\u7c7b\u578b\uff1a{}", (Object)userCore.getType());
        } else {
            userCenterVo.setRoleIds("");
        }
        int collectionCount = this.getProductRelationService().queryProductCollectionCount(userId);
        userCenterVo.setCollectCount(Integer.valueOf(collectionCount));
        int couponUserCount = this.getCouponUserService().queryUserCouponCount(userId);
        userCenterVo.setCouponCount(Integer.valueOf(couponUserCount));
        int browseRecordCount = this.getUserCenterService().queryUserBrowseRecordCount(userId);
        userCenterVo.setBrowseNum(Integer.valueOf(browseRecordCount));
        userCenterVo.setIsVip(Boolean.valueOf(false));
        if (userCenterVo.getLevel() > 0 && (level = this.getLevelCache().get(ebUser.getLevel().intValue())) != null) {
            userCenterVo.setIsVip(Boolean.valueOf(true));
            userCenterVo.setVipIcon(this.getCdnUrl() + level.getIcon());
            userCenterVo.setVipName(level.getName());
        }
        userCenterVo.setIsPromoter(Boolean.valueOf(false));
        String retailStoreSwitch = this.getArgumentVariable("retail_store_switch").getStringValue();
        if (retailStoreSwitch.equals("1") && ebUser.getIsPromoter() == 1) {
            userCenterVo.setIsPromoter(Boolean.valueOf(true));
        }
        return ResponseValue.success((Object)userCenterVo);
    }

    @RequestMapping(value={"/my/account"}, method={RequestMethod.GET})
    public ResponseValue myAccount() {
        EbUser user = this.getCurrentEbUser();
        if (user == null) {
            return ResponseValue.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        double totalMonetary = this.getUserBalanceService().queryTotalMonetaryRecord(user.getId().longValue());
        double totalRecharge = this.getUserBalanceService().queryTotalRechargeRecord(user.getId().longValue());
        String rechargeSwitch = this.getArgumentVariable("recharge_switch").getStringValue();
        MyAccountVo vo = new MyAccountVo();
        vo.setNowMoney(user.getNowMoney());
        vo.setMonetary(Double.valueOf(totalMonetary));
        vo.setRecharge(Double.valueOf(totalRecharge));
        if (StringUtils.isNotEmpty((String)rechargeSwitch) && rechargeSwitch.equals("'1'")) {
            vo.setRechargeSwitch(Boolean.valueOf(true));
        }
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/balance/list"}, method={RequestMethod.GET})
    public ResponseValue userBalanceRecord(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return ResponseValue.error((String)"\u8bb0\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GenericPager pager = this.getUserBalanceService().queryPageBalanceList(type, this.getCurrentUserId());
        List data = pager.getDatas();
        ArrayList<UserBalanceMontyVo> monthVoList = new ArrayList<UserBalanceMontyVo>(8);
        HashMap<Integer, UserBalanceMontyVo> monthCache = new HashMap<Integer, UserBalanceMontyVo>(4);
        if (!StringUtils.isEmptyList((List)data)) {
            UserBalanceMontyVo vo = null;
            for (EbUserBalanceRecord record : data) {
                vo = (UserBalanceMontyVo)monthCache.get(record.getMonth());
                if (vo == null) {
                    vo = new UserBalanceMontyVo();
                    monthCache.put(record.getMonth(), vo);
                }
                vo.addRecord(record);
            }
            for (UserBalanceMontyVo montyVo : monthCache.values()) {
                monthVoList.add(montyVo);
            }
        }
        GenericPager resultPager = ListPageContext.createGenericPager(monthVoList, (int)pager.getPageIndex(), (int)pager.getPageSize(), (int)((int)pager.getTotalRows()));
        return ResponseValue.success((Object)resultPager);
    }
}

