/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.util.RestTemplateUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.response.WeChatJsSdkConfigResponse;
import com.ishop.model.response.WechatPublicShareResponse;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.web.ResponseValue;
import java.text.MessageFormat;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/front/wechat"})
public class WechatApi
extends BaseApi {
    private RestTemplate restTemplate;
    @Value(value="${ishop.wechat-js-api-debug}")
    private boolean wechatJsApiDebug = false;

    @Autowired
    public WechatApi(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @RequestMapping(value={"/get/public/share"}, method={RequestMethod.GET})
    public ResponseValue getPublicShare() {
        WechatPublicShareResponse response = new WechatPublicShareResponse();
        response.setImage(this.getArgumentVariable("wechat_share_img").getStringValue());
        response.setTitle(this.getArgumentVariable("wechat_share_title").getStringValue());
        response.setSynopsis(this.getArgumentVariable("wechat_share_synopsis").getStringValue());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/get/public/js/config"}, method={RequestMethod.GET})
    public ResponseValue getPublicJsConfig(String url) {
        this.logger.debug(url);
        url = UrlUtils.decode((String)url);
        this.logger.debug("decode_url = {}", (Object)url);
        String appId = this.getArgumentVariable("wechat_appid").getStringValue();
        if (StringUtils.isEmpty((String)appId)) {
            return ResponseValue.error((String)"\u8bf7\u5148\u914d\u7f6e\u5fae\u4fe1\u53c2\u6570");
        }
        String ticket = this.getWechatCache().getJsApiTicket();
        if (StringUtils.isEmpty((String)ticket)) {
            this.logger.debug("\u7f13\u5b58\u672a\u627e\u5230\u5fae\u4fe1'ticket',\u91cd\u65b0\u8c03\u7528\u67e5\u8be2");
            String accessToken = this.acquirePublicAccessToken();
            String ticketUrl = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={0}&type=jsapi", accessToken);
            ObjectNode objectNode = RestTemplateUtils.getData((String)ticketUrl, (RestTemplate)this.restTemplate);
            if (objectNode == null) {
                throw new PlatformRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
            }
            this.logger.debug(objectNode.toString());
            try {
                if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0") && objectNode.has("errmsg")) {
                    throw new PlatformRuntimeException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + objectNode.get("errcode") + objectNode.get("errmsg"));
                }
                ticket = objectNode.get("ticket").asText();
                this.getWechatCache().putJsApiTicket(ticket);
                this.logger.info("\u8c03\u7528\u4e00\u6b21\u5fae\u4fe1\u8fdc\u7a0b\u63a5\u53e3\u83b7\u53d6'ticket'\uff0c\u5e76\u7f13\u5b58\uff1a{}", (Object)ticket);
            }
            catch (Exception ex) {
                throw new RuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + objectNode, ex);
            }
        }
        WeChatJsSdkConfigResponse response = new WeChatJsSdkConfigResponse();
        response.setUrl(url);
        response.setAppId(appId);
        response.setNonceStr(UUID.randomUUID().toString().replace("-", ""));
        response.setTimestamp(Long.valueOf(System.currentTimeMillis() / 1000L));
        String signature = WechatUtils.getJsSdkSign(response.getNonceStr(), ticket, String.valueOf(response.getTimestamp()), url);
        response.setSignature(signature);
        String[] apiArray = StringUtils.commaDelimitedListToStringArray((String)"editAddress,openAddress,updateTimelineShareData,updateAppMessageShareData,onMenuShareTimeline,onMenuShareAppMessage,onMenuShareQQ,onMenuShareWeibo,onMenuShareQZone,startRecord,stopRecord,onVoiceRecordEnd,playVoice,pauseVoice,stopVoice,onVoicePlayEnd,uploadVoice,downloadVoice,chooseImage,previewImage,uploadImage,downloadImage,translateVoice,getNetworkType,openLocation,getLocation,hideOptionMenu,showOptionMenu,hideMenuItems,showMenuItems,hideAllNonBaseMenuItem,showAllNonBaseMenuItem,closeWindow,scanQRCode,chooseWXPay,openProductSpecificView,addCard,chooseCard,openCard");
        response.setJsApiList(StringUtils.asList((String[])apiArray));
        response.setDebug(Boolean.valueOf(this.wechatJsApiDebug));
        this.logger.info("response = {}, ticket = {}", (Object)response, (Object)ticket);
        return ResponseValue.success((Object)response);
    }
}

