/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.service;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.service.CouponUserServiceImpl;
import com.ishop.merchant.service.ProductAttrValueServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.model.MyRecord;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontOrderServiceImpl
extends BaseServiceImpl {
    private ProductServiceImpl productService;
    private ProductAttrValueServiceImpl productAttrValueService;
    private UserRegisterServiceImpl userRegisterService;
    private CouponUserServiceImpl couponUserService;

    @Autowired
    public FrontOrderServiceImpl(ProductServiceImpl productService, ProductAttrValueServiceImpl productAttrValueService, UserRegisterServiceImpl userRegisterService, CouponUserServiceImpl couponUserService) {
        this.productService = productService;
        this.productAttrValueService = productAttrValueService;
        this.userRegisterService = userRegisterService;
        this.couponUserService = couponUserService;
    }

    public void execCreateOrder(int orderType, List<MyRecord> skuRecordList, String preOrderNo, EbOrder order, List<EbMerchantOrder> merchantOrderList, List<EbOrderDetail> orderDetailList, List<Long> couponIdList, List<Long> cartIdList) {
        this.log.debug("\u5f00\u59cb\u6263\u4ef6\u5546\u54c1\u5e93\u5b58 --> \u666e\u901a\u5546\u54c1:{}", (Object)skuRecordList.size());
        int count = 0;
        if (orderType == OrderConstants.ORDER_TYPE_NORMAL) {
            for (MyRecord skuRecord : skuRecordList) {
                count = this.productService.execOperateStock(skuRecord.getLong("productId").longValue(), skuRecord.getInt("num"), "sub");
                if (count <= 0) {
                    throw new PlatformRuntimeException("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a" + preOrderNo + ", \u5546\u54c1ID\uff1a" + skuRecord.getLong("productId"));
                }
                count = this.productAttrValueService.execOperateStock(skuRecord.getInt("attrValueId"), skuRecord.getInt("num"), "sub", ProductConstants.PRODUCT_TYPE_NORMAL, skuRecord.getInt("attrValueVersion"));
                if (count > 0) continue;
                throw new PlatformRuntimeException("\u66f4\u65b0\u5546\u54c1attrValue\u5931\u8d25\uff0cattrValueId = " + skuRecord.getInt("attrValueId"));
            }
        } else if (orderType == OrderConstants.ORDER_TYPE_VIDEO) {
            this.log.warn("\u89c6\u9891\u53f7\u8ba2\u5355\uff0c\u672a\u5b9e\u73b0\u8ba2\u5355\u521b\u5efa");
        } else if (orderType == OrderConstants.ORDER_TYPE_SECKILL) {
            this.log.warn("\u79d2\u6740\u8ba2\u5355\uff0c\u672a\u5b9e\u73b0\u8ba2\u5355\u521b\u5efa");
        }
        if (merchantOrderList.size() == 1) {
            order.setMerId(merchantOrderList.get(0).getMerId());
        }
        this.insert((BasePo)order);
        this.insertBatch(merchantOrderList);
        this.insertBatch(orderDetailList);
        if (order.getUseIntegral() > 0 && (count = this.userRegisterService.execUpdateIntegral(order.getUid().longValue(), order.getUseIntegral().intValue(), "sub")) <= 0) {
            throw new PlatformRuntimeException("\u751f\u6210\u8ba2\u5355\u6263\u9664\u7528\u6237\u79ef\u5206\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a" + preOrderNo);
        }
        if (!StringUtils.isEmptyList(couponIdList)) {
            this.couponUserService.execUpdateUseCoupons(couponIdList);
        }
        if (!StringUtils.isEmptyList(cartIdList)) {
            HashMap<String, List<Long>> param = new HashMap<String, List<Long>>(2);
            param.put("ids", cartIdList);
            this.execute("delete from eb_cart where id in (:ids)", param);
        }
    }
}

