/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.support;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformRuntimeException;
import com.ishop.mobile.util.WechatUtils;
import com.ishop.model.vo.WechatMiniAuthorizeVo;
import com.ishop.model.wechat.WeChatAuthorizeLoginUserInfoVo;
import com.ishop.model.wechat.WeChatOauthToken;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class WechatEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String wechatMiniSecret;
    private String wechatMiniAppId;
    private RestTemplate restTemplate;
    private String wechatPublicSecret;
    private String wechatPublicAppId;
    private ArgumentsManager argumentsManager;

    public WechatMiniAuthorizeVo getMiniAuthCode(String code) {
        if (StringUtils.isEmpty((String)this.wechatMiniAppId)) {
            throw new PlatformRuntimeException("wechatMiniAppId\u672a\u8bbe\u7f6e");
        }
        if (StringUtils.isEmpty((String)this.wechatMiniSecret)) {
            throw new PlatformRuntimeException("wechatMiniSecret\u672a\u8bbe\u7f6e");
        }
        String url = MessageFormat.format("https://api.weixin.qq.com/sns/jscode2session?appid={0}&secret={1}&js_code={2}&grant_type=authorization_code", this.wechatMiniAppId, this.wechatMiniSecret, code);
        String entity = (String)this.restTemplate.getForObject(url, String.class, new HashMap(2));
        if (StringUtils.isEmpty((String)entity)) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01https://api.weixin.qq.com/sns/jscode2session?appid={0}&secret={1}&js_code={2}&grant_type=authorization_code");
        }
        WechatMiniAuthorizeVo wechatMiniAuthorizeVo = null;
        ObjectNode objectNode = WechatUtils.acquireObjectNode(entity);
        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0") && objectNode.has("errmsg")) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + objectNode.get("errcode") + objectNode.get("errmsg"));
        }
        try {
            wechatMiniAuthorizeVo = (WechatMiniAuthorizeVo)JsonUtils.jsonStringToObject((String)entity, WechatMiniAuthorizeVo.class);
            this.logger.info("\u8c03\u7528\u4e00\u6b21\u5fae\u4fe1\u8fdc\u7a0b\u63a5\u53e3\u83b7\u53d6'jscode2session'={}", (Object)wechatMiniAuthorizeVo);
            return wechatMiniAuthorizeVo;
        }
        catch (Exception ex) {
            throw new RuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + objectNode, ex);
        }
    }

    public WeChatAuthorizeLoginUserInfoVo getSnsUserInfo(String accessToken, String openid) {
        String url = MessageFormat.format("https://api.weixin.qq.com/sns/userinfo?access_token={0}&openid={1}&lang={2}", accessToken, openid, "zh_CN");
        String entity = (String)this.restTemplate.getForObject(url, String.class, new HashMap(2));
        if (StringUtils.isEmpty((String)entity)) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        WeChatAuthorizeLoginUserInfoVo loginUserInfoVo = null;
        ObjectNode objectNode = WechatUtils.acquireObjectNode(entity);
        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0") && objectNode.has("errmsg")) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + objectNode.get("errcode") + objectNode.get("errmsg"));
        }
        try {
            loginUserInfoVo = (WeChatAuthorizeLoginUserInfoVo)JsonUtils.jsonStringToObject((String)entity, WeChatAuthorizeLoginUserInfoVo.class);
            this.logger.info("\u8c03\u7528\u4e00\u6b21\u5fae\u4fe1\u8fdc\u7a0b\u63a5\u53e3\u83b7\u53d6'sns_userInfo'={}", (Object)loginUserInfoVo);
            return loginUserInfoVo;
        }
        catch (Exception ex) {
            throw new RuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + objectNode, ex);
        }
    }

    public WeChatOauthToken getOauth2AccessToken(String code) {
        String entity;
        if (StringUtils.isEmpty((String)this.wechatPublicAppId)) {
            throw new PlatformRuntimeException("wechatPublicAppId\u672a\u8bbe\u7f6e");
        }
        if (StringUtils.isEmpty((String)this.wechatPublicSecret)) {
            throw new PlatformRuntimeException("wechatAppSecret\u672a\u8bbe\u7f6e");
        }
        String url = WechatUtils.getWechatOauthAccessTokenUrl(this.wechatPublicAppId, this.wechatPublicSecret, code);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(url);
        }
        if (StringUtils.isEmpty((String)(entity = (String)this.restTemplate.getForObject(url, String.class, new HashMap(2))))) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        WeChatOauthToken weChatOauthToken = null;
        ObjectNode objectNode = WechatUtils.acquireObjectNode(entity);
        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0") && objectNode.has("errmsg")) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + objectNode.get("errcode") + objectNode.get("errmsg"));
        }
        try {
            weChatOauthToken = (WeChatOauthToken)JsonUtils.jsonStringToObject((String)entity, WeChatOauthToken.class);
            this.logger.info("\u8c03\u7528\u4e00\u6b21\u5fae\u4fe1\u8fdc\u7a0b\u63a5\u53e3\u83b7\u53d6'access_token'=", (Object)weChatOauthToken);
            return weChatOauthToken;
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + objectNode, (Throwable)ex);
        }
    }

    public void setArgumentsManager(ArgumentsManager argumentsManager) {
        this.argumentsManager = argumentsManager;
    }

    public void setWechatPublicSecret(String wechatPublicSecret) {
        this.wechatPublicSecret = wechatPublicSecret;
    }

    public void setWechatPublicAppId(String wechatPublicAppId) {
        this.wechatPublicAppId = wechatPublicAppId;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getWechatMiniSecret() {
        return this.wechatMiniSecret;
    }

    public void setWechatMiniSecret(String wechatMiniSecret) {
        this.wechatMiniSecret = wechatMiniSecret;
    }

    public String getWechatMiniAppId() {
        return this.wechatMiniAppId;
    }

    public void setWechatMiniAppId(String wechatMiniAppId) {
        this.wechatMiniAppId = wechatMiniAppId;
    }
}

