/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.util;

import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.ishop.merchant.Constants;
import com.ishop.mobile.pojo.LoginParam;
import com.ishop.model.po.EbUser;
import com.ishop.model.vo.LoginInfoVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.UserPrincipal;
import java.util.Map;

public class LoginUtils {
    public static final void setupBindType(S_user_core userCore, String bindType) {
        if (StringUtils.isNotEmpty((String)bindType)) {
            switch (bindType) {
                case "wechat": {
                    userCore.setIs_wechat_public(Integer.valueOf(1));
                    break;
                }
                case "routine": {
                    userCore.setIs_wechat_routine(Integer.valueOf(1));
                    break;
                }
                case "iosWx": {
                    userCore.setIs_wechat_ios(Integer.valueOf(1));
                    break;
                }
                case "androidWx": {
                    userCore.setIs_wechat_android(Integer.valueOf(1));
                }
            }
        }
    }

    public static final int getUserTokenType(String type) {
        Integer userTokenType = 0;
        switch (type) {
            case "wechat": {
                userTokenType = Constants.USER_TOKEN_TYPE_WECHAT;
                break;
            }
            case "routine": {
                userTokenType = Constants.USER_TOKEN_TYPE_ROUTINE;
                break;
            }
            case "iosWx": {
                userTokenType = Constants.USER_TOKEN_TYPE_IOS_WX;
                break;
            }
            case "androidWx": {
                userTokenType = Constants.USER_TOKEN_TYPE_ANDROID_WX;
            }
        }
        return userTokenType;
    }

    public static final LoginInfoVo acquireLoginInfoVo(Map<String, Object> data) {
        UserPrincipal userPrincipal = (UserPrincipal)data.get("userInfoApp");
        LoginInfoVo vo = new LoginInfoVo();
        vo.setToken(data.get("token").toString());
        vo.setId(((S_user_core)userPrincipal.getUserInfo()).getId());
        vo.setPhone(((S_user_core)userPrincipal.getUserInfo()).getPhonenumber());
        vo.setNikeName(((S_user_core)userPrincipal.getUserInfo()).getNick_name());
        vo.setType("login");
        return vo;
    }

    public static final EbUser acquireMobileRegisterEbUser(String phone, S_user_core userCore, String avatar) {
        EbUser ebUser = new EbUser();
        ebUser.setAccount(phone);
        ebUser.setPwd(userCore.getPassword());
        ebUser.setPhone(phone);
        ebUser.setNickname(userCore.getNick_name());
        ebUser.setSex(Integer.valueOf(0));
        ebUser.setRegisterType(userCore.getRegister_type());
        ebUser.setAddress("");
        ebUser.setAvatar(avatar);
        ebUser.setLastLoginTime(userCore.getCreate_time());
        ebUser.setCreateTime(userCore.getCreate_time());
        ebUser.setUpdateTime(userCore.getCreate_time());
        ebUser.setIsWechatRoutine(userCore.getIs_wechat_routine());
        ebUser.setIsWechatPublic(userCore.getIs_wechat_public());
        ebUser.setIsWechatAndroid(userCore.getIs_wechat_android());
        ebUser.setIsWechatIos(userCore.getIs_wechat_ios());
        ebUser.setLevel(Integer.valueOf(0));
        ebUser.setSignNum(Integer.valueOf(0));
        ebUser.setCountry("CN");
        ebUser.setIntegral(Integer.valueOf(0));
        ebUser.setExperience(Integer.valueOf(0));
        ebUser.setNowMoney(Double.valueOf(0.0));
        ebUser.setPayCount(Integer.valueOf(0));
        ebUser.setStatus(Integer.valueOf(1));
        ebUser.setIsLogoff(Integer.valueOf(0));
        ebUser.setIsBindingIos(Integer.valueOf(0));
        ebUser.setBrokeragePrice(Double.valueOf(0.0));
        ebUser.setIsPromoter(Integer.valueOf(0));
        ebUser.setSpreadUid(Long.valueOf(0L));
        ebUser.setSpreadCount(Integer.valueOf(0));
        return ebUser;
    }

    public static final S_user_core acquireMobileRegisterUserCore(String phone, String defaultPassEncrypt, String avatar) {
        S_user_core userCore = new S_user_core();
        userCore.setUser_name(phone);
        userCore.setPhonenumber(phone);
        userCore.setNick_name("\u7528\u6237_" + StringUtils.generateRandomNumber((int)6));
        userCore.setOrg_id(Long.valueOf(0L));
        userCore.setDept_id(Long.valueOf(0L));
        userCore.setUser_type(Integer.valueOf(99));
        userCore.setPassword(defaultPassEncrypt);
        userCore.setSex("0");
        userCore.setType(Integer.valueOf(0));
        userCore.setRegister_type("h5");
        userCore.setBind_mobile(Integer.valueOf(1));
        userCore.setCreate_by("register");
        userCore.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        userCore.setUpdate_time(userCore.getCreate_time());
        userCore.setAvatar(avatar);
        userCore.setIs_wechat_public(Integer.valueOf(0));
        userCore.setIs_wechat_routine(Integer.valueOf(0));
        userCore.setIs_wechat_ios(Integer.valueOf(0));
        userCore.setIs_wechat_android(Integer.valueOf(0));
        userCore.setModify_pwd(Integer.valueOf(0));
        userCore.setBind_wechat(Integer.valueOf(0));
        userCore.setBind_mail(Integer.valueOf(0));
        userCore.setProfile_id(Long.valueOf(0L));
        userCore.setIs_sms(Integer.valueOf(1));
        userCore.setStatus(Integer.valueOf(0));
        userCore.setMer_id(Long.valueOf(0L));
        userCore.setDel_flag(Integer.valueOf(0));
        userCore.setIs_logoff(Integer.valueOf(0));
        userCore.setLogin_date(userCore.getCreate_time());
        userCore.setLogoff_time(Long.valueOf(0L));
        return userCore;
    }

    public static final RequestLogin acquireRequestLoginByWechatPublic(String loginId, String encryptPass) {
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUuid("");
        requestLogin.setLoginType("wechat");
        requestLogin.setClientType("mobile");
        requestLogin.setUsername(loginId);
        requestLogin.setPassword(encryptPass);
        requestLogin.setCode("");
        requestLogin.setVerifyType("none");
        return requestLogin;
    }

    public static final RequestLogin acquireRequestLoginByCaptcha(LoginParam param) {
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUuid(param.getUuid());
        requestLogin.setLoginType("sms_code");
        requestLogin.setClientType("mobile");
        requestLogin.setUsername(param.getPhone());
        requestLogin.setPassword(param.getCaptcha());
        requestLogin.setCode(param.getCaptcha());
        requestLogin.setVerifyType("sms");
        return requestLogin;
    }

    public static final RequestLogin acquireRequestLoginByPassword(LoginParam param) {
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUuid(param.getUuid());
        requestLogin.setLoginType("mobile_pass");
        requestLogin.setClientType("mobile");
        requestLogin.setUsername(param.getPhone());
        requestLogin.setPassword(param.getPassword());
        requestLogin.setCode(param.getCaptcha());
        requestLogin.setVerifyType("none");
        return requestLogin;
    }
}

