/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.util;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.core.BeanContextAware;
import com.ishop.merchant.MerchantCache;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.service.ProductAttrValueServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.mobile.pojo.PreOrderDetailRequest;
import com.ishop.mobile.pojo.PreOrderRequest;
import com.ishop.mobile.service.CartServiceImpl;
import com.ishop.model.po.EbCart;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.po.EbUserAddress;
import com.ishop.model.request.OrderMerchantRequest;
import com.ishop.model.vo.PreMerchantOrderVo;
import com.ishop.model.vo.PreOrderDetailVo;
import com.ishop.model.vo.PreOrderVo;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderUtils {
    private static final Logger logger = LoggerFactory.getLogger(OrderUtils.class);

    public static final String generateOrderNo(String prefix) {
        return prefix + NumberGenerator.getLongSequenceNumber() + StringUtils.generateRandomNumber((int)4);
    }

    public static final Object[] acquireMerchantOrderList(List<Long> couponIdList, List<PreMerchantOrderVo> merchantOrderVoList, List<OrderMerchantRequest> orderMerchantRequestList, String orderNo, int orderType, long userId, long createTime, EbUserAddress userAddress, boolean autoShippingDone) {
        Object[] result = new Object[2];
        ArrayList<EbMerchantOrder> merchantOrderList = new ArrayList<EbMerchantOrder>(4);
        ArrayList<EbOrderDetail> orderDetailList = new ArrayList<EbOrderDetail>(4);
        for (PreMerchantOrderVo merchantOrderVo : merchantOrderVoList) {
            EbMerchantOrder merchantOrder = new EbMerchantOrder();
            merchantOrder.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
            merchantOrder.setCreateTime(Long.valueOf(createTime));
            merchantOrder.setOrderNo(orderNo);
            merchantOrder.setMerId(merchantOrderVo.getMerId());
            merchantOrder.setUid(Long.valueOf(userId));
            for (OrderMerchantRequest om : orderMerchantRequestList) {
                if (!om.getMerId().equals(merchantOrderVo.getMerId())) continue;
                if (StringUtils.isNotEmpty((String)om.getRemark())) {
                    merchantOrder.setUserRemark(om.getRemark());
                }
                merchantOrder.setShippingType(om.getShippingType());
                break;
            }
            if (merchantOrder.getShippingType().intValue() == OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP.intValue()) {
                merchantOrder.setUserAddress(merchantOrderVo.getMerName());
                merchantOrder.setVerifyCode(StringUtils.generateRandomNumber((int)6));
            } else if (!autoShippingDone) {
                merchantOrder.setRealName(userAddress.getRealName());
                merchantOrder.setUserPhone(userAddress.getPhone());
                String userAddressStr = userAddress.getProvince() + userAddress.getCity() + userAddress.getDistrict() + userAddress.getStreet() + userAddress.getDetail();
                merchantOrder.setUserAddress(userAddressStr);
            } else {
                merchantOrder.setUserAddress("\u865a\u62df\u5546\u54c1\u65e0\u9700\u53d1\u8d27");
            }
            merchantOrder.setTotalNum(merchantOrderVo.getProTotalNum());
            merchantOrder.setProTotalPrice(merchantOrderVo.getProTotalFee());
            merchantOrder.setTotalPostage(merchantOrderVo.getFreightFee());
            merchantOrder.setTotalPrice(Double.valueOf(merchantOrder.getProTotalPrice() + merchantOrder.getTotalPostage()));
            merchantOrder.setPayPostage(merchantOrder.getTotalPostage());
            merchantOrder.setUseIntegral(merchantOrderVo.getUseIntegral());
            merchantOrder.setIntegralPrice(merchantOrderVo.getIntegralPrice());
            merchantOrder.setCouponId(merchantOrderVo.getUserCouponId());
            if (merchantOrder.getCouponId() > 0L) {
                couponIdList.add(merchantOrder.getCouponId());
            }
            merchantOrder.setCouponPrice(merchantOrderVo.getCouponFee());
            merchantOrder.setPayPrice(Double.valueOf(merchantOrder.getTotalPrice() - merchantOrder.getCouponPrice() - merchantOrder.getIntegralPrice()));
            merchantOrder.setGainIntegral(Integer.valueOf(0));
            merchantOrder.setType(Integer.valueOf(orderType));
            merchantOrderList.add(merchantOrder);
            List detailVoList = merchantOrderVo.getOrderInfoList();
            for (PreOrderDetailVo detailVo : detailVoList) {
                EbOrderDetail orderDetail = new EbOrderDetail();
                orderDetail.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
                orderDetail.setCreateTime(Long.valueOf(createTime));
                orderDetail.setOrderNo(orderNo);
                orderDetail.setMerId(merchantOrder.getMerId());
                orderDetail.setUid(Long.valueOf(userId));
                orderDetail.setProductId(detailVo.getProductId());
                orderDetail.setProductName(detailVo.getProductName());
                orderDetail.setImage(detailVo.getImage());
                orderDetail.setAttrValueId(detailVo.getAttrValueId());
                orderDetail.setSku(detailVo.getSku());
                orderDetail.setPrice(detailVo.getPrice());
                orderDetail.setPayNum(detailVo.getPayNum());
                orderDetail.setWeight(detailVo.getWeight());
                orderDetail.setVolume(detailVo.getVolume());
                orderDetail.setProductType(detailVo.getProductType());
                orderDetail.setSubBrokerageType(detailVo.getSubBrokerageType());
                orderDetail.setBrokerage(detailVo.getBrokerage());
                orderDetail.setBrokerageTwo(detailVo.getBrokerageTwo());
                orderDetail.setFreightFee(detailVo.getFreightFee());
                orderDetail.setCouponPrice(detailVo.getCouponPrice());
                orderDetail.setUseIntegral(detailVo.getUseIntegral());
                orderDetail.setIntegralPrice(detailVo.getIntegralPrice());
                orderDetail.setPayPrice(Double.valueOf(0.0));
                double detailPayPrice = orderDetail.getPrice() * (double)orderDetail.getPayNum().intValue() + orderDetail.getFreightFee() - orderDetail.getCouponPrice() - orderDetail.getIntegralPrice();
                if (detailPayPrice >= 0.0) {
                    orderDetail.setPayPrice(Double.valueOf(detailPayPrice));
                }
                orderDetailList.add(orderDetail);
            }
        }
        result[0] = merchantOrderList;
        result[1] = orderDetailList;
        return result;
    }

    public static final EbOrder acquirePlatformOrder(long userId, PreOrderVo preOrderVo) {
        List list = preOrderVo.getMerchantOrderVoList();
        EbOrder order = new EbOrder();
        order.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        order.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        String orderNo = OrderUtils.generateOrderNo("PT");
        order.setOrderNo(orderNo);
        order.setMerId(Integer.valueOf(0));
        order.setUid(Long.valueOf(userId));
        order.setTotalNum(preOrderVo.getOrderProNum());
        order.setProTotalPrice(preOrderVo.getProTotalFee());
        order.setTotalPostage(preOrderVo.getFreightFee());
        order.setTotalPrice(Double.valueOf(order.getProTotalPrice() + order.getTotalPostage()));
        order.setCouponPrice(preOrderVo.getCouponFee());
        order.setUseIntegral(Integer.valueOf(OrderUtils.calculateTotalIntegral(list)));
        order.setIntegralPrice(Double.valueOf(OrderUtils.calculateTotalIntegralPrice(list)));
        order.setPayPrice(Double.valueOf(order.getProTotalPrice() + order.getTotalPostage() - order.getCouponPrice() - order.getIntegralPrice()));
        order.setPayPostage(order.getTotalPostage());
        order.setPaid(Integer.valueOf(0));
        order.setCancelStatus(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
        order.setLevel(OrderConstants.ORDER_LEVEL_PLATFORM);
        order.setType(preOrderVo.getType());
        return order;
    }

    private static final double calculateTotalIntegralPrice(List<PreMerchantOrderVo> merchantOrderVoList) {
        double sum = 0.0;
        for (PreMerchantOrderVo vo : merchantOrderVoList) {
            sum += vo.getIntegralPrice().doubleValue();
        }
        return sum;
    }

    private static final int calculateTotalIntegral(List<PreMerchantOrderVo> merchantOrderVoList) {
        int sum = 0;
        for (PreMerchantOrderVo vo : merchantOrderVoList) {
            sum += vo.getUseIntegral().intValue();
        }
        return sum;
    }

    public static final PreOrderVo validatePreOrderRequest(PreOrderRequest request, String cdnUrl) {
        PreOrderVo vo = new PreOrderVo();
        List<Object> merchantOrderVoList = new ArrayList(4);
        String preOrderType = request.getPreOrderType();
        if (preOrderType.equals("shoppingCart")) {
            logger.info("\u9884\u4e0b\u5355\u68c0\u67e5\u8c03\u7528:\u8d2d\u7269\u8f66\u8d2d\u4e70");
            merchantOrderVoList = OrderUtils.validatePreOrderShopping(request, cdnUrl);
            List cartIdList = request.getOrderDetails().stream().map(PreOrderDetailRequest::getShoppingCartId).distinct().collect(Collectors.toList());
            vo.setCartIdList(cartIdList);
        } else if (preOrderType.equals("buyNow")) {
            logger.info("\u9884\u4e0b\u5355\u68c0\u67e5\u8c03\u7528:\u7acb\u5373\u8d2d\u4e70");
            PreOrderDetailRequest detailRequest = request.getOrderDetails().get(0);
            merchantOrderVoList.add(OrderUtils.validatePreOrderNormal(detailRequest, cdnUrl));
        } else if (preOrderType.equals("video")) {
            logger.info("\u9884\u4e0b\u5355\u68c0\u67e5\u8c03\u7528:\u89c6\u9891\u53f7\u4e0b\u5355");
            PreOrderDetailRequest detailRequest = request.getOrderDetails().get(0);
            merchantOrderVoList.add(OrderUtils.validatePreOrderVideo(detailRequest));
            vo.setType(OrderConstants.ORDER_TYPE_VIDEO);
        } else if (preOrderType.equals("seckill")) {
            logger.info("\u9884\u4e0b\u5355\u68c0\u67e5\u8c03\u7528:\u79d2\u6740\u4e0b\u5355");
            PreOrderDetailRequest detailRequest = request.getOrderDetails().get(0);
            vo.setType(OrderConstants.ORDER_TYPE_SECKILL);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u9884\u4e0b\u5355\u7c7b\u578b\uff1a" + preOrderType);
        }
        vo.setMerchantOrderVoList(merchantOrderVoList);
        return vo;
    }

    private static final List<PreMerchantOrderVo> validatePreOrderShopping(PreOrderRequest request, String cdnUrl) {
        ArrayList<PreMerchantOrderVo> merchantOrderVoList = new ArrayList<PreMerchantOrderVo>(2);
        block0: for (PreOrderDetailRequest detailRequest : request.getOrderDetails()) {
            if (detailRequest.getShoppingCartId() == null) {
                throw new PlatformRuntimeException("\u8d2d\u7269\u8f66\u7f16\u53f7\u4e0d\u5b58\u5728");
            }
            EbCart cart = (EbCart)((CartServiceImpl)((Object)BeanContextAware.getBeanByType(CartServiceImpl.class))).get((BasePo)new EbCart(detailRequest.getShoppingCartId()));
            if (cart == null) {
                throw new PlatformRuntimeException("\u8d2d\u7269\u8f66\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + detailRequest.getShoppingCartId());
            }
            detailRequest.setProductId(cart.getProductId());
            detailRequest.setAttrValueId(cart.getProductAttrUnique());
            detailRequest.setProductNum(cart.getCartNum());
            PreMerchantOrderVo merchantOrderVo = OrderUtils.validatePreOrderNormal(detailRequest, cdnUrl);
            if (merchantOrderVoList.stream().anyMatch(m -> m.getMerId().equals(merchantOrderVo.getMerId()))) {
                for (PreMerchantOrderVo orderVo : merchantOrderVoList) {
                    if (!orderVo.getMerId().equals(merchantOrderVo.getMerId())) continue;
                    orderVo.getOrderInfoList().addAll(merchantOrderVo.getOrderInfoList());
                    continue block0;
                }
                continue;
            }
            merchantOrderVoList.add(merchantOrderVo);
        }
        return merchantOrderVoList;
    }

    private static PreMerchantOrderVo validatePreOrderNormal(PreOrderDetailRequest detailRequest, String cdnUrl) {
        if (detailRequest.getProductId() == null) {
            throw new PlatformRuntimeException("\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (detailRequest.getAttrValueId() == null) {
            throw new PlatformRuntimeException("\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (detailRequest.getProductNum() == null || detailRequest.getProductNum() <= 0) {
            throw new PlatformRuntimeException("\u8d2d\u4e70\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        EbProduct product = (EbProduct)((ProductServiceImpl)BeanContextAware.getBeanByType(ProductServiceImpl.class)).get((BasePo)new EbProduct(detailRequest.getProductId()));
        if (product == null || product.getIsDel() == 1) {
            throw new PlatformRuntimeException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getIsShow() == 0) {
            throw new PlatformRuntimeException("\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getStock() < detailRequest.getProductNum()) {
            throw new PlatformRuntimeException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        EbProductAttrValue attrValue = ((ProductAttrValueServiceImpl)BeanContextAware.getBeanByType(ProductAttrValueServiceImpl.class)).queryByIdAndProductIdAndType(detailRequest.getAttrValueId(), detailRequest.getProductId(), ProductConstants.PRODUCT_TYPE_NORMAL);
        if (attrValue == null) {
            throw new PlatformRuntimeException("\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (attrValue.getStock() < detailRequest.getProductNum()) {
            throw new PlatformRuntimeException("\u5546\u54c1\u89c4\u683c\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        EbMerchant merchant = ((MerchantCache)BeanContextAware.getBeanByType(MerchantCache.class)).get(product.getMerId().intValue());
        if (merchant.getIsSwitch() == 0) {
            throw new PlatformRuntimeException("\u5546\u6237\u5df2\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
        }
        PreMerchantOrderVo merchantOrderVo = new PreMerchantOrderVo();
        merchantOrderVo.setMerId(merchant.getId());
        merchantOrderVo.setMerName(merchant.getName());
        merchantOrderVo.setFreightFee(Double.valueOf(0.0));
        merchantOrderVo.setCouponFee(Double.valueOf(0.0));
        merchantOrderVo.setUserCouponId(Long.valueOf(0L));
        merchantOrderVo.setTakeTheirSwitch(Boolean.valueOf(merchant.getIsTakeTheir() == 1));
        PreOrderDetailVo detailVo = new PreOrderDetailVo();
        detailVo.setProductId(product.getId());
        detailVo.setProductName(product.getName());
        detailVo.setAttrValueId(attrValue.getId());
        detailVo.setSku(attrValue.getSku());
        if (StringUtils.isNotEmpty((String)detailRequest.getOtherMoney())) {
            try {
                double otherMoneyValue = Double.parseDouble(detailRequest.getOtherMoney());
                detailVo.setPrice(Double.valueOf(NumberFormatUtils.scaleAccuracy2((double)otherMoneyValue)));
                detailVo.setPayPrice(detailVo.getPrice());
            }
            catch (Exception ex) {
                throw new PlatformRuntimeException("\u8f93\u5165\u91d1\u989d\u9519\u8bef\uff1a" + detailRequest.getOtherMoney());
            }
        } else {
            detailVo.setPrice(attrValue.getPrice());
            detailVo.setPayPrice(attrValue.getPrice());
        }
        detailVo.setPayNum(detailRequest.getProductNum());
        detailVo.setImage(StringUtils.isNotEmpty((String)attrValue.getImage()) ? cdnUrl + attrValue.getImage() : cdnUrl + product.getImage());
        detailVo.setVolume(attrValue.getVolume());
        detailVo.setWeight(attrValue.getWeight());
        detailVo.setTempId(product.getTempId());
        detailVo.setSubBrokerageType(product.getIsSub());
        detailVo.setBrokerage(Integer.valueOf(attrValue.getBrokerage().intValue()));
        detailVo.setBrokerageTwo(Integer.valueOf(attrValue.getBrokerageTwo().intValue()));
        if (detailVo.getSubBrokerageType() == 2) {
            ArgumentsManager argumentsManager = (ArgumentsManager)BeanContextAware.getBeanByType(ArgumentsManager.class);
            String firstRatio = argumentsManager.getVariable("retail_store_brokerage_first_ratio").getStringValue();
            String secondRatio = argumentsManager.getVariable("retail_store_brokerage_second_ratio").getStringValue();
            detailVo.setBrokerage(Integer.valueOf(StringUtils.isNotEmpty((String)firstRatio) ? Integer.parseInt(firstRatio) : 0));
            detailVo.setBrokerageTwo(Integer.valueOf(StringUtils.isNotEmpty((String)secondRatio) ? Integer.parseInt(secondRatio) : 0));
        }
        detailVo.setProductType(ProductConstants.PRODUCT_TYPE_NORMAL);
        ArrayList<PreOrderDetailVo> infoList = new ArrayList<PreOrderDetailVo>(2);
        infoList.add(detailVo);
        merchantOrderVo.setOrderInfoList(infoList);
        return merchantOrderVo;
    }

    private static final PreMerchantOrderVo validatePreOrderVideo(PreOrderDetailRequest detailRequest) {
        return new PreMerchantOrderVo();
    }
}

