/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.util;

import com.ishop.model.po.EbCart;
import com.ishop.model.po.EbCouponUser;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbUser;
import com.ishop.model.response.CartInfoResponse;
import com.ishop.model.response.CouponUserOrderResponse;
import com.ishop.model.response.IndexMerchantResponse;
import com.ishop.model.response.OrderFrontDetailResponse;
import com.ishop.model.vo.FileResultVo;
import com.ishop.model.vo.MerchantDetailVo;
import com.ishop.model.vo.MerchantIndexVo;
import com.ishop.model.vo.MerchantServiceInfoVo;
import com.ishop.model.vo.OrderFrontVo;
import com.ishop.model.vo.ProMerchantProductVo;
import com.ishop.model.vo.ProductCommonVo;
import com.ishop.model.vo.ProductMerchantVo;
import com.ishop.model.vo.UserCenterVo;
import com.ishop.model.vo.UserInfoVo;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class VoUtils {
    public static final List<IndexMerchantResponse> acquireIndexMerchantResponse(List<EbMerchant> merchantList) {
        if (StringUtils.isEmptyList(merchantList)) {
            return new ArrayList<IndexMerchantResponse>(1);
        }
        ArrayList<IndexMerchantResponse> data = new ArrayList<IndexMerchantResponse>(merchantList.size());
        IndexMerchantResponse response = null;
        for (EbMerchant merchant : merchantList) {
            response = new IndexMerchantResponse();
            response.setId(merchant.getId());
            response.setName(merchant.getName());
            response.setCoverImage(merchant.getCoverImage());
            response.setRectangleLogo(merchant.getRectangleLogo());
            response.setTypeId(merchant.getTypeId());
            response.setCategoryId(merchant.getCategoryId());
            data.add(response);
        }
        return data;
    }

    public static final CartInfoResponse acquireCartInfoResponse(EbCart cart) {
        CartInfoResponse vo = new CartInfoResponse();
        vo.setId(cart.getId());
        vo.setCartNum(cart.getCartNum());
        vo.setProductId(cart.getProductId());
        vo.setProductAttrUnique(String.valueOf(cart.getProductAttrUnique()));
        return vo;
    }

    public static final OrderFrontDetailResponse acquireOrderFrontDetailResponse(EbOrder order) {
        OrderFrontDetailResponse vo = new OrderFrontDetailResponse();
        vo.setOrderNo(order.getOrderNo());
        vo.setId(order.getId());
        vo.setMerId(order.getMerId());
        vo.setCreateTime(order.getCreateTime());
        vo.setPaid(Boolean.valueOf(order.getPaid() == 1));
        vo.setCouponPrice(order.getCouponPrice());
        vo.setIntegralPrice(order.getIntegralPrice());
        vo.setPayPostage(order.getPayPostage());
        vo.setPayPrice(order.getPayPrice());
        vo.setPayTime(order.getPayTime());
        vo.setPayType(order.getPayType());
        vo.setProTotalPrice(order.getProTotalPrice());
        vo.setStatus(order.getStatus());
        vo.setTotalNum(order.getTotalNum());
        vo.setTotalPostage(order.getTotalPostage());
        vo.setTotalPrice(order.getTotalPrice());
        vo.setType(order.getType());
        vo.setUid(order.getUid());
        vo.setUseIntegral(order.getUseIntegral());
        return vo;
    }

    public static final CouponUserOrderResponse acquireCouponUserOrder(EbCouponUser couponUser) {
        CouponUserOrderResponse vo = new CouponUserOrderResponse();
        vo.setId(couponUser.getId());
        vo.setCouponId(couponUser.getCouponId());
        vo.setCategory(couponUser.getCategory());
        vo.setMoney(couponUser.getMoney());
        vo.setMinPrice(couponUser.getMinPrice());
        vo.setMerId(couponUser.getMerId());
        vo.setName(couponUser.getName());
        vo.setStartTime(DateUtils.toShowDate((long)(couponUser.getStartTime() / 1000000L)));
        vo.setEndTime(DateUtils.toShowDate((long)(couponUser.getEndTime() / 1000000L)));
        vo.setUseTime(couponUser.getUseTime());
        return vo;
    }

    public static final OrderFrontVo acquireOrderFrontVo(EbOrder order) {
        OrderFrontVo vo = new OrderFrontVo();
        vo.setId(order.getId());
        vo.setOrderNo(order.getOrderNo());
        vo.setMerId(order.getMerId());
        vo.setCancelStatus(order.getCancelStatus());
        vo.setCouponPrice(order.getCouponPrice());
        vo.setIntegralPrice(order.getIntegralPrice());
        vo.setPaid(Boolean.valueOf(order.getPaid() == 1));
        vo.setPayPostage(order.getPayPostage());
        vo.setPayPrice(order.getPayPrice());
        vo.setPayTime(order.getPayTime());
        vo.setProTotalPrice(order.getProTotalPrice());
        vo.setStatus(order.getStatus());
        vo.setTotalNum(order.getTotalNum());
        vo.setTotalPrice(order.getTotalPrice());
        return vo;
    }

    public static final ProductCommonVo acquireProductCommonVo(EbProduct product, String cdnUrl) {
        ProductCommonVo vo = new ProductCommonVo();
        vo.setId(product.getId());
        vo.setImage(cdnUrl + product.getImage());
        vo.setName(product.getName());
        vo.setStock(product.getStock());
        vo.setSales(product.getSales());
        vo.setFicti(product.getFicti());
        vo.setUnitName(product.getUnitName());
        vo.setPrice(product.getPrice());
        vo.setOtPrice(product.getOtPrice());
        return vo;
    }

    public static final void combineMerchantInfo(MerchantDetailVo detailVo, EbMerchantInfo info) {
        detailVo.setServiceType(info.getServiceType());
        detailVo.setServiceLink(info.getServiceLink());
        detailVo.setServicePhone(info.getServicePhone());
    }

    public static final MerchantDetailVo acquireMerchantDetailVo(EbMerchant merchant) {
        MerchantDetailVo vo = new MerchantDetailVo();
        vo.setId(merchant.getId());
        vo.setAddressDetail(merchant.getAddressDetail());
        vo.setCreateTime(merchant.getCreateTime());
        vo.setIsSelf(Boolean.valueOf(merchant.getIsSelf() == 1));
        vo.setIntro(merchant.getIntro());
        vo.setName(merchant.getName());
        vo.setCity(merchant.getCity());
        vo.setProvince(merchant.getProvince());
        vo.setDistrict(merchant.getDistrict());
        vo.setLatitude(merchant.getLatitude());
        vo.setLongitude(merchant.getLongitude());
        vo.setPhone(merchant.getPhone());
        vo.setRealName(merchant.getRealName());
        vo.setQualificationPicture(merchant.getQualificationPicture());
        return vo;
    }

    public static final MerchantIndexVo acquireMerchantIndexVo(EbMerchant merchant, String cdnUrl) {
        MerchantIndexVo vo = new MerchantIndexVo();
        vo.setId(merchant.getId());
        vo.setName(merchant.getName());
        vo.setStarLevel(merchant.getStarLevel());
        vo.setCategoryId(merchant.getCategoryId());
        vo.setTypeId(merchant.getTypeId());
        vo.setIsSelf(Boolean.valueOf(merchant.getIsSelf() == 1));
        vo.setIsCollect(Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((String)merchant.getBackImage())) {
            vo.setBackImage(cdnUrl + merchant.getBackImage());
        }
        if (StringUtils.isNotEmpty((String)merchant.getAvatar())) {
            vo.setAvatar(cdnUrl + merchant.getAvatar());
        }
        return vo;
    }

    public static final MerchantServiceInfoVo acquireMerchantServiceInfoVo(EbMerchantInfo info) {
        MerchantServiceInfoVo vo = new MerchantServiceInfoVo();
        vo.setServiceType(info.getServiceType());
        vo.setServiceLink(info.getServiceLink());
        vo.setServicePhone(info.getServicePhone());
        return vo;
    }

    public static final ProMerchantProductVo acquireProMerchantProductVo(EbProduct product, String cdnUrl) {
        ProMerchantProductVo vo = new ProMerchantProductVo();
        vo.setId(product.getId());
        vo.setName(product.getName());
        vo.setFicti(product.getFicti());
        vo.setPrice(product.getPrice());
        vo.setSales(product.getSales());
        if (StringUtils.isNotEmpty((String)product.getImage())) {
            vo.setImage(cdnUrl + product.getImage());
        }
        return vo;
    }

    public static final ProductMerchantVo acquireProductMerchantVo(EbMerchant merchant, String cdnUrl) {
        ProductMerchantVo vo = new ProductMerchantVo();
        vo.setName(merchant.getName());
        vo.setTypeId(merchant.getTypeId());
        vo.setStarLevel(merchant.getStarLevel());
        vo.setSelf(Boolean.valueOf(merchant.getIsSelf() == 1));
        if (StringUtils.isNotEmpty((String)merchant.getAvatar())) {
            vo.setAvatar(cdnUrl + merchant.getAvatar());
        }
        return vo;
    }

    public static final FileResultVo acquireFileResultVo(FileInfo fileInfo, String type, String cdnUrl) {
        FileResultVo vo = new FileResultVo();
        vo.setFileName(fileInfo.getFileName());
        vo.setExtName(fileInfo.getFileExt());
        vo.setFileSize(Long.valueOf(fileInfo.getFileSize()));
        vo.setType(type);
        vo.setUrl(cdnUrl + fileInfo.getUrl());
        return vo;
    }

    public static final UserInfoVo acquireUserInfoVo(EbUser user, String cdnUrl) {
        UserInfoVo vo = new UserInfoVo();
        vo.setId(user.getId());
        vo.setAvatar(cdnUrl + user.getAvatar());
        vo.setNickname(user.getNickname());
        vo.setPhone(user.getPhone());
        vo.setBirthday(user.getBirthday());
        vo.setCity(user.getCity());
        vo.setProvince(user.getProvince());
        vo.setSex(user.getSex());
        return vo;
    }

    public static final void copyUserCenterInfo(EbUser ebUser, UserCenterVo vo, String cdnUrl) {
        vo.setId(ebUser.getId());
        vo.setExperience(ebUser.getExperience());
        vo.setIntegral(ebUser.getIntegral());
        vo.setLevel(ebUser.getLevel());
        vo.setNickname(ebUser.getNickname());
        vo.setPhone(ebUser.getPhone());
        if (StringUtils.isNotEmpty((String)ebUser.getAvatar())) {
            vo.setAvatar(cdnUrl + ebUser.getAvatar());
        }
    }

    public static final ProductCommonVo transferTo(EbProduct product, String cdnUrl) {
        ProductCommonVo vo = new ProductCommonVo();
        vo.setId(product.getId());
        vo.setName(product.getName());
        vo.setFicti(product.getFicti());
        vo.setImage(cdnUrl + product.getImage());
        vo.setPrice(product.getPrice());
        vo.setOtPrice(product.getOtPrice());
        vo.setUnitName(product.getUnitName());
        vo.setStock(product.getStock());
        vo.setSales(product.getSales());
        return vo;
    }
}

