/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.mobile.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.core.util.AESUtils;
import com.ishop.mobile.util.WxPKCS7Encoder;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.StringUtils;
import java.security.InvalidAlgorithmParameterException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class WechatUtils {
    public static final String JS_SIGN = "jsapi_ticket={0}&noncestr={1}&timestamp={2}&url={3}";
    private static final String WATERMARK = "watermark";
    private static final String APPID = "appid";

    public static final String decryptPhoneNumber(String miniAppId, String encryptData, String sessionKey, String iv) {
        String result = "";
        try {
            byte[] decryptByte = AESUtils.decrypt((byte[])Base64.decodeBase64((String)encryptData), (byte[])Base64.decodeBase64((String)sessionKey), (byte[])Base64.decodeBase64((String)iv));
            if (decryptByte == null || decryptByte.length == 0) {
                return result;
            }
            result = new String(WxPKCS7Encoder.decode(decryptByte));
            return result;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("\u89e3\u5bc6\u5fae\u4fe1\u624b\u673a\u53f7\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    public static final String getWechatOauthAccessTokenUrl(String appId, String secret, String code) {
        return MessageFormat.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid={0}&secret={1}&code={2}&grant_type=authorization_code", appId, secret, code);
    }

    public static String getJsSdkSign(String nonceStr, String ticket, String timestamp, String url) {
        String data = MessageFormat.format(JS_SIGN, ticket, nonceStr, timestamp, url);
        return DigestUtils.sha1Hex((String)data);
    }

    public static String getSign(String voJson, String signKey) throws Exception {
        Map map = (Map)JsonUtils.jsonStringToObject((String)voJson, Map.class);
        Set keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || map.get(k) == null || !StringUtils.isNotEmpty((String)map.get(k).toString())) continue;
            sb.append((String)k).append("=").append(map.get(k)).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = DigestUtils.sha1Hex((String)sb.toString()).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static String getSign(Map<String, String> map, String signKey) throws Exception {
        Set<String> keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || !StringUtils.isNotEmpty((String)map.get(k)) || map.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(map.get(k).trim()).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = MD5.getMessageDigest((byte[])sb.toString().getBytes("UTF-8")).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static final ObjectNode acquireObjectNode(String entity) {
        ObjectNode objectNode = null;
        try {
            objectNode = JsonUtils.jsonStringToObjectNode((String)entity);
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("string\u8f6cObjectNode\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
        return objectNode;
    }
}

