package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_ARTICLE *
 * @author genrator
 */
public class EbArticle_mapper extends EbArticle implements BaseMapper<EbArticle> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbArticle> ROW_MAPPER = new EbArticleRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Cid = "cid";
    public static final String Title = "title";
    public static final String Author = "author";
    public static final String Cover = "cover";
    public static final String Synopsis = "synopsis";
    public static final String Content = "content";
    public static final String Visit = "visit";
    public static final String IsHot = "is_hot";
    public static final String IsBanner = "is_banner";
    public static final String Status = "status";
    public static final String Sort = "sort";
    public static final String ProductId = "product_id";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbArticle_mapper(EbArticle ebArticle) {
        if (ebArticle == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebArticle.isset_id) {
            this.setId(ebArticle.getId());
        }
        //普通属性
        if (ebArticle.isset_cid) {
            this.setCid(ebArticle.getCid());
        }
        if (ebArticle.isset_title) {
            this.setTitle(ebArticle.getTitle());
        }
        if (ebArticle.isset_author) {
            this.setAuthor(ebArticle.getAuthor());
        }
        if (ebArticle.isset_cover) {
            this.setCover(ebArticle.getCover());
        }
        if (ebArticle.isset_synopsis) {
            this.setSynopsis(ebArticle.getSynopsis());
        }
        if (ebArticle.isset_content) {
            this.setContent(ebArticle.getContent());
        }
        if (ebArticle.isset_visit) {
            this.setVisit(ebArticle.getVisit());
        }
        if (ebArticle.isset_isHot) {
            this.setIsHot(ebArticle.getIsHot());
        }
        if (ebArticle.isset_isBanner) {
            this.setIsBanner(ebArticle.getIsBanner());
        }
        if (ebArticle.isset_status) {
            this.setStatus(ebArticle.getStatus());
        }
        if (ebArticle.isset_sort) {
            this.setSort(ebArticle.getSort());
        }
        if (ebArticle.isset_productId) {
            this.setProductId(ebArticle.getProductId());
        }
        if (ebArticle.isset_isDel) {
            this.setIsDel(ebArticle.getIsDel());
        }
        if (ebArticle.isset_createTime) {
            this.setCreateTime(ebArticle.getCreateTime());
        }
        if (ebArticle.isset_updateTime) {
            this.setUpdateTime(ebArticle.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_article.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_article";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Cid, this.getCid(), this.isset_cid);
        ib.set(Title, this.getTitle(), this.isset_title);
        ib.set(Author, this.getAuthor(), this.isset_author);
        ib.set(Cover, this.getCover(), this.isset_cover);
        ib.set(Synopsis, this.getSynopsis(), this.isset_synopsis);
        ib.set(Content, this.getContent(), this.isset_content);
        ib.set(Visit, this.getVisit(), this.isset_visit);
        ib.set(IsHot, this.getIsHot(), this.isset_isHot);
        ib.set(IsBanner, this.getIsBanner(), this.isset_isBanner);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Cid, this.getCid(), this.isset_cid);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Author, this.getAuthor(), this.isset_author);
        ub.set(Cover, this.getCover(), this.isset_cover);
        ub.set(Synopsis, this.getSynopsis(), this.isset_synopsis);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(Visit, this.getVisit(), this.isset_visit);
        ub.set(IsHot, this.getIsHot(), this.isset_isHot);
        ub.set(IsBanner, this.getIsBanner(), this.isset_isBanner);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Cid, this.getCid(), this.isset_cid);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Author, this.getAuthor(), this.isset_author);
        ub.set(Cover, this.getCover(), this.isset_cover);
        ub.set(Synopsis, this.getSynopsis(), this.isset_synopsis);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(Visit, this.getVisit(), this.isset_visit);
        ub.set(IsHot, this.getIsHot(), this.isset_isHot);
        ub.set(IsBanner, this.getIsBanner(), this.isset_isBanner);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Cid, this.getCid(), this.isset_cid);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Author, this.getAuthor(), this.isset_author);
        ub.set(Cover, this.getCover(), this.isset_cover);
        ub.set(Synopsis, this.getSynopsis(), this.isset_synopsis);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(Visit, this.getVisit(), this.isset_visit);
        ub.set(IsHot, this.getIsHot(), this.isset_isHot);
        ub.set(IsBanner, this.getIsBanner(), this.isset_isBanner);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, cid, title, author, cover, synopsis, content, visit, is_hot, is_banner, status, sort, product_id, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, cid, title, author, cover, synopsis, content, visit, is_hot, is_banner, status, sort, product_id, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbArticle mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbArticle toEbArticle() {
        return super.$clone();
    }
}

/**
 * eb_article RowMapper
 *
 * @author genrator
 */
class EbArticleRowMapper implements RowMapper<EbArticle> {

    @Override
    public EbArticle mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbArticle eb_article = new EbArticle();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Id);
        if (columnIndex > 0) {
            eb_article.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Cid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setCid(null);
            } else {
                eb_article.setCid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Title);
        if (columnIndex > 0) {
            eb_article.setTitle(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Author);
        if (columnIndex > 0) {
            eb_article.setAuthor(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Cover);
        if (columnIndex > 0) {
            eb_article.setCover(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Synopsis);
        if (columnIndex > 0) {
            eb_article.setSynopsis(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Content);
        if (columnIndex > 0) {
            eb_article.setContent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Visit);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setVisit(null);
            } else {
                eb_article.setVisit(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.IsHot);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setIsHot(null);
            } else {
                eb_article.setIsHot(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.IsBanner);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setIsBanner(null);
            } else {
                eb_article.setIsBanner(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setStatus(null);
            } else {
                eb_article.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setSort(null);
            } else {
                eb_article.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setProductId(null);
            } else {
                eb_article.setProductId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setIsDel(null);
            } else {
                eb_article.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setCreateTime(null);
            } else {
                eb_article.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbArticle_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_article.setUpdateTime(null);
            } else {
                eb_article.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_article;
    }
}
