
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_CART *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbCart extends BasePo<EbCart> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long uid = null;
    @JsonIgnore
    protected boolean isset_uid = false;

    private Integer merId = null;
    @JsonIgnore
    protected boolean isset_merId = false;

    private Long productId = null;
    @JsonIgnore
    protected boolean isset_productId = false;

    private Integer productAttrUnique = null;
    @JsonIgnore
    protected boolean isset_productAttrUnique = false;

    private Integer cartNum = null;
    @JsonIgnore
    protected boolean isset_cartNum = false;

    private Integer status = null;
    @JsonIgnore
    protected boolean isset_status = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbCart() {
    }

    /**
     * 根据主键构造对象
     */
    public EbCart(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
        this.isset_uid = true;
    }

    @JsonIgnore
    public boolean isEmptyUid() {
        return this.uid == null;
    }

    public Integer getMerId() {
        return this.merId;
    }

    public void setMerId(Integer merId) {
        this.merId = merId;
        this.isset_merId = true;
    }

    @JsonIgnore
    public boolean isEmptyMerId() {
        return this.merId == null;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
        this.isset_productId = true;
    }

    @JsonIgnore
    public boolean isEmptyProductId() {
        return this.productId == null;
    }

    public Integer getProductAttrUnique() {
        return this.productAttrUnique;
    }

    public void setProductAttrUnique(Integer productAttrUnique) {
        this.productAttrUnique = productAttrUnique;
        this.isset_productAttrUnique = true;
    }

    @JsonIgnore
    public boolean isEmptyProductAttrUnique() {
        return this.productAttrUnique == null;
    }

    public Integer getCartNum() {
        return this.cartNum;
    }

    public void setCartNum(Integer cartNum) {
        this.cartNum = cartNum;
        this.isset_cartNum = true;
    }

    @JsonIgnore
    public boolean isEmptyCartNum() {
        return this.cartNum == null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        this.isset_status = true;
    }

    @JsonIgnore
    public boolean isEmptyStatus() {
        return this.status == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("uid=").append(this.uid)
                .append("merId=").append(this.merId)
                .append("productId=").append(this.productId)
                .append("productAttrUnique=").append(this.productAttrUnique)
                .append("cartNum=").append(this.cartNum)
                .append("status=").append(this.status)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbCart $clone() {
        EbCart eb_cart = new EbCart();

        // 数据库名称
        //eb_cart.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_cart.setId(this.getId());
        }
        // 普通属性
        if (this.isset_uid) {
            eb_cart.setUid(this.getUid());
        }
        if (this.isset_merId) {
            eb_cart.setMerId(this.getMerId());
        }
        if (this.isset_productId) {
            eb_cart.setProductId(this.getProductId());
        }
        if (this.isset_productAttrUnique) {
            eb_cart.setProductAttrUnique(this.getProductAttrUnique());
        }
        if (this.isset_cartNum) {
            eb_cart.setCartNum(this.getCartNum());
        }
        if (this.isset_status) {
            eb_cart.setStatus(this.getStatus());
        }
        if (this.isset_createTime) {
            eb_cart.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_cart.setUpdateTime(this.getUpdateTime());
        }
        return eb_cart;
    }
}
