package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_CART *
 * @author genrator
 */
public class EbCart_mapper extends EbCart implements BaseMapper<EbCart> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbCart> ROW_MAPPER = new EbCartRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String MerId = "mer_id";
    public static final String ProductId = "product_id";
    public static final String ProductAttrUnique = "product_attr_unique";
    public static final String CartNum = "cart_num";
    public static final String Status = "status";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbCart_mapper(EbCart ebCart) {
        if (ebCart == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebCart.isset_id) {
            this.setId(ebCart.getId());
        }
        //普通属性
        if (ebCart.isset_uid) {
            this.setUid(ebCart.getUid());
        }
        if (ebCart.isset_merId) {
            this.setMerId(ebCart.getMerId());
        }
        if (ebCart.isset_productId) {
            this.setProductId(ebCart.getProductId());
        }
        if (ebCart.isset_productAttrUnique) {
            this.setProductAttrUnique(ebCart.getProductAttrUnique());
        }
        if (ebCart.isset_cartNum) {
            this.setCartNum(ebCart.getCartNum());
        }
        if (ebCart.isset_status) {
            this.setStatus(ebCart.getStatus());
        }
        if (ebCart.isset_createTime) {
            this.setCreateTime(ebCart.getCreateTime());
        }
        if (ebCart.isset_updateTime) {
            this.setUpdateTime(ebCart.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_cart.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_cart";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(ProductAttrUnique, this.getProductAttrUnique(), this.isset_productAttrUnique);
        ib.set(CartNum, this.getCartNum(), this.isset_cartNum);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductAttrUnique, this.getProductAttrUnique(), this.isset_productAttrUnique);
        ub.set(CartNum, this.getCartNum(), this.isset_cartNum);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductAttrUnique, this.getProductAttrUnique(), this.isset_productAttrUnique);
        ub.set(CartNum, this.getCartNum(), this.isset_cartNum);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductAttrUnique, this.getProductAttrUnique(), this.isset_productAttrUnique);
        ub.set(CartNum, this.getCartNum(), this.isset_cartNum);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, mer_id, product_id, product_attr_unique, cart_num, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, mer_id, product_id, product_attr_unique, cart_num, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbCart mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbCart toEbCart() {
        return super.$clone();
    }
}

/**
 * eb_cart RowMapper
 *
 * @author genrator
 */
class EbCartRowMapper implements RowMapper<EbCart> {

    @Override
    public EbCart mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbCart eb_cart = new EbCart();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.Id);
        if (columnIndex > 0) {
            eb_cart.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setUid(null);
            } else {
                eb_cart.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setMerId(null);
            } else {
                eb_cart.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setProductId(null);
            } else {
                eb_cart.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.ProductAttrUnique);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setProductAttrUnique(null);
            } else {
                eb_cart.setProductAttrUnique(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.CartNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setCartNum(null);
            } else {
                eb_cart.setCartNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setStatus(null);
            } else {
                eb_cart.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setCreateTime(null);
            } else {
                eb_cart.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCart_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_cart.setUpdateTime(null);
            } else {
                eb_cart.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_cart;
    }
}
