package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_COUPON_USER *
 * @author genrator
 */
public class EbCouponUser_mapper extends EbCouponUser implements BaseMapper<EbCouponUser> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbCouponUser> ROW_MAPPER = new EbCouponUserRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String CouponId = "coupon_id";
    public static final String MerId = "mer_id";
    public static final String Uid = "uid";
    public static final String Name = "name";
    public static final String Publisher = "publisher";
    public static final String Category = "category";
    public static final String ReceiveType = "receive_type";
    public static final String CouponType = "coupon_type";
    public static final String Money = "money";
    public static final String Discount = "discount";
    public static final String MinPrice = "min_price";
    public static final String StartTime = "start_time";
    public static final String EndTime = "end_time";
    public static final String UseTime = "use_time";
    public static final String Status = "status";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbCouponUser_mapper(EbCouponUser ebCouponUser) {
        if (ebCouponUser == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebCouponUser.isset_id) {
            this.setId(ebCouponUser.getId());
        }
        //普通属性
        if (ebCouponUser.isset_couponId) {
            this.setCouponId(ebCouponUser.getCouponId());
        }
        if (ebCouponUser.isset_merId) {
            this.setMerId(ebCouponUser.getMerId());
        }
        if (ebCouponUser.isset_uid) {
            this.setUid(ebCouponUser.getUid());
        }
        if (ebCouponUser.isset_name) {
            this.setName(ebCouponUser.getName());
        }
        if (ebCouponUser.isset_publisher) {
            this.setPublisher(ebCouponUser.getPublisher());
        }
        if (ebCouponUser.isset_category) {
            this.setCategory(ebCouponUser.getCategory());
        }
        if (ebCouponUser.isset_receiveType) {
            this.setReceiveType(ebCouponUser.getReceiveType());
        }
        if (ebCouponUser.isset_couponType) {
            this.setCouponType(ebCouponUser.getCouponType());
        }
        if (ebCouponUser.isset_money) {
            this.setMoney(ebCouponUser.getMoney());
        }
        if (ebCouponUser.isset_discount) {
            this.setDiscount(ebCouponUser.getDiscount());
        }
        if (ebCouponUser.isset_minPrice) {
            this.setMinPrice(ebCouponUser.getMinPrice());
        }
        if (ebCouponUser.isset_startTime) {
            this.setStartTime(ebCouponUser.getStartTime());
        }
        if (ebCouponUser.isset_endTime) {
            this.setEndTime(ebCouponUser.getEndTime());
        }
        if (ebCouponUser.isset_useTime) {
            this.setUseTime(ebCouponUser.getUseTime());
        }
        if (ebCouponUser.isset_status) {
            this.setStatus(ebCouponUser.getStatus());
        }
        if (ebCouponUser.isset_createTime) {
            this.setCreateTime(ebCouponUser.getCreateTime());
        }
        if (ebCouponUser.isset_updateTime) {
            this.setUpdateTime(ebCouponUser.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_coupon_user.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_coupon_user";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(CouponId, this.getCouponId(), this.isset_couponId);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Publisher, this.getPublisher(), this.isset_publisher);
        ib.set(Category, this.getCategory(), this.isset_category);
        ib.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ib.set(CouponType, this.getCouponType(), this.isset_couponType);
        ib.set(Money, this.getMoney(), this.isset_money);
        ib.set(Discount, this.getDiscount(), this.isset_discount);
        ib.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ib.set(StartTime, this.getStartTime(), this.isset_startTime);
        ib.set(EndTime, this.getEndTime(), this.isset_endTime);
        ib.set(UseTime, this.getUseTime(), this.isset_useTime);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Publisher, this.getPublisher(), this.isset_publisher);
        ub.set(Category, this.getCategory(), this.isset_category);
        ub.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ub.set(CouponType, this.getCouponType(), this.isset_couponType);
        ub.set(Money, this.getMoney(), this.isset_money);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(UseTime, this.getUseTime(), this.isset_useTime);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Publisher, this.getPublisher(), this.isset_publisher);
        ub.set(Category, this.getCategory(), this.isset_category);
        ub.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ub.set(CouponType, this.getCouponType(), this.isset_couponType);
        ub.set(Money, this.getMoney(), this.isset_money);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(UseTime, this.getUseTime(), this.isset_useTime);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Publisher, this.getPublisher(), this.isset_publisher);
        ub.set(Category, this.getCategory(), this.isset_category);
        ub.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ub.set(CouponType, this.getCouponType(), this.isset_couponType);
        ub.set(Money, this.getMoney(), this.isset_money);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ub.set(StartTime, this.getStartTime(), this.isset_startTime);
        ub.set(EndTime, this.getEndTime(), this.isset_endTime);
        ub.set(UseTime, this.getUseTime(), this.isset_useTime);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, coupon_id, mer_id, uid, name, publisher, category, receive_type, coupon_type, money, discount, min_price, start_time, end_time, use_time, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, coupon_id, mer_id, uid, name, publisher, category, receive_type, coupon_type, money, discount, min_price, start_time, end_time, use_time, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbCouponUser mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbCouponUser toEbCouponUser() {
        return super.$clone();
    }
}

/**
 * eb_coupon_user RowMapper
 *
 * @author genrator
 */
class EbCouponUserRowMapper implements RowMapper<EbCouponUser> {

    @Override
    public EbCouponUser mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbCouponUser eb_coupon_user = new EbCouponUser();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Id);
        if (columnIndex > 0) {
            eb_coupon_user.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.CouponId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setCouponId(null);
            } else {
                eb_coupon_user.setCouponId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setMerId(null);
            } else {
                eb_coupon_user.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setUid(null);
            } else {
                eb_coupon_user.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Name);
        if (columnIndex > 0) {
            eb_coupon_user.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Publisher);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setPublisher(null);
            } else {
                eb_coupon_user.setPublisher(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Category);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setCategory(null);
            } else {
                eb_coupon_user.setCategory(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.ReceiveType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setReceiveType(null);
            } else {
                eb_coupon_user.setReceiveType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.CouponType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setCouponType(null);
            } else {
                eb_coupon_user.setCouponType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Money);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setMoney(null);
            } else {
                eb_coupon_user.setMoney(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Discount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setDiscount(null);
            } else {
                eb_coupon_user.setDiscount(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.MinPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setMinPrice(null);
            } else {
                eb_coupon_user.setMinPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.StartTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setStartTime(null);
            } else {
                eb_coupon_user.setStartTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.EndTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setEndTime(null);
            } else {
                eb_coupon_user.setEndTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.UseTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setUseTime(null);
            } else {
                eb_coupon_user.setUseTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setStatus(null);
            } else {
                eb_coupon_user.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setCreateTime(null);
            } else {
                eb_coupon_user.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCouponUser_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon_user.setUpdateTime(null);
            } else {
                eb_coupon_user.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_coupon_user;
    }
}
