package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_COUPON *
 * @author genrator
 */
public class EbCoupon_mapper extends EbCoupon implements BaseMapper<EbCoupon> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbCoupon> ROW_MAPPER = new EbCouponRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String MerId = "mer_id";
    public static final String Name = "name";
    public static final String Publisher = "publisher";
    public static final String Category = "category";
    public static final String ReceiveType = "receive_type";
    public static final String CouponType = "coupon_type";
    public static final String Money = "money";
    public static final String Discount = "discount";
    public static final String MinPrice = "min_price";
    public static final String IsLimited = "is_limited";
    public static final String Total = "total";
    public static final String LastTotal = "last_total";
    public static final String IsTimeReceive = "is_time_receive";
    public static final String ReceiveStartTime = "receive_start_time";
    public static final String ReceiveEndTime = "receive_end_time";
    public static final String IsFixedTime = "is_fixed_time";
    public static final String UseStartTime = "use_start_time";
    public static final String UseEndTime = "use_end_time";
    public static final String Day = "day";
    public static final String Sort = "sort";
    public static final String Status = "status";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbCoupon_mapper(EbCoupon ebCoupon) {
        if (ebCoupon == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebCoupon.isset_id) {
            this.setId(ebCoupon.getId());
        }
        //普通属性
        if (ebCoupon.isset_merId) {
            this.setMerId(ebCoupon.getMerId());
        }
        if (ebCoupon.isset_name) {
            this.setName(ebCoupon.getName());
        }
        if (ebCoupon.isset_publisher) {
            this.setPublisher(ebCoupon.getPublisher());
        }
        if (ebCoupon.isset_category) {
            this.setCategory(ebCoupon.getCategory());
        }
        if (ebCoupon.isset_receiveType) {
            this.setReceiveType(ebCoupon.getReceiveType());
        }
        if (ebCoupon.isset_couponType) {
            this.setCouponType(ebCoupon.getCouponType());
        }
        if (ebCoupon.isset_money) {
            this.setMoney(ebCoupon.getMoney());
        }
        if (ebCoupon.isset_discount) {
            this.setDiscount(ebCoupon.getDiscount());
        }
        if (ebCoupon.isset_minPrice) {
            this.setMinPrice(ebCoupon.getMinPrice());
        }
        if (ebCoupon.isset_isLimited) {
            this.setIsLimited(ebCoupon.getIsLimited());
        }
        if (ebCoupon.isset_total) {
            this.setTotal(ebCoupon.getTotal());
        }
        if (ebCoupon.isset_lastTotal) {
            this.setLastTotal(ebCoupon.getLastTotal());
        }
        if (ebCoupon.isset_isTimeReceive) {
            this.setIsTimeReceive(ebCoupon.getIsTimeReceive());
        }
        if (ebCoupon.isset_receiveStartTime) {
            this.setReceiveStartTime(ebCoupon.getReceiveStartTime());
        }
        if (ebCoupon.isset_receiveEndTime) {
            this.setReceiveEndTime(ebCoupon.getReceiveEndTime());
        }
        if (ebCoupon.isset_isFixedTime) {
            this.setIsFixedTime(ebCoupon.getIsFixedTime());
        }
        if (ebCoupon.isset_useStartTime) {
            this.setUseStartTime(ebCoupon.getUseStartTime());
        }
        if (ebCoupon.isset_useEndTime) {
            this.setUseEndTime(ebCoupon.getUseEndTime());
        }
        if (ebCoupon.isset_day) {
            this.setDay(ebCoupon.getDay());
        }
        if (ebCoupon.isset_sort) {
            this.setSort(ebCoupon.getSort());
        }
        if (ebCoupon.isset_status) {
            this.setStatus(ebCoupon.getStatus());
        }
        if (ebCoupon.isset_isDel) {
            this.setIsDel(ebCoupon.getIsDel());
        }
        if (ebCoupon.isset_createTime) {
            this.setCreateTime(ebCoupon.getCreateTime());
        }
        if (ebCoupon.isset_updateTime) {
            this.setUpdateTime(ebCoupon.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_coupon.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_coupon";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Publisher, this.getPublisher(), this.isset_publisher);
        ib.set(Category, this.getCategory(), this.isset_category);
        ib.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ib.set(CouponType, this.getCouponType(), this.isset_couponType);
        ib.set(Money, this.getMoney(), this.isset_money);
        ib.set(Discount, this.getDiscount(), this.isset_discount);
        ib.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ib.set(IsLimited, this.getIsLimited(), this.isset_isLimited);
        ib.set(Total, this.getTotal(), this.isset_total);
        ib.set(LastTotal, this.getLastTotal(), this.isset_lastTotal);
        ib.set(IsTimeReceive, this.getIsTimeReceive(), this.isset_isTimeReceive);
        ib.set(ReceiveStartTime, this.getReceiveStartTime(), this.isset_receiveStartTime);
        ib.set(ReceiveEndTime, this.getReceiveEndTime(), this.isset_receiveEndTime);
        ib.set(IsFixedTime, this.getIsFixedTime(), this.isset_isFixedTime);
        ib.set(UseStartTime, this.getUseStartTime(), this.isset_useStartTime);
        ib.set(UseEndTime, this.getUseEndTime(), this.isset_useEndTime);
        ib.set(Day, this.getDay(), this.isset_day);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Publisher, this.getPublisher(), this.isset_publisher);
        ub.set(Category, this.getCategory(), this.isset_category);
        ub.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ub.set(CouponType, this.getCouponType(), this.isset_couponType);
        ub.set(Money, this.getMoney(), this.isset_money);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ub.set(IsLimited, this.getIsLimited(), this.isset_isLimited);
        ub.set(Total, this.getTotal(), this.isset_total);
        ub.set(LastTotal, this.getLastTotal(), this.isset_lastTotal);
        ub.set(IsTimeReceive, this.getIsTimeReceive(), this.isset_isTimeReceive);
        ub.set(ReceiveStartTime, this.getReceiveStartTime(), this.isset_receiveStartTime);
        ub.set(ReceiveEndTime, this.getReceiveEndTime(), this.isset_receiveEndTime);
        ub.set(IsFixedTime, this.getIsFixedTime(), this.isset_isFixedTime);
        ub.set(UseStartTime, this.getUseStartTime(), this.isset_useStartTime);
        ub.set(UseEndTime, this.getUseEndTime(), this.isset_useEndTime);
        ub.set(Day, this.getDay(), this.isset_day);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Publisher, this.getPublisher(), this.isset_publisher);
        ub.set(Category, this.getCategory(), this.isset_category);
        ub.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ub.set(CouponType, this.getCouponType(), this.isset_couponType);
        ub.set(Money, this.getMoney(), this.isset_money);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ub.set(IsLimited, this.getIsLimited(), this.isset_isLimited);
        ub.set(Total, this.getTotal(), this.isset_total);
        ub.set(LastTotal, this.getLastTotal(), this.isset_lastTotal);
        ub.set(IsTimeReceive, this.getIsTimeReceive(), this.isset_isTimeReceive);
        ub.set(ReceiveStartTime, this.getReceiveStartTime(), this.isset_receiveStartTime);
        ub.set(ReceiveEndTime, this.getReceiveEndTime(), this.isset_receiveEndTime);
        ub.set(IsFixedTime, this.getIsFixedTime(), this.isset_isFixedTime);
        ub.set(UseStartTime, this.getUseStartTime(), this.isset_useStartTime);
        ub.set(UseEndTime, this.getUseEndTime(), this.isset_useEndTime);
        ub.set(Day, this.getDay(), this.isset_day);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Publisher, this.getPublisher(), this.isset_publisher);
        ub.set(Category, this.getCategory(), this.isset_category);
        ub.set(ReceiveType, this.getReceiveType(), this.isset_receiveType);
        ub.set(CouponType, this.getCouponType(), this.isset_couponType);
        ub.set(Money, this.getMoney(), this.isset_money);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(MinPrice, this.getMinPrice(), this.isset_minPrice);
        ub.set(IsLimited, this.getIsLimited(), this.isset_isLimited);
        ub.set(Total, this.getTotal(), this.isset_total);
        ub.set(LastTotal, this.getLastTotal(), this.isset_lastTotal);
        ub.set(IsTimeReceive, this.getIsTimeReceive(), this.isset_isTimeReceive);
        ub.set(ReceiveStartTime, this.getReceiveStartTime(), this.isset_receiveStartTime);
        ub.set(ReceiveEndTime, this.getReceiveEndTime(), this.isset_receiveEndTime);
        ub.set(IsFixedTime, this.getIsFixedTime(), this.isset_isFixedTime);
        ub.set(UseStartTime, this.getUseStartTime(), this.isset_useStartTime);
        ub.set(UseEndTime, this.getUseEndTime(), this.isset_useEndTime);
        ub.set(Day, this.getDay(), this.isset_day);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mer_id, name, publisher, category, receive_type, coupon_type, money, discount, min_price, is_limited, total, last_total, is_time_receive, receive_start_time, receive_end_time, is_fixed_time, use_start_time, use_end_time, day, sort, status, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mer_id, name, publisher, category, receive_type, coupon_type, money, discount, min_price, is_limited, total, last_total, is_time_receive, receive_start_time, receive_end_time, is_fixed_time, use_start_time, use_end_time, day, sort, status, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbCoupon mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbCoupon toEbCoupon() {
        return super.$clone();
    }
}

/**
 * eb_coupon RowMapper
 *
 * @author genrator
 */
class EbCouponRowMapper implements RowMapper<EbCoupon> {

    @Override
    public EbCoupon mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbCoupon eb_coupon = new EbCoupon();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Id);
        if (columnIndex > 0) {
            eb_coupon.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setMerId(null);
            } else {
                eb_coupon.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Name);
        if (columnIndex > 0) {
            eb_coupon.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Publisher);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setPublisher(null);
            } else {
                eb_coupon.setPublisher(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Category);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setCategory(null);
            } else {
                eb_coupon.setCategory(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.ReceiveType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setReceiveType(null);
            } else {
                eb_coupon.setReceiveType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.CouponType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setCouponType(null);
            } else {
                eb_coupon.setCouponType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Money);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setMoney(null);
            } else {
                eb_coupon.setMoney(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Discount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setDiscount(null);
            } else {
                eb_coupon.setDiscount(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.MinPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setMinPrice(null);
            } else {
                eb_coupon.setMinPrice(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.IsLimited);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setIsLimited(null);
            } else {
                eb_coupon.setIsLimited(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Total);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setTotal(null);
            } else {
                eb_coupon.setTotal(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.LastTotal);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setLastTotal(null);
            } else {
                eb_coupon.setLastTotal(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.IsTimeReceive);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setIsTimeReceive(null);
            } else {
                eb_coupon.setIsTimeReceive(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.ReceiveStartTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setReceiveStartTime(null);
            } else {
                eb_coupon.setReceiveStartTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.ReceiveEndTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setReceiveEndTime(null);
            } else {
                eb_coupon.setReceiveEndTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.IsFixedTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setIsFixedTime(null);
            } else {
                eb_coupon.setIsFixedTime(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.UseStartTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setUseStartTime(null);
            } else {
                eb_coupon.setUseStartTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.UseEndTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setUseEndTime(null);
            } else {
                eb_coupon.setUseEndTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Day);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setDay(null);
            } else {
                eb_coupon.setDay(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setSort(null);
            } else {
                eb_coupon.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setStatus(null);
            } else {
                eb_coupon.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setIsDel(null);
            } else {
                eb_coupon.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setCreateTime(null);
            } else {
                eb_coupon.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCoupon_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_coupon.setUpdateTime(null);
            } else {
                eb_coupon.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_coupon;
    }
}
