
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_LEVEL *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbLevel extends BasePo<EbLevel> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private Integer experience = null;
    @JsonIgnore
    protected boolean isset_experience = false;

    private Integer isShow = null;
    @JsonIgnore
    protected boolean isset_isShow = false;

    private Integer grade = null;
    @JsonIgnore
    protected boolean isset_grade = false;

    private Integer discount = null;
    @JsonIgnore
    protected boolean isset_discount = false;

    private String icon = null;
    @JsonIgnore
    protected boolean isset_icon = false;

    private Integer isDel = null;
    @JsonIgnore
    protected boolean isset_isDel = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbLevel() {
    }

    /**
     * 根据主键构造对象
     */
    public EbLevel(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public Integer getExperience() {
        return this.experience;
    }

    public void setExperience(Integer experience) {
        this.experience = experience;
        this.isset_experience = true;
    }

    @JsonIgnore
    public boolean isEmptyExperience() {
        return this.experience == null;
    }

    public Integer getIsShow() {
        return this.isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
        this.isset_isShow = true;
    }

    @JsonIgnore
    public boolean isEmptyIsShow() {
        return this.isShow == null;
    }

    public Integer getGrade() {
        return this.grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
        this.isset_grade = true;
    }

    @JsonIgnore
    public boolean isEmptyGrade() {
        return this.grade == null;
    }

    public Integer getDiscount() {
        return this.discount;
    }

    public void setDiscount(Integer discount) {
        this.discount = discount;
        this.isset_discount = true;
    }

    @JsonIgnore
    public boolean isEmptyDiscount() {
        return this.discount == null;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.isset_icon = true;
    }

    @JsonIgnore
    public boolean isEmptyIcon() {
        return this.icon == null || this.icon.length() == 0;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
        this.isset_isDel = true;
    }

    @JsonIgnore
    public boolean isEmptyIsDel() {
        return this.isDel == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("name=").append(this.name)
                .append("experience=").append(this.experience)
                .append("isShow=").append(this.isShow)
                .append("grade=").append(this.grade)
                .append("discount=").append(this.discount)
                .append("icon=").append(this.icon)
                .append("isDel=").append(this.isDel)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbLevel $clone() {
        EbLevel eb_level = new EbLevel();

        // 数据库名称
        //eb_level.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_level.setId(this.getId());
        }
        // 普通属性
        if (this.isset_name) {
            eb_level.setName(this.getName());
        }
        if (this.isset_experience) {
            eb_level.setExperience(this.getExperience());
        }
        if (this.isset_isShow) {
            eb_level.setIsShow(this.getIsShow());
        }
        if (this.isset_grade) {
            eb_level.setGrade(this.getGrade());
        }
        if (this.isset_discount) {
            eb_level.setDiscount(this.getDiscount());
        }
        if (this.isset_icon) {
            eb_level.setIcon(this.getIcon());
        }
        if (this.isset_isDel) {
            eb_level.setIsDel(this.getIsDel());
        }
        if (this.isset_createTime) {
            eb_level.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_level.setUpdateTime(this.getUpdateTime());
        }
        return eb_level;
    }
}
