package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_LEVEL *
 * @author genrator
 */
public class EbLevel_mapper extends EbLevel implements BaseMapper<EbLevel> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbLevel> ROW_MAPPER = new EbLevelRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Name = "name";
    public static final String Experience = "experience";
    public static final String IsShow = "is_show";
    public static final String Grade = "grade";
    public static final String Discount = "discount";
    public static final String Icon = "icon";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbLevel_mapper(EbLevel ebLevel) {
        if (ebLevel == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebLevel.isset_id) {
            this.setId(ebLevel.getId());
        }
        //普通属性
        if (ebLevel.isset_name) {
            this.setName(ebLevel.getName());
        }
        if (ebLevel.isset_experience) {
            this.setExperience(ebLevel.getExperience());
        }
        if (ebLevel.isset_isShow) {
            this.setIsShow(ebLevel.getIsShow());
        }
        if (ebLevel.isset_grade) {
            this.setGrade(ebLevel.getGrade());
        }
        if (ebLevel.isset_discount) {
            this.setDiscount(ebLevel.getDiscount());
        }
        if (ebLevel.isset_icon) {
            this.setIcon(ebLevel.getIcon());
        }
        if (ebLevel.isset_isDel) {
            this.setIsDel(ebLevel.getIsDel());
        }
        if (ebLevel.isset_createTime) {
            this.setCreateTime(ebLevel.getCreateTime());
        }
        if (ebLevel.isset_updateTime) {
            this.setUpdateTime(ebLevel.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_level.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_level";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Experience, this.getExperience(), this.isset_experience);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        ib.set(Grade, this.getGrade(), this.isset_grade);
        ib.set(Discount, this.getDiscount(), this.isset_discount);
        ib.set(Icon, this.getIcon(), this.isset_icon);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Experience, this.getExperience(), this.isset_experience);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(Grade, this.getGrade(), this.isset_grade);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Experience, this.getExperience(), this.isset_experience);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(Grade, this.getGrade(), this.isset_grade);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Experience, this.getExperience(), this.isset_experience);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(Grade, this.getGrade(), this.isset_grade);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, experience, is_show, grade, discount, icon, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, experience, is_show, grade, discount, icon, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbLevel mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbLevel toEbLevel() {
        return super.$clone();
    }
}

/**
 * eb_level RowMapper
 *
 * @author genrator
 */
class EbLevelRowMapper implements RowMapper<EbLevel> {

    @Override
    public EbLevel mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbLevel eb_level = new EbLevel();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.Id);
        if (columnIndex > 0) {
            eb_level.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.Name);
        if (columnIndex > 0) {
            eb_level.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.Experience);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setExperience(null);
            } else {
                eb_level.setExperience(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setIsShow(null);
            } else {
                eb_level.setIsShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.Grade);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setGrade(null);
            } else {
                eb_level.setGrade(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.Discount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setDiscount(null);
            } else {
                eb_level.setDiscount(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.Icon);
        if (columnIndex > 0) {
            eb_level.setIcon(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setIsDel(null);
            } else {
                eb_level.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setCreateTime(null);
            } else {
                eb_level.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbLevel_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_level.setUpdateTime(null);
            } else {
                eb_level.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_level;
    }
}
