package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_APPLY *
 * @author genrator
 */
public class EbMerchantApply_mapper extends EbMerchantApply implements BaseMapper<EbMerchantApply> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantApply> ROW_MAPPER = new EbMerchantApplyRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String Name = "name";
    public static final String CategoryId = "category_id";
    public static final String TypeId = "type_id";
    public static final String Account = "account";
    public static final String Password = "password";
    public static final String RealName = "real_name";
    public static final String Email = "email";
    public static final String Phone = "phone";
    public static final String HandlingFee = "handling_fee";
    public static final String Keywords = "keywords";
    public static final String Address = "address";
    public static final String IsSelf = "is_self";
    public static final String IsRecommend = "is_recommend";
    public static final String AuditStatus = "audit_status";
    public static final String DenialReason = "denial_reason";
    public static final String AuditorId = "auditor_id";
    public static final String Remark = "remark";
    public static final String QualificationPicture = "qualification_picture";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbMerchantApply_mapper(EbMerchantApply ebMerchantApply) {
        if (ebMerchantApply == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantApply.isset_id) {
            this.setId(ebMerchantApply.getId());
        }
        //普通属性
        if (ebMerchantApply.isset_uid) {
            this.setUid(ebMerchantApply.getUid());
        }
        if (ebMerchantApply.isset_name) {
            this.setName(ebMerchantApply.getName());
        }
        if (ebMerchantApply.isset_categoryId) {
            this.setCategoryId(ebMerchantApply.getCategoryId());
        }
        if (ebMerchantApply.isset_typeId) {
            this.setTypeId(ebMerchantApply.getTypeId());
        }
        if (ebMerchantApply.isset_account) {
            this.setAccount(ebMerchantApply.getAccount());
        }
        if (ebMerchantApply.isset_password) {
            this.setPassword(ebMerchantApply.getPassword());
        }
        if (ebMerchantApply.isset_realName) {
            this.setRealName(ebMerchantApply.getRealName());
        }
        if (ebMerchantApply.isset_email) {
            this.setEmail(ebMerchantApply.getEmail());
        }
        if (ebMerchantApply.isset_phone) {
            this.setPhone(ebMerchantApply.getPhone());
        }
        if (ebMerchantApply.isset_handlingFee) {
            this.setHandlingFee(ebMerchantApply.getHandlingFee());
        }
        if (ebMerchantApply.isset_keywords) {
            this.setKeywords(ebMerchantApply.getKeywords());
        }
        if (ebMerchantApply.isset_address) {
            this.setAddress(ebMerchantApply.getAddress());
        }
        if (ebMerchantApply.isset_isSelf) {
            this.setIsSelf(ebMerchantApply.getIsSelf());
        }
        if (ebMerchantApply.isset_isRecommend) {
            this.setIsRecommend(ebMerchantApply.getIsRecommend());
        }
        if (ebMerchantApply.isset_auditStatus) {
            this.setAuditStatus(ebMerchantApply.getAuditStatus());
        }
        if (ebMerchantApply.isset_denialReason) {
            this.setDenialReason(ebMerchantApply.getDenialReason());
        }
        if (ebMerchantApply.isset_auditorId) {
            this.setAuditorId(ebMerchantApply.getAuditorId());
        }
        if (ebMerchantApply.isset_remark) {
            this.setRemark(ebMerchantApply.getRemark());
        }
        if (ebMerchantApply.isset_qualificationPicture) {
            this.setQualificationPicture(ebMerchantApply.getQualificationPicture());
        }
        if (ebMerchantApply.isset_createTime) {
            this.setCreateTime(ebMerchantApply.getCreateTime());
        }
        if (ebMerchantApply.isset_updateTime) {
            this.setUpdateTime(ebMerchantApply.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_apply.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_apply";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ib.set(TypeId, this.getTypeId(), this.isset_typeId);
        ib.set(Account, this.getAccount(), this.isset_account);
        ib.set(Password, this.getPassword(), this.isset_password);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        ib.set(Email, this.getEmail(), this.isset_email);
        ib.set(Phone, this.getPhone(), this.isset_phone);
        ib.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ib.set(Keywords, this.getKeywords(), this.isset_keywords);
        ib.set(Address, this.getAddress(), this.isset_address);
        ib.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ib.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ib.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ib.set(DenialReason, this.getDenialReason(), this.isset_denialReason);
        ib.set(AuditorId, this.getAuditorId(), this.isset_auditorId);
        ib.set(Remark, this.getRemark(), this.isset_remark);
        ib.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(TypeId, this.getTypeId(), this.isset_typeId);
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Password, this.getPassword(), this.isset_password);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Email, this.getEmail(), this.isset_email);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(Keywords, this.getKeywords(), this.isset_keywords);
        ub.set(Address, this.getAddress(), this.isset_address);
        ub.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ub.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(DenialReason, this.getDenialReason(), this.isset_denialReason);
        ub.set(AuditorId, this.getAuditorId(), this.isset_auditorId);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(TypeId, this.getTypeId(), this.isset_typeId);
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Password, this.getPassword(), this.isset_password);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Email, this.getEmail(), this.isset_email);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(Keywords, this.getKeywords(), this.isset_keywords);
        ub.set(Address, this.getAddress(), this.isset_address);
        ub.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ub.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(DenialReason, this.getDenialReason(), this.isset_denialReason);
        ub.set(AuditorId, this.getAuditorId(), this.isset_auditorId);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(TypeId, this.getTypeId(), this.isset_typeId);
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Password, this.getPassword(), this.isset_password);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Email, this.getEmail(), this.isset_email);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(Keywords, this.getKeywords(), this.isset_keywords);
        ub.set(Address, this.getAddress(), this.isset_address);
        ub.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ub.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(DenialReason, this.getDenialReason(), this.isset_denialReason);
        ub.set(AuditorId, this.getAuditorId(), this.isset_auditorId);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, name, category_id, type_id, account, password, real_name, email, phone, handling_fee, keywords, address, is_self, is_recommend, audit_status, denial_reason, auditor_id, remark, qualification_picture, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, name, category_id, type_id, account, password, real_name, email, phone, handling_fee, keywords, address, is_self, is_recommend, audit_status, denial_reason, auditor_id, remark, qualification_picture, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantApply mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantApply toEbMerchantApply() {
        return super.$clone();
    }
}

/**
 * eb_merchant_apply RowMapper
 *
 * @author genrator
 */
class EbMerchantApplyRowMapper implements RowMapper<EbMerchantApply> {

    @Override
    public EbMerchantApply mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantApply eb_merchant_apply = new EbMerchantApply();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_apply.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setUid(null);
            } else {
                eb_merchant_apply.setUid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Name);
        if (columnIndex > 0) {
            eb_merchant_apply.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.CategoryId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setCategoryId(null);
            } else {
                eb_merchant_apply.setCategoryId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.TypeId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setTypeId(null);
            } else {
                eb_merchant_apply.setTypeId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Account);
        if (columnIndex > 0) {
            eb_merchant_apply.setAccount(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Password);
        if (columnIndex > 0) {
            eb_merchant_apply.setPassword(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.RealName);
        if (columnIndex > 0) {
            eb_merchant_apply.setRealName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Email);
        if (columnIndex > 0) {
            eb_merchant_apply.setEmail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Phone);
        if (columnIndex > 0) {
            eb_merchant_apply.setPhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.HandlingFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setHandlingFee(null);
            } else {
                eb_merchant_apply.setHandlingFee(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Keywords);
        if (columnIndex > 0) {
            eb_merchant_apply.setKeywords(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Address);
        if (columnIndex > 0) {
            eb_merchant_apply.setAddress(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.IsSelf);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setIsSelf(null);
            } else {
                eb_merchant_apply.setIsSelf(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.IsRecommend);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setIsRecommend(null);
            } else {
                eb_merchant_apply.setIsRecommend(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.AuditStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setAuditStatus(null);
            } else {
                eb_merchant_apply.setAuditStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.DenialReason);
        if (columnIndex > 0) {
            eb_merchant_apply.setDenialReason(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.AuditorId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setAuditorId(null);
            } else {
                eb_merchant_apply.setAuditorId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.Remark);
        if (columnIndex > 0) {
            eb_merchant_apply.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.QualificationPicture);
        if (columnIndex > 0) {
            eb_merchant_apply.setQualificationPicture(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setCreateTime(null);
            } else {
                eb_merchant_apply.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantApply_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_apply.setUpdateTime(null);
            } else {
                eb_merchant_apply.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_merchant_apply;
    }
}
